/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.vfs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;
import org.pentaho.agilebi.vfs.MetadataToMondrianVfsFileObject;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.metadata.util.XmiParser;

public class MetadataToMondrianVfsFileContent
implements FileContent {
    private MetadataToMondrianVfsFileObject fileObject;
    private InputStream inputStream = null;
    private boolean isOpen = false;

    public MetadataToMondrianVfsFileContent(MetadataToMondrianVfsFileObject fileObject) {
        this.fileObject = fileObject;
    }

    public FileObject getFile() {
        return this.fileObject;
    }

    public long getSize() throws FileSystemException {
        return 0L;
    }

    public long getLastModifiedTime() throws FileSystemException {
        return 0L;
    }

    public void setLastModifiedTime(long arg0) throws FileSystemException {
    }

    public boolean hasAttribute(String attrName) {
        return false;
    }

    public void removeAttribute(String attrName) {
    }

    public Map getAttributes() throws FileSystemException {
        return null;
    }

    public String[] getAttributeNames() throws FileSystemException {
        return null;
    }

    public Object getAttribute(String arg0) throws FileSystemException {
        return null;
    }

    public void setAttribute(String arg0, Object arg1) throws FileSystemException {
    }

    public Certificate[] getCertificates() throws FileSystemException {
        return null;
    }

    public InputStream getInputStream() throws FileSystemException {
        try {
            XmiParser parser = new XmiParser();
            FileInputStream fis = new FileInputStream(new File(this.fileObject.getFileRef()));
            Domain domain = parser.parseXmi((InputStream)fis);
            String locale = Locale.getDefault().toString();
            if (domain.getLocales().size() > 0) {
                locale = ((LocaleType)domain.getLocales().get(0)).getCode();
            }
            if (domain.getLogicalModels().size() == 0) {
                throw new Exception("Domain " + this.fileObject.getFileRef() + " does not contain model.");
            }
            LogicalModel lModel = (LogicalModel)domain.getLogicalModels().get(0);
            if (domain.getLogicalModels().size() > 1) {
                lModel = (LogicalModel)domain.getLogicalModels().get(1);
            }
            MondrianModelExporter exporter = new MondrianModelExporter(lModel, locale);
            String mondrianSchema = exporter.createMondrianModelXML();
            this.inputStream = new ByteArrayInputStream(mondrianSchema.getBytes());
        }
        catch (Exception e) {
            throw new FileSystemException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.isOpen = true;
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return null;
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode arg0) throws FileSystemException {
        return null;
    }

    public OutputStream getOutputStream(boolean arg0) throws FileSystemException {
        return null;
    }

    public void close() throws FileSystemException {
        if (!this.isOpen) {
            return;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isOpen = false;
        this.fileObject.close();
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        return null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }
}

