/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.vfs;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.operations.FileOperations;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.pentaho.agilebi.vfs.MetadataToMondrianVfsFileContent;

public class MetadataToMondrianVfsFileObject
implements FileObject {
    private String fileRef;
    private FileContent content = null;
    private FileName name;
    private FileType type;

    public MetadataToMondrianVfsFileObject(String fileRef) {
        this.fileRef = fileRef;
        this.type = FileType.FILE;
        this.name = new MetadataToMondrianVfsFileName(fileRef, this.type);
    }

    public MetadataToMondrianVfsFileObject(String fileRef, FileType type) {
        this.fileRef = fileRef;
        this.type = type;
        this.name = new MetadataToMondrianVfsFileName(fileRef, type);
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public FileName getName() {
        return this.name;
    }

    public URL getURL() throws FileSystemException {
        URL url = null;
        try {
            url = new URL("mtm:/" + this.fileRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean exists() throws FileSystemException {
        return new File(this.fileRef).exists();
    }

    public boolean isHidden() throws FileSystemException {
        return false;
    }

    public boolean isReadable() throws FileSystemException {
        return this.exists();
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    public FileType getType() throws FileSystemException {
        return this.type;
    }

    public FileObject getParent() throws FileSystemException {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public FileObject[] getChildren() throws FileSystemException {
        return null;
    }

    public FileObject getChild(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0, NameScope arg1) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject[] findFiles(FileSelector arg0) throws FileSystemException {
        return null;
    }

    public void findFiles(FileSelector arg0, boolean arg1, List arg2) throws FileSystemException {
    }

    public boolean delete() throws FileSystemException {
        return false;
    }

    public int delete(FileSelector arg0) throws FileSystemException {
        return 0;
    }

    public void createFolder() throws FileSystemException {
    }

    public void createFile() throws FileSystemException {
    }

    public void copyFrom(FileObject arg0, FileSelector arg1) throws FileSystemException {
    }

    public void moveTo(FileObject arg0) throws FileSystemException {
    }

    public boolean canRenameTo(FileObject arg0) {
        return false;
    }

    public FileContent getContent() throws FileSystemException {
        this.content = new MetadataToMondrianVfsFileContent(this);
        return this.content;
    }

    public void close() throws FileSystemException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
    }

    public void refresh() throws FileSystemException {
    }

    public boolean isAttached() {
        return false;
    }

    public boolean isContentOpen() {
        return this.content != null && this.content.isOpen();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return null;
    }

    public class MetadataToMondrianVfsFileName
    extends AbstractFileName {
        public MetadataToMondrianVfsFileName(String absPath, FileType type) {
            super("mtm", absPath, type);
        }

        protected void appendRootUri(StringBuffer arg0, boolean arg1) {
        }

        public FileName createName(String absPath, FileType fileType) {
            MetadataToMondrianVfsFileName name = new MetadataToMondrianVfsFileName(absPath, fileType);
            return name;
        }
    }
}

