/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle.pdi;

import java.net.Socket;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.pentaho.agilebi.modeler.util.ModelerSourceFactory;
import org.pentaho.agilebi.platform.JettyServer;
import org.pentaho.agilebi.spoon.KettleModelerSource;
import org.pentaho.agilebi.spoon.OutputStepModelerSource;
import org.pentaho.agilebi.spoon.perspective.AgileBiInstaPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiSpoonInstaPlugin;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.VisualizationManager;
import org.pentaho.agilebi.vfs.MetadataToMondrianVfs;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.plugins.PluginClassTypeMapping;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;

@LifecyclePlugin(id="AgileBiPlugin")
@PluginClassTypeMapping(classTypes={GUIOption.class}, implementationClass={ObjectUtils.Null.class})
public class AgileBILifecycleListener
implements LifecycleListener,
GUIOption {
    public static int consolePort;
    private JettyServer server = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(LifeEventHandler arg0) throws LifecycleException {
        try {
            ((DefaultFileSystemManager)VFS.getManager()).addProvider("mtm", (FileProvider)new MetadataToMondrianVfs());
            int port = 9999;
            boolean portFound = false;
            int tries = 100;
            while (!portFound && tries > 0) {
                ++port;
                --tries;
                Socket sock = null;
                try {
                    sock = new Socket("localhost", port);
                }
                catch (Exception e) {
                    portFound = true;
                }
                finally {
                    if (sock == null) continue;
                    sock.close();
                }
            }
            if (!portFound) {
                throw new IllegalStateException("Could not find an open port to start the Agile-BI server on");
            }
            consolePort = port;
            this.server = new JettyServer("localhost", port);
            this.server.startServer();
            if (AgileBiSpoonInstaPlugin.isInstaviewRegistered((IPluginManager)PentahoSystem.get(IPluginManager.class))) {
                AgileBiInstaPerspective.getInstance().onStart();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ModelerSourceFactory.registerSourceType((String)OutputStepModelerSource.OUTPUTSTEP_SOURCE_TYPE, OutputStepModelerSource.class);
        ModelerSourceFactory.registerSourceType((String)KettleModelerSource.SOURCE_TYPE, KettleModelerSource.class);
        if (SpoonFactory.getInstance() != null) {
            ((Spoon)SpoonFactory.getInstance()).addFileListener((FileListener)AgileBiModelerPerspective.getInstance());
            for (IVisualization viz : VisualizationManager.getInstance().getVisualizations()) {
                ((Spoon)SpoonFactory.getInstance()).addFileListener((FileListener)viz);
            }
        }
    }

    public void onExit(LifeEventHandler arg0) throws LifecycleException {
        this.server.stopServer();
        AgileBiInstaPerspective.getInstance().shutdown();
    }

    public String getLabelText() {
        return null;
    }

    public Object getLastValue() {
        return null;
    }

    public GUIOption.DisplayType getType() {
        return null;
    }

    public void setValue(Object value) {
    }
}

