/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.IOException;
import java.io.Writer;

public class MemoryStringWriter
extends Writer {
    private int maximumBufferIncrement;
    private int cursor;
    private char[] buffer;
    private char[] singleIntArray;

    public MemoryStringWriter() {
        this(4096, 65536);
    }

    public MemoryStringWriter(int bufferSize, int maximumBufferIncrement) {
        this.maximumBufferIncrement = maximumBufferIncrement;
        this.buffer = new char[bufferSize];
        this.singleIntArray = new char[1];
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (len + off > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(this.cursor + len);
        System.arraycopy(cbuf, off, this.buffer, this.cursor, len);
        this.cursor += len;
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(char b) throws IOException {
        this.singleIntArray[0] = b;
        this.write(this.singleIntArray, 0, 1);
    }

    private void ensureSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        int computedSize = (int)Math.min((double)(this.buffer.length + 1) * 1.5, (double)(this.buffer.length + this.maximumBufferIncrement));
        int newSize = Math.max(size, computedSize);
        char[] newBuffer = new char[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.cursor);
        this.buffer = newBuffer;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public char[] toByteArray() {
        char[] retval = new char[this.cursor];
        System.arraycopy(this.buffer, 0, retval, 0, this.cursor);
        return retval;
    }

    public int getLength() {
        return this.cursor;
    }

    public char[] getRaw() {
        return this.buffer;
    }

    public String toString() {
        return new String(this.buffer, 0, this.cursor);
    }
}

