/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.ui.database;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseConnectionService;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseDialectService;
import org.pentaho.ui.xul.XulServiceCallback;

public class GwtDatabaseDialogExample
implements EntryPoint,
DatabaseDialogListener {
    GwtXulAsyncDatabaseConnectionService connService = new GwtXulAsyncDatabaseConnectionService();
    GwtXulAsyncDatabaseDialectService dialectService = new GwtXulAsyncDatabaseDialectService();
    GwtDatabaseDialog dialog;
    DatabaseTypeHelper databaseTypeHelper;
    Button button = new Button("Loading...");
    Label label = new Label("no data");
    IDatabaseConnection connection;

    public void onModuleLoad() {
        this.button.setEnabled(false);
        RootPanel.get().add((Widget)this.button);
        RootPanel.get().add((Widget)this.label);
        this.button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (GwtDatabaseDialogExample.this.connection == null) {
                    GwtDatabaseDialogExample.this.connection = new DatabaseConnection();
                    GwtDatabaseDialogExample.this.connection.setDatabaseType(GwtDatabaseDialogExample.this.databaseTypeHelper.getDatabaseTypeByName("Hypersonic"));
                    GwtDatabaseDialogExample.this.connection.setAccessType(DatabaseAccessType.NATIVE);
                    GwtDatabaseDialogExample.this.connection.setHostname("localhost");
                    GwtDatabaseDialogExample.this.connection.setName("My Connection");
                }
                GwtDatabaseDialogExample.this.dialog.setDatabaseConnection(GwtDatabaseDialogExample.this.connection);
                GwtDatabaseDialogExample.this.dialog.show();
            }
        });
        XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

            public void error(String message, Throwable error) {
            }

            public void success(List<IDatabaseType> retVal) {
                GwtDatabaseDialogExample.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
                GwtDatabaseDialogExample.this.dialog = new GwtDatabaseDialog(GwtDatabaseDialogExample.this.connService, GwtDatabaseDialogExample.this.databaseTypeHelper, "testoverlay.xul", GwtDatabaseDialogExample.this);
            }
        };
        this.dialectService.getDatabaseTypes(callback);
    }

    public void onDialogAccept(IDatabaseConnection connection) {
        this.connection = connection;
        this.label.setText(connection.getName() + ": " + connection.getDatabaseName());
    }

    public void onDialogCancel() {
        this.connection = null;
        this.label.setText("Cancel Pressed");
    }

    public void onDialogReady() {
        this.button.setText("Test...");
        this.button.setEnabled(true);
    }
}

