/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.ui.database;

import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pentaho.database.service.DatabaseConnectionService;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.test.ui.database.DatabaseDialogHarness;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.database.XulAsyncDatabaseConnectionService;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.database.event.FragmentHandler;
import org.pentaho.ui.util.Launch;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swing.SwingXulLoader;

public class SwingTest {
    DatabaseMeta database = null;

    public static void main(String[] args) {
        SwingTest harness = new SwingTest();
        try {
            InputStream in = DatabaseDialogHarness.class.getClassLoader().getResourceAsStream("org/pentaho/ui/database/resources/databasedialog.xul");
            if (in == null) {
                System.out.println("Invalid Input");
                return;
            }
            SAXReader rdr = new SAXReader();
            Document doc = rdr.read(in);
            harness.showDialog(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialog(Document doc) {
        Messages messages = new Messages();
        XulDomContainer container = null;
        try {
            container = new SwingXulLoader().loadXul("org/pentaho/ui/database/resources/databasedialog.xul", (Object)messages.getBundle());
            DatabaseConnectionService connectionService = new DatabaseConnectionService();
            DatabaseDialectService dialectService = new DatabaseDialectService();
            DatabaseTypeHelper databaseTypeHelper = new DatabaseTypeHelper(dialectService.getDatabaseTypes());
            XulAsyncDatabaseConnectionService service = new XulAsyncDatabaseConnectionService(connectionService);
            DataHandler dataHandler = new DataHandler();
            FragmentHandler fragmentHandler = new FragmentHandler();
            dataHandler.setDatabaseTypeHelper(databaseTypeHelper);
            dataHandler.setMessages(messages);
            dataHandler.setAsyncDatabaseConnectionService(service);
            dataHandler.setLaunch(new Launch());
            dataHandler.setFragmentHandler(fragmentHandler);
            fragmentHandler.setDatabaseTypeHelper(databaseTypeHelper);
            container.addEventHandler((XulEventHandler)fragmentHandler);
            container.addEventHandler((XulEventHandler)dataHandler);
            if (this.database != null) {
                container.getEventHandler("dataHandler").setData((Object)this.database);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XulDialog dialog = (XulDialog)container.getDocumentRoot().getRootElement();
        container.initialize();
        dialog.show();
        try {
            Object data = container.getEventHandler("dataHandler").getData();
            int i = 0;
            ++i;
        }
        catch (XulException e) {
            System.out.println("Error getting data");
        }
    }
}

