/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.SqlManager;

public abstract class ConnManager {
    public static final Log LOG = LogFactory.getLog((String)SqlManager.class.getName());

    public abstract String[] listDatabases();

    public abstract String[] listTables();

    public abstract String[] getColumnNames(String var1);

    public String[] getColumnNamesForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column names.");
        return null;
    }

    public abstract String getPrimaryKey(String var1);

    public abstract String toJavaType(int var1);

    public abstract String toHiveType(int var1);

    public abstract Map<String, Integer> getColumnTypes(String var1);

    public Map<String, Integer> getColumnTypes(String tableName, String sqlQuery) throws IOException {
        Map<String, Integer> columnTypes;
        if (null != tableName) {
            columnTypes = this.getColumnTypes(tableName);
        } else {
            String query = sqlQuery;
            if (query.indexOf("$CONDITIONS") == -1) {
                throw new IOException("Query [" + query + "] must contain '" + "$CONDITIONS" + "' in WHERE clause.");
            }
            columnTypes = this.getColumnTypesForQuery(query);
        }
        return columnTypes;
    }

    public boolean supportsStagingForExport() {
        return false;
    }

    public long getTableRowCount(String tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void deleteAllRecords(String tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void migrateData(String fromTable, String toTable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Integer> getColumnTypesForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column types.");
        return null;
    }

    public abstract ResultSet readTable(String var1, String[] var2) throws SQLException;

    public abstract Connection getConnection() throws SQLException;

    public abstract String getDriverClass();

    public abstract void execAndPrint(String var1);

    public abstract void importTable(ImportJobContext var1) throws IOException, ImportException;

    public void importQuery(ImportJobContext context) throws IOException, ImportException {
        throw new ImportException("This database only supports table-based imports.");
    }

    public String escapeColName(String colName) {
        return colName;
    }

    public String escapeTableName(String tableName) {
        return tableName;
    }

    public abstract void close() throws SQLException;

    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("This database does not support exports");
    }

    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("This database does not support updates");
    }

    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("Mixed update/insert is not supported against the target database yet");
    }

    public void configureDbOutputColumns(SqoopOptions options) {
        LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
        HashSet<String> updateKeysUppercase = new HashSet<String>();
        String updateKeyValue = options.getUpdateKeyCol();
        StringTokenizer stok = new StringTokenizer(updateKeyValue, ",");
        while (stok.hasMoreTokens()) {
            String nextUpdateColumn = stok.nextToken().trim();
            if (nextUpdateColumn.length() > 0) {
                updateKeys.add(nextUpdateColumn);
                updateKeysUppercase.add(nextUpdateColumn.toUpperCase());
                continue;
            }
            throw new RuntimeException("Invalid update key column value specified: '" + updateKeyValue + "'");
        }
        String[] allColNames = this.getColumnNames(options.getTableName());
        ArrayList<String> dbOutCols = new ArrayList<String>();
        for (String col : allColNames) {
            if (updateKeysUppercase.contains(col.toUpperCase())) continue;
            dbOutCols.add(col);
        }
        dbOutCols.addAll(updateKeys);
        options.setDbOutputColumns(dbOutCols.toArray(new String[dbOutCols.size()]));
    }

    public abstract void release();

    public Timestamp getCurrentDbTimestamp() {
        LOG.warn((Object)"getCurrentDbTimestamp(): Using local system timestamp.");
        return new Timestamp(System.currentTimeMillis());
    }

    public String timestampToQueryString(Timestamp ts) {
        return "'" + ts + "'";
    }

    public String datetimeToQueryString(String datetime, int columnType) {
        return "'" + datetime + "'";
    }

    public String getInputBoundsQuery(String splitByCol, String sanitizedQuery) {
        return null;
    }
}

