/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.clipboard;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.di.core.clipboard.BITMAPINFOHEADER;
import org.pentaho.di.core.clipboard.ConversionUtil;

class UncompressDibFilterInputStream
extends InputStream {
    public static final int OS_BI_BITFIELDS = 3;
    public static final int OS_BI_RGB = 0;
    private final InputStream in;
    private byte[] buffer;
    private int index = 0;
    private final boolean isCompressed;
    private short bitCount = (short)-1;
    private int redMask = -1;
    private int greenMask = -1;
    private int blueMask = -1;

    public UncompressDibFilterInputStream(InputStream bmpFileStream) throws IOException {
        this.in = bmpFileStream;
        this.buffer = new byte[40];
        this.in.read(this.buffer, 0, this.buffer.length);
        BITMAPINFOHEADER origInfoHeader = new BITMAPINFOHEADER();
        ConversionUtil.fromBytes(origInfoHeader, this.buffer, 0);
        boolean bl = this.isCompressed = origInfoHeader.biCompression == 3;
        if (this.isCompressed) {
            this.bitCount = origInfoHeader.biBitCount;
            origInfoHeader.biCompression = 0;
            origInfoHeader.biSizeImage = 0;
            ConversionUtil.toBytes(origInfoHeader, this.buffer, 0);
            byte[] redMaskBytes = new byte[4];
            byte[] greenMaskBytes = new byte[4];
            byte[] blueMaskBytes = new byte[4];
            this.in.read(redMaskBytes);
            this.in.read(greenMaskBytes);
            this.in.read(blueMaskBytes);
            this.redMask = ConversionUtil.bytesToInt(redMaskBytes, 0);
            this.greenMask = ConversionUtil.bytesToInt(greenMaskBytes, 0);
            this.blueMask = ConversionUtil.bytesToInt(blueMaskBytes, 0);
        }
    }

    public int read() throws IOException {
        if (this.index < this.buffer.length) {
            byte b = this.buffer[this.index++];
            return 0xFF & b;
        }
        if (this.isCompressed) {
            switch (this.bitCount) {
                case 16: {
                    byte[] pixelBytes = new byte[2];
                    this.in.read(pixelBytes);
                    short pixel = ConversionUtil.bytesToShort(pixelBytes, 0);
                    int red = UncompressDibFilterInputStream.deMask(pixel, this.redMask);
                    int green = UncompressDibFilterInputStream.deMask(pixel, this.greenMask);
                    int blue = UncompressDibFilterInputStream.deMask(pixel, this.blueMask);
                    short a = (short)(0x1F & blue);
                    short b = (short)(0x3E0 & green >> 1 << 5);
                    short c = (short)(0x7C00 & red << 10);
                    short newPixel = (short)(a + b + c);
                    this.buffer = new byte[2];
                    ConversionUtil.shortToBytes(newPixel, this.buffer, 0);
                    this.index = 1;
                    return 0xFF & this.buffer[0];
                }
            }
        }
        return this.in.read();
    }

    private static int deMask(int val, int mask) {
        int a = val & mask;
        while (mask % 2 == 0) {
            a >>= 1;
            mask >>= 1;
        }
        return a;
    }
}

