/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Catalog;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseMetaInformation;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.database.SAPR3DatabaseMeta;
import org.pentaho.di.core.database.Schema;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransProfileFactory;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.GetDatabaseInfoProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetPreviewTableProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetQueryFieldsProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetTableSizeProgressDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.StepFieldsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DatabaseExplorerDialogLegacy
extends Dialog {
    private LogChannelInterface log;
    private PropsUI props;
    private DatabaseMeta dbMeta;
    private DBCache dbcache;
    private static final Class<?> PKG = DatabaseExplorerDialogLegacy.class;
    private static final String STRING_CATALOG = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Catalogs.Label", (String[])new String[0]);
    private static final String STRING_SCHEMAS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Schemas.Label", (String[])new String[0]);
    private static final String STRING_TABLES = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Tables.Label", (String[])new String[0]);
    private static final String STRING_VIEWS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Views.Label", (String[])new String[0]);
    private static final String STRING_SYNONYMS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Synonyms.Label", (String[])new String[0]);
    private Shell parent;
    private Shell shell;
    private Tree wTree;
    private TreeItem tiTree;
    private Button wOK;
    private Button wRefresh;
    private Button wCancel;
    private String tableName;
    private boolean justLook;
    private String selectedSchema;
    private String selectedTable;
    private List<DatabaseMeta> databases;
    private boolean splitSchemaAndTable;
    private String schemaName;
    private Composite buttonsComposite;
    private Button bPrev;
    private Button bPrevN;
    private Button bCount;
    private Button bShow;
    private Button bDDL;
    private Button bDDL2;
    private Button bSQL;
    private String activeSchemaTable;
    private Button bTruncate;
    FormData fdexpandAll;
    FormData fdcollapseAll;
    private ToolItem expandAll;
    private ToolItem collapseAll;

    public DatabaseExplorerDialogLegacy(Shell parent, int style, DatabaseMeta conn, List<DatabaseMeta> databases) {
        this(parent, style, conn, databases, false, false);
    }

    public DatabaseExplorerDialogLegacy(Shell parent, int style, DatabaseMeta conn, List<DatabaseMeta> databases, boolean look) {
        this(parent, style, conn, databases, look, false);
    }

    public DatabaseExplorerDialogLegacy(Shell parent, int style, DatabaseMeta conn, List<DatabaseMeta> databases, boolean look, boolean splitSchemaAndTable) {
        super(parent, style);
        this.parent = parent;
        this.dbMeta = conn;
        this.databases = databases;
        this.justLook = look;
        this.splitSchemaAndTable = splitSchemaAndTable;
        this.selectedSchema = null;
        this.selectedTable = null;
        this.props = PropsUI.getInstance();
        this.log = new LogChannel((Object)"DBExplorer");
        this.dbcache = DBCache.getInstance();
    }

    public void setSelectedTable(String selectedTable) {
        this.selectedTable = selectedTable;
    }

    public Object open() {
        this.tableName = null;
        this.shell = Const.isLinux() ? new Shell(this.parent, 68848) : new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageConnection());
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Title", (String[])new String[]{this.dbMeta.toString()}));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.addButtons();
        this.refreshButtons(null);
        this.wTree = new Tree((Composite)this.shell, 2052);
        this.props.setLook((Control)this.wTree);
        if (!this.getData()) {
            return null;
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wRefresh = new Button((Composite)this.shell, 8);
        this.wRefresh.setText(BaseMessages.getString(PKG, (String)"System.Button.Refresh", (String[])new String[0]));
        if (!this.justLook) {
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        }
        FormData fdTree = new FormData();
        int margin = 10;
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment((Control)this.buttonsComposite, -margin);
        fdTree.bottom = new FormAttachment(100, -50);
        this.wTree.setLayoutData((Object)fdTree);
        if (!this.justLook) {
            BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel, this.wRefresh}, margin, null);
            this.wCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    DatabaseExplorerDialogLegacy.this.log.logBasic("SelectTableDialog", new Object[]{"CANCEL SelectTableDialog", null});
                    DatabaseExplorerDialogLegacy.this.dbMeta = null;
                    DatabaseExplorerDialogLegacy.this.dispose();
                }
            });
        } else {
            BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wRefresh}, margin, null);
        }
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DatabaseExplorerDialogLegacy.this.handleOK();
            }
        });
        this.wRefresh.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DatabaseExplorerDialogLegacy.this.getData();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.refreshButtons(DatabaseExplorerDialogLegacy.this.getSchemaTable());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.openSchema(e);
            }
        };
        this.wTree.addSelectionListener((SelectionListener)selAdapter);
        this.wTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    DatabaseExplorerDialogLegacy.this.setTreeMenu();
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DatabaseExplorerDialogLegacy.this.dispose();
            }
        });
        BaseStepDialog.setSize(this.shell, 320, 480, true);
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.tableName;
    }

    private void addButtons() {
        this.buttonsComposite = new Composite((Composite)this.shell, 0);
        this.props.setLook((Control)this.buttonsComposite);
        this.buttonsComposite.setLayout((Layout)new FormLayout());
        this.activeSchemaTable = null;
        ToolBar treeTb = new ToolBar((Composite)this.shell, 0x800100);
        this.expandAll = new ToolItem(treeTb, 8);
        this.expandAll.setImage(GUIResource.getInstance().getImageExpandAll());
        this.collapseAll = new ToolItem(treeTb, 8);
        this.collapseAll.setImage(GUIResource.getInstance().getImageCollapseAll());
        this.fdexpandAll = new FormData();
        this.fdexpandAll.right = new FormAttachment(100, 0);
        this.fdexpandAll.top = new FormAttachment(0, 0);
        treeTb.setLayoutData((Object)this.fdexpandAll);
        this.expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatabaseExplorerDialogLegacy.this.expandAllItems(DatabaseExplorerDialogLegacy.this.wTree.getItems(), true);
            }
        });
        this.collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DatabaseExplorerDialogLegacy.this.expandAllItems(DatabaseExplorerDialogLegacy.this.wTree.getItems(), false);
            }
        });
        this.bPrev = new Button(this.buttonsComposite, 8);
        this.bPrev.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Preview100", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bPrev.setEnabled(this.activeSchemaTable != null);
        this.bPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.previewTable(DatabaseExplorerDialogLegacy.this.activeSchemaTable, false);
            }
        });
        FormData prevData = new FormData();
        prevData.left = new FormAttachment(0, 0);
        prevData.right = new FormAttachment(100, 0);
        prevData.top = new FormAttachment(0, 0);
        this.bPrev.setLayoutData((Object)prevData);
        this.bPrevN = new Button(this.buttonsComposite, 8);
        this.bPrevN.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.PreviewN", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bPrevN.setEnabled(this.activeSchemaTable != null);
        this.bPrevN.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.previewTable(DatabaseExplorerDialogLegacy.this.activeSchemaTable, true);
            }
        });
        FormData prevNData = new FormData();
        prevNData.left = new FormAttachment(0, 0);
        prevNData.right = new FormAttachment(100, 0);
        prevNData.top = new FormAttachment((Control)this.bPrev, 4);
        this.bPrevN.setLayoutData((Object)prevNData);
        this.bCount = new Button(this.buttonsComposite, 8);
        this.bCount.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowSize", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bCount.setEnabled(this.activeSchemaTable != null);
        this.bCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.showCount(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        FormData countData = new FormData();
        countData.left = new FormAttachment(0, 0);
        countData.right = new FormAttachment(100, 0);
        countData.top = new FormAttachment((Control)this.bPrevN, 4);
        this.bCount.setLayoutData((Object)countData);
        this.bShow = new Button(this.buttonsComposite, 8);
        this.bShow.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowLayout", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bShow.setEnabled(this.activeSchemaTable != null);
        this.bShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.showTable(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        FormData showData = new FormData();
        showData.left = new FormAttachment(0, 0);
        showData.right = new FormAttachment(100, 0);
        showData.top = new FormAttachment((Control)this.bCount, 28);
        this.bShow.setLayoutData((Object)showData);
        this.bDDL = new Button(this.buttonsComposite, 8);
        this.bDDL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDL", (String[])new String[0]));
        this.bDDL.setEnabled(this.activeSchemaTable != null);
        this.bDDL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.getDDL(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        FormData ddlData = new FormData();
        ddlData.left = new FormAttachment(0, 0);
        ddlData.right = new FormAttachment(100, 0);
        ddlData.top = new FormAttachment((Control)this.bShow, 4);
        this.bDDL.setLayoutData((Object)ddlData);
        this.bDDL2 = new Button(this.buttonsComposite, 8);
        this.bDDL2.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDLOtherConn", (String[])new String[0]));
        this.bDDL2.setEnabled(this.activeSchemaTable != null);
        this.bDDL2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.getDDLForOther(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        this.bDDL2.setEnabled(this.databases != null);
        FormData ddl2Data = new FormData();
        ddl2Data.left = new FormAttachment(0, 0);
        ddl2Data.right = new FormAttachment(100, 0);
        ddl2Data.top = new FormAttachment((Control)this.bDDL, 4);
        this.bDDL2.setLayoutData((Object)ddl2Data);
        this.bSQL = new Button(this.buttonsComposite, 8);
        this.bSQL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.OpenSQL", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bSQL.setEnabled(this.activeSchemaTable != null);
        this.bSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.getSQL(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        FormData sqlData = new FormData();
        sqlData.left = new FormAttachment(0, 0);
        sqlData.right = new FormAttachment(100, 0);
        sqlData.top = new FormAttachment((Control)this.bDDL2, 4);
        this.bSQL.setLayoutData((Object)sqlData);
        this.bTruncate = new Button(this.buttonsComposite, 8);
        this.bTruncate.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Truncate", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bTruncate.setEnabled(this.activeSchemaTable != null);
        this.bTruncate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialogLegacy.this.getTruncate(DatabaseExplorerDialogLegacy.this.activeSchemaTable);
            }
        });
        FormData truncateData = new FormData();
        truncateData.left = new FormAttachment(0, 0);
        truncateData.right = new FormAttachment(100, 0);
        truncateData.top = new FormAttachment((Control)this.bSQL, 28);
        this.bTruncate.setLayoutData((Object)truncateData);
        FormData fdComposite = new FormData();
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 20);
        this.buttonsComposite.setLayoutData((Object)fdComposite);
    }

    private void expandAllItems(TreeItem[] treeitems, boolean expand) {
        for (TreeItem item : treeitems) {
            item.setExpanded(expand);
            if (item.getItemCount() <= 0) continue;
            this.expandAllItems(item.getItems(), expand);
        }
    }

    private void refreshButtons(String table) {
        this.activeSchemaTable = table;
        this.bPrev.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Preview100", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bPrev.setEnabled(table != null);
        this.bPrevN.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.PreviewN", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bPrevN.setEnabled(table != null);
        this.bCount.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowSize", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bCount.setEnabled(table != null);
        this.bShow.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowLayout", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bShow.setEnabled(table != null);
        this.bDDL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDL", (String[])new String[0]));
        this.bDDL.setEnabled(table != null);
        this.bDDL2.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDLOtherConn", (String[])new String[0]));
        this.bDDL2.setEnabled(table != null);
        this.bSQL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.OpenSQL", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bSQL.setEnabled(table != null);
        this.bTruncate.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Truncate", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bTruncate.setEnabled(table != null);
        this.shell.layout(true, true);
    }

    private boolean getData() {
        GetDatabaseInfoProgressDialog gdipd = new GetDatabaseInfoProgressDialog(this.shell, this.dbMeta);
        DatabaseMetaInformation dmi = gdipd.open();
        if (dmi != null) {
            Schema[] schemas;
            if (this.tiTree != null && !this.tiTree.isDisposed()) {
                this.tiTree.dispose();
            }
            this.tiTree = new TreeItem(this.wTree, 0);
            this.tiTree.setImage(GUIResource.getInstance().getImageFolderConnections());
            this.tiTree.setText(this.dbMeta == null ? "" : this.dbMeta.getName());
            Catalog[] catalogs = dmi.getCatalogs();
            if (catalogs != null) {
                TreeItem tiCat = new TreeItem(this.tiTree, 0);
                tiCat.setImage(GUIResource.getInstance().getImageBol());
                tiCat.setText(STRING_CATALOG);
                for (int i = 0; i < catalogs.length; ++i) {
                    TreeItem newCat = new TreeItem(tiCat, 0);
                    newCat.setImage(GUIResource.getInstance().getImageConnection());
                    newCat.setText(catalogs[i].getCatalogName());
                    for (int j = 0; j < catalogs[i].getItems().length; ++j) {
                        String tableName = catalogs[i].getItems()[j];
                        TreeItem ti = new TreeItem(newCat, 0);
                        ti.setImage(GUIResource.getInstance().getImageTable());
                        ti.setText(tableName);
                    }
                }
            }
            if ((schemas = dmi.getSchemas()) != null) {
                TreeItem tiSch = new TreeItem(this.tiTree, 0);
                tiSch.setImage(GUIResource.getInstance().getImageBol());
                tiSch.setText(STRING_SCHEMAS);
                for (int i = 0; i < schemas.length; ++i) {
                    TreeItem newSch = new TreeItem(tiSch, 0);
                    newSch.setImage(GUIResource.getInstance().getImageSchema());
                    newSch.setText(schemas[i].getSchemaName());
                    for (int j = 0; j < schemas[i].getItems().length; ++j) {
                        String tableName = schemas[i].getItems()[j];
                        TreeItem ti = new TreeItem(newSch, 0);
                        ti.setImage(GUIResource.getInstance().getImageTable());
                        ti.setText(tableName);
                    }
                }
            }
            TreeItem tiTab = null;
            String[] tabnames = dmi.getTables();
            if (tabnames != null) {
                tiTab = new TreeItem(this.tiTree, 0);
                tiTab.setImage(GUIResource.getInstance().getImageBol());
                tiTab.setText(STRING_TABLES);
                tiTab.setExpanded(true);
                for (int i = 0; i < tabnames.length; ++i) {
                    TreeItem newTab = new TreeItem(tiTab, 0);
                    newTab.setImage(GUIResource.getInstance().getImageTable());
                    newTab.setText(tabnames[i]);
                }
            }
            TreeItem tiView = null;
            String[] views = dmi.getViews();
            if (views != null) {
                tiView = new TreeItem(this.tiTree, 0);
                tiView.setImage(GUIResource.getInstance().getImageBol());
                tiView.setText(STRING_VIEWS);
                for (int i = 0; i < views.length; ++i) {
                    TreeItem newView = new TreeItem(tiView, 0);
                    newView.setImage(GUIResource.getInstance().getImageView());
                    newView.setText(views[i]);
                }
            }
            TreeItem tiSyn = null;
            String[] syn = dmi.getSynonyms();
            if (syn != null) {
                tiSyn = new TreeItem(this.tiTree, 0);
                tiSyn.setImage(GUIResource.getInstance().getImageBol());
                tiSyn.setText(STRING_SYNONYMS);
                for (int i = 0; i < syn.length; ++i) {
                    TreeItem newSyn = new TreeItem(tiSyn, 0);
                    newSyn.setImage(GUIResource.getInstance().getImageSynonym());
                    newSyn.setText(syn[i]);
                }
            }
            if (!Const.isEmpty((String)this.selectedTable)) {
                TreeItem ti = null;
                if (ti == null && tiTab != null) {
                    ti = ConstUI.findTreeItem(tiTab, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && tiView != null) {
                    ti = ConstUI.findTreeItem(tiView, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && this.tiTree != null) {
                    ti = ConstUI.findTreeItem(this.tiTree, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && tiSyn != null) {
                    ti = ConstUI.findTreeItem(tiSyn, this.selectedSchema, this.selectedTable);
                }
                if (ti != null) {
                    this.wTree.setSelection(new TreeItem[]{ti});
                    this.wTree.showSelection();
                    this.refreshButtons(this.dbMeta.getQuotedSchemaTableCombination(this.selectedSchema, this.selectedTable));
                }
                this.selectedTable = null;
            }
        } else {
            return false;
        }
        this.tiTree.setExpanded(true);
        return true;
    }

    private String getSchemaTable() {
        TreeItem parent;
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1 && (parent = ti[0].getParentItem()) != null) {
            String schemaName = parent.getText();
            String tableName = ti[0].getText();
            if (ti[0].getItemCount() == 0) {
                String tab = null;
                tab = schemaName.equalsIgnoreCase(STRING_TABLES) || schemaName.equalsIgnoreCase(STRING_VIEWS) || schemaName.equalsIgnoreCase(STRING_SYNONYMS) || schemaName != null && schemaName.length() == 0 ? tableName : this.dbMeta.getQuotedSchemaTableCombination(schemaName, tableName);
                return tab;
            }
        }
        return null;
    }

    public void setTreeMenu() {
        final String table = this.getSchemaTable();
        if (table != null) {
            Menu mTree = new Menu((Decorations)this.shell, 8);
            MenuItem miPrev = new MenuItem(mTree, 8);
            miPrev.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Preview100", (String[])new String[]{table}));
            miPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.previewTable(table, false);
                }
            });
            MenuItem miPrevN = new MenuItem(mTree, 8);
            miPrevN.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.PreviewN", (String[])new String[]{table}));
            miPrevN.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.previewTable(table, true);
                }
            });
            MenuItem miCount = new MenuItem(mTree, 8);
            miCount.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowSize", (String[])new String[]{table}));
            miCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.showCount(table);
                }
            });
            new MenuItem(mTree, 2);
            MenuItem miShow = new MenuItem(mTree, 8);
            miShow.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ShowLayout", (String[])new String[]{table}));
            miShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.showTable(table);
                }
            });
            MenuItem miDDL = new MenuItem(mTree, 8);
            miDDL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDL", (String[])new String[0]));
            miDDL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.getDDL(table);
                }
            });
            MenuItem miDDL2 = new MenuItem(mTree, 8);
            miDDL2.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.GenDDLOtherConn", (String[])new String[0]));
            miDDL2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.getDDLForOther(table);
                }
            });
            miDDL2.setEnabled(this.databases != null);
            MenuItem miSQL = new MenuItem(mTree, 8);
            miSQL.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.OpenSQL", (String[])new String[]{table}));
            miSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.getSQL(table);
                }
            });
            new MenuItem(mTree, 2);
            MenuItem miProfile = new MenuItem(mTree, 8);
            miProfile.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.ProfileTable", (String[])new String[]{table}));
            miProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialogLegacy.this.profileTable(table);
                }
            });
            this.wTree.setMenu(mTree);
        } else {
            this.wTree.setMenu(null);
        }
    }

    public void previewTable(String tableName, boolean asklimit) {
        GetPreviewTableProgressDialog pd;
        List<Object[]> rows;
        String lineText;
        String shellText;
        EnterNumberDialog end;
        int samples;
        int limit = 100;
        if (asklimit && (samples = (end = new EnterNumberDialog(this.shell, limit, shellText = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.PreviewTable.Title", (String[])new String[0]), lineText = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.PreviewTable.Message", (String[])new String[0]))).open()) >= 0) {
            limit = samples;
        }
        if ((rows = (pd = new GetPreviewTableProgressDialog(this.shell, this.dbMeta, null, tableName, limit)).open()) != null) {
            if (rows.size() > 0) {
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.dbMeta, 0, tableName, pd.getRowMeta(), rows);
                prd.open();
            } else {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public void showTable(String tableName) {
        String sql = this.dbMeta.getSQLQueryFields(tableName);
        GetQueryFieldsProgressDialog pd = new GetQueryFieldsProgressDialog(this.shell, this.dbMeta, sql);
        RowMetaInterface result = pd.open();
        if (result != null) {
            StepFieldsDialog sfd = new StepFieldsDialog(this.shell, (VariableSpace)this.dbMeta, 0, tableName, result);
            sfd.open();
        }
    }

    public void showCount(String tableName) {
        GetTableSizeProgressDialog pd = new GetTableSizeProgressDialog(this.shell, this.dbMeta, tableName);
        Long size = pd.open();
        if (size != null) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Message", (String[])new String[]{tableName, size.toString()}));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Title", (String[])new String[0]));
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDDL(String tableName) {
        Database db = new Database(this.dbMeta);
        try {
            db.connect();
            RowMetaInterface r = db.getTableFields(tableName);
            String sql = db.getCreateTableStatement(tableName, r, null, false, null, true);
            SQLEditor se = new SQLEditor((VariableSpace)this.dbMeta, this.shell, 0, this.dbMeta, this.dbcache, sql);
            se.open();
        }
        catch (KettleDatabaseException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.RetrieveLayout", (String[])new String[0]), (Exception)((Object)dbe));
        }
        finally {
            db.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getDDLForOther(String tableName) {
        if (this.databases != null) {
            Database db = new Database(this.dbMeta);
            try {
                db.connect();
                RowMetaInterface r = db.getTableFields(tableName);
                ArrayList<DatabaseMeta> dbs = new ArrayList<DatabaseMeta>();
                for (int i = 0; i < this.databases.size(); ++i) {
                    if (this.databases.get(i).getDatabaseInterface() instanceof SAPR3DatabaseMeta) continue;
                    dbs.add(this.databases.get(i));
                }
                String[] conn = new String[dbs.size()];
                for (int i = 0; i < conn.length; ++i) {
                    conn[i] = ((DatabaseMeta)dbs.get(i)).getName();
                }
                EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, conn, BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Message", (String[])new String[0]));
                String target = esd.open();
                if (target == null) return;
                DatabaseMeta targetdbi = DatabaseMeta.findDatabase(dbs, (String)target);
                Database targetdb = new Database(targetdbi);
                String sql = targetdb.getCreateTableStatement(tableName, r, null, false, null, true);
                SQLEditor se = new SQLEditor((VariableSpace)this.dbMeta, this.shell, 0, this.dbMeta, this.dbcache, sql);
                se.open();
                return;
            }
            catch (KettleDatabaseException dbe) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.GenDDL", (String[])new String[0]), (Exception)((Object)dbe));
                return;
            }
            finally {
                db.disconnect();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 2);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Title", (String[])new String[0]));
            mb.open();
        }
    }

    public void getSQL(String tableName) {
        SQLEditor sql = new SQLEditor((VariableSpace)this.dbMeta, this.shell, 0, this.dbMeta, this.dbcache, "SELECT * FROM " + tableName);
        sql.open();
    }

    public void profileTable(String tableName) {
        try {
            TransProfileFactory profileFactory = new TransProfileFactory(this.dbMeta, tableName);
            TransMeta transMeta = profileFactory.generateTransformation((LoggingObjectInterface)new LoggingObject((Object)tableName));
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, transMeta, new String[]{"calc stats"}, new int[]{25000});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Trans trans = progressDialog.getTrans();
                String loggingText = progressDialog.getLoggingText();
                if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)transMeta, 0, "calc stats", progressDialog.getPreviewRowsMeta("calc stats"), progressDialog.getPreviewRows("calc stats"), loggingText);
                prd.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.UnexpectedProfilingError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.UnexpectedProfilingError.Message", (String[])new String[0]), e);
        }
    }

    public void getTruncate(String activeSchemaTable) {
        SQLEditor sql = new SQLEditor((VariableSpace)this.dbMeta, this.shell, 0, this.dbMeta, this.dbcache, "-- TRUNCATE TABLE " + activeSchemaTable);
        sql.open();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void handleOK() {
        if (this.justLook) {
            this.dispose();
            return;
        }
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            String table = ti[0].getText();
            String[] path = ConstUI.getTreeStrings(ti[0]);
            if (path.length == 3 && (STRING_TABLES.equalsIgnoreCase(path[1]) || STRING_VIEWS.equalsIgnoreCase(path[1]) || STRING_SYNONYMS.equalsIgnoreCase(path[1]))) {
                String[] st;
                this.schemaName = null;
                this.tableName = table;
                if (this.dbMeta.getDatabaseInterface() instanceof MSSQLServerDatabaseMeta && (st = this.tableName.split("\\.", 2)).length > 1) {
                    this.schemaName = st[0];
                    this.tableName = st[1];
                }
                this.dispose();
            }
            if (path.length == 4 && (STRING_SCHEMAS.equals(path[1]) || STRING_CATALOG.equals(path[1]))) {
                if (this.splitSchemaAndTable) {
                    this.schemaName = path[2];
                    this.tableName = path[3];
                } else {
                    this.schemaName = null;
                    this.tableName = this.dbMeta.getQuotedSchemaTableCombination(path[2], path[3]);
                }
                this.dispose();
            }
        }
    }

    public void openSchema(SelectionEvent e) {
        TreeItem up3;
        TreeItem up2;
        TreeItem sel = (TreeItem)e.item;
        TreeItem up1 = sel.getParentItem();
        if (up1 != null && (up2 = up1.getParentItem()) != null && (up3 = up2.getParentItem()) != null) {
            this.tableName = sel.getText();
            if (!this.justLook) {
                this.handleOK();
            } else {
                this.previewTable(this.tableName, false);
            }
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isSplitSchemaAndTable() {
        return this.splitSchemaAndTable;
    }

    public void setSplitSchemaAndTable(boolean splitSchemaAndTable) {
        this.splitSchemaAndTable = splitSchemaAndTable;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }

    public void setSelectedSchema(String selectSchema) {
        this.selectedSchema = selectSchema;
    }
}

