/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.database.dialog.XulDatabaseExplorerController;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.DefaultSettingsManager;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XulDatabaseExplorerDialog {
    private static final Class<?> PKG = XulDatabaseExplorerDialog.class;
    private Shell shell;
    private XulDomContainer container;
    private XulRunner runner;
    private XulDatabaseExplorerController controller;
    private DatabaseMeta databaseMeta;
    private List<DatabaseMeta> databases;
    private static Log logger = LogFactory.getLog(XulDatabaseExplorerDialog.class);
    private static final String XUL = "org/pentaho/di/ui/core/database/dialog/database_explorer.xul";
    private boolean look;
    private String schemaName;
    private String selectedTable;

    public XulDatabaseExplorerDialog(Shell aShell, DatabaseMeta aDatabaseMeta, List<DatabaseMeta> aDataBases, boolean aLook) {
        this.shell = aShell;
        this.databaseMeta = aDatabaseMeta;
        this.databases = aDataBases;
        this.look = aLook;
    }

    public boolean open() {
        try {
            SwtXulLoader theLoader = new SwtXulLoader();
            theLoader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
            theLoader.setSettingsManager((XulSettingsManager)new DefaultSettingsManager(new File(Const.getKettleDirectory() + Const.FILE_SEPARATOR + "xulSettings.properties")));
            theLoader.setOuterContext((Object)this.shell);
            this.container = theLoader.loadXul(XUL, (Object)new XulDatabaseExplorerResourceBundle());
            XulDialog theExplorerDialog = (XulDialog)this.container.getDocumentRoot().getElementById("databaseExplorerDialog");
            SpoonPluginManager.getInstance().applyPluginsForContainer("database_dialog", this.container);
            this.controller = new XulDatabaseExplorerController((Shell)theExplorerDialog.getRootObject(), this.databaseMeta, this.databases, this.look);
            this.container.addEventHandler((XulEventHandler)this.controller);
            this.runner = new SwtXulRunner();
            this.runner.addContainer(this.container);
            this.runner.initialize();
            this.controller.setSelectedSchemaAndTable(this.schemaName, this.selectedTable);
            theExplorerDialog.show();
        }
        catch (Exception e) {
            logger.info((Object)e);
            e.printStackTrace();
        }
        return this.controller.getSelectedTable() != null;
    }

    public void setSelectedSchemaAndTable(String aSchema, String aTable) {
        this.schemaName = aSchema;
        this.selectedTable = aTable;
    }

    public String getSchemaName() {
        return this.controller != null ? this.controller.getSelectedSchema() : this.schemaName;
    }

    public String getTableName() {
        return this.controller != null ? this.controller.getSelectedTable() : this.selectedTable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XulDatabaseExplorerResourceBundle
    extends ResourceBundle {
        private XulDatabaseExplorerResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    }
}

