/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultDialog
extends Dialog {
    private static Class<?> PKG = DatabaseDialog.class;
    private static final String STRING_HIDE_SUCESSFUL = BaseMessages.getString(PKG, (String)"CheckResultDialog.HideSuccessful.Label", (String[])new String[0]);
    private static final String STRING_SHOW_SUCESSFUL = BaseMessages.getString(PKG, (String)"CheckResultDialog.ShowSuccessful.Label", (String[])new String[0]);
    private static final String STRING_HIDE_REMARKS = BaseMessages.getString(PKG, (String)"CheckResultDialog.Remarks.Label", (String[])new String[0]);
    private static final String STRING_SHOW_REMARKS = BaseMessages.getString(PKG, (String)"CheckResultDialog.WarningsErrors.Label", (String[])new String[0]);
    private List<CheckResultInterface> remarks;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wClose;
    private Button wView;
    private Button wEdit;
    private Button wNoOK;
    private Listener lsClose;
    private Listener lsView;
    private Listener lsEdit;
    private Listener lsNoOK;
    private Shell shell;
    private PropsUI props;
    private Color red;
    private Color green;
    private Color yellow;
    private boolean show_successful_results = false;
    private String stepname;
    private TransMeta transMeta;

    public CheckResultDialog(TransMeta transMeta, Shell parent, int style, List<CheckResultInterface> rem) {
        super(parent, style);
        this.remarks = rem;
        this.props = PropsUI.getInstance();
        this.stepname = null;
        this.transMeta = transMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.red = display.getSystemColor(3);
        this.green = display.getSystemColor(5);
        this.yellow = display.getSystemColor(7);
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlFields = new Label((Composite)this.shell, 16384);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Remarks.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.right = new FormAttachment(middle, -margin);
        this.fdlFields.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 3;
        int FieldsRows = 1;
        ColumnInfo[] colinf = new ColumnInfo[FieldsCols];
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.Stepname.Label", (String[])new String[0]), 1, false, true);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.Result.Label", (String[])new String[0]), 1, false, true);
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckResultDialog.Remark.Label", (String[])new String[0]), 1, false, true);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, true, null, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wNoOK = new Button((Composite)this.shell, 32);
        this.wNoOK.setText(STRING_SHOW_SUCESSFUL);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wFields, margin);
        this.wNoOK.setLayoutData((Object)fd);
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wView = new Button((Composite)this.shell, 8);
        this.wView.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Button.ViewMessage", (String[])new String[0]));
        this.wEdit = new Button((Composite)this.shell, 8);
        this.wEdit.setText(BaseMessages.getString(PKG, (String)"CheckResultDialog.Button.EditOriginStep", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wClose, this.wView, this.wEdit}, margin, null);
        this.lsClose = new Listener(){

            public void handleEvent(Event e) {
                CheckResultDialog.this.close();
            }
        };
        this.lsView = new Listener(){

            public void handleEvent(Event e) {
                CheckResultDialog.this.view();
            }
        };
        this.lsEdit = new Listener(){

            public void handleEvent(Event e) {
                CheckResultDialog.this.edit();
            }
        };
        this.lsNoOK = new Listener(){

            public void handleEvent(Event e) {
                CheckResultDialog.this.noOK();
            }
        };
        this.wClose.addListener(13, this.lsClose);
        this.wView.addListener(13, this.lsView);
        this.wEdit.addListener(13, this.lsEdit);
        this.wNoOK.addListener(13, this.lsNoOK);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CheckResultDialog.this.close();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void noOK() {
        this.show_successful_results = !this.show_successful_results;
        this.getData();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wFields.table.removeAll();
        for (int i = 0; i < this.remarks.size(); ++i) {
            CheckResultInterface cr = this.remarks.get(i);
            if (!this.show_successful_results && cr.getType() == 1) continue;
            TableItem ti = new TableItem(this.wFields.table, 0);
            CheckResultSourceInterface sourceMeta = cr.getSourceInfo();
            if (sourceMeta != null) {
                ti.setText(1, sourceMeta.getName());
            } else {
                ti.setText(1, "<global>");
            }
            ti.setText(2, cr.getType() + " - " + cr.getTypeDesc());
            ti.setText(3, cr.getText());
            Color col = ti.getBackground();
            switch (cr.getType()) {
                case 1: {
                    col = this.green;
                    break;
                }
                case 4: {
                    col = this.red;
                    break;
                }
                case 3: {
                    col = this.yellow;
                    break;
                }
            }
            ti.setBackground(col);
        }
        if (this.wFields.table.getItemCount() == 0) {
            this.wFields.clearAll(false);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        if (this.show_successful_results) {
            this.wlFields.setText(STRING_HIDE_REMARKS);
            this.wNoOK.setText(STRING_HIDE_SUCESSFUL);
        } else {
            this.wlFields.setText(STRING_SHOW_REMARKS);
            this.wNoOK.setText(STRING_SHOW_SUCESSFUL);
        }
        this.shell.layout();
    }

    private void view() {
        StringBuffer message = new StringBuffer();
        TableItem[] item = this.wFields.table.getSelection();
        if (item.length == 0) {
            item = this.wFields.table.getItems();
        }
        for (int i = 0; i < item.length; ++i) {
            if (i > 0) {
                message.append("_______________________________________________________________________________").append(Const.CR).append(Const.CR);
            }
            message.append("[").append(item[i].getText(2)).append("] ").append(item[i].getText(1)).append(Const.CR);
            message.append("  ").append(item[i].getText(3)).append(Const.CR).append(Const.CR);
        }
        String subtitle = item.length != 1 ? BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.SubtitlePlural", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.Subtitle", (String[])new String[0]);
        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckResultDialog.TextDialog.Title", (String[])new String[0]), subtitle, message.toString());
        etd.setReadOnly();
        etd.open();
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.stepname = this.wFields.table.getItem(idx).getText(1);
            this.dispose();
        }
    }

    private void close() {
        this.dispose();
    }
}

