/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterListDialog
extends Dialog {
    private static Class<?> PKG = EnterListDialog.class;
    private PropsUI props = PropsUI.getInstance();
    private String[] input;
    private String[] retval;
    private Hashtable<Integer, String> selection;
    private Shell shell;
    private List wListSource;
    private List wListDest;
    private Label wlListSource;
    private Label wlListDest;
    private Button wOK;
    private Button wCancel;
    private Button wAddOne;
    private Button wAddAll;
    private Button wRemoveAll;
    private Button wRemoveOne;
    private boolean opened;

    public EnterListDialog(Shell parent, int style, LogWriter log, PropsUI props, String[] input) {
        this(parent, style, input);
        this.props = props;
    }

    public EnterListDialog(Shell parent, int style, String[] input) {
        super(parent, style);
        this.input = input;
        this.retval = null;
        this.selection = new Hashtable();
        this.opened = false;
    }

    public String[] open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)new FormLayout());
        int margin = 4;
        Composite top = new Composite((Composite)this.shell, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginHeight = margin;
        topLayout.marginWidth = margin;
        top.setLayout((Layout)topLayout);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment(100, -50);
        top.setLayoutData((Object)fdTop);
        this.props.setLook((Control)top);
        Composite bottom = new Composite((Composite)this.shell, 0);
        bottom.setLayout((Layout)new FormLayout());
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment((Control)top, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        bottom.setLayoutData((Object)fdBottom);
        this.props.setLook((Control)bottom);
        SashForm sashform = new SashForm(top, 256);
        sashform.setLayout((Layout)new FormLayout());
        FormData fdSashform = new FormData();
        fdSashform.left = new FormAttachment(0, 0);
        fdSashform.top = new FormAttachment(0, 0);
        fdSashform.right = new FormAttachment(100, 0);
        fdSashform.bottom = new FormAttachment(100, 0);
        sashform.setLayoutData((Object)fdSashform);
        Composite leftsplit = new Composite((Composite)sashform, 0);
        leftsplit.setLayout((Layout)new FormLayout());
        FormData fdLeftsplit = new FormData();
        fdLeftsplit.left = new FormAttachment(0, 0);
        fdLeftsplit.top = new FormAttachment(0, 0);
        fdLeftsplit.right = new FormAttachment(100, 0);
        fdLeftsplit.bottom = new FormAttachment(100, 0);
        leftsplit.setLayoutData((Object)fdLeftsplit);
        this.props.setLook((Control)leftsplit);
        this.wlListSource = new Label(leftsplit, 0);
        this.wlListSource.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.AvailableItems.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlListSource);
        FormData fdlListSource = new FormData();
        fdlListSource.left = new FormAttachment(0, 0);
        fdlListSource.top = new FormAttachment(0, 0);
        this.wlListSource.setLayoutData((Object)fdlListSource);
        this.wListSource = new List(leftsplit, 2818);
        this.props.setLook((Control)this.wListSource);
        FormData fdListSource = new FormData();
        fdListSource.left = new FormAttachment(0, 0);
        fdListSource.top = new FormAttachment((Control)this.wlListSource, 0);
        fdListSource.right = new FormAttachment(100, 0);
        fdListSource.bottom = new FormAttachment(100, 0);
        this.wListSource.setLayoutData((Object)fdListSource);
        Composite compmiddle = new Composite((Composite)sashform, 0);
        compmiddle.setLayout((Layout)new FormLayout());
        FormData fdCompMiddle = new FormData();
        fdCompMiddle.left = new FormAttachment(0, 0);
        fdCompMiddle.top = new FormAttachment(0, 0);
        fdCompMiddle.right = new FormAttachment(100, 0);
        fdCompMiddle.bottom = new FormAttachment(100, 0);
        compmiddle.setLayoutData((Object)fdCompMiddle);
        this.props.setLook((Control)compmiddle);
        Composite gButtonGroup = new Composite(compmiddle, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gButtonGroup.setLayout((Layout)gridLayout);
        this.wAddOne = new Button(gButtonGroup, 8);
        this.wAddOne.setText(" > ");
        this.wAddOne.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.AddOne.Tooltip", (String[])new String[0]));
        this.wAddAll = new Button(gButtonGroup, 8);
        this.wAddAll.setText(" >> ");
        this.wAddAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.AddAll.Tooltip", (String[])new String[0]));
        this.wRemoveOne = new Button(gButtonGroup, 8);
        this.wRemoveOne.setText(" < ");
        this.wRemoveOne.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.RemoveOne.Tooltip", (String[])new String[0]));
        this.wRemoveAll = new Button(gButtonGroup, 8);
        this.wRemoveAll.setText(" << ");
        this.wRemoveAll.setToolTipText(BaseMessages.getString(PKG, (String)"EnterListDialog.RemoveAll.Tooltip", (String[])new String[0]));
        GridData gdAddOne = new GridData(1808);
        this.wAddOne.setLayoutData((Object)gdAddOne);
        GridData gdAddAll = new GridData(1808);
        this.wAddAll.setLayoutData((Object)gdAddAll);
        GridData gdRemoveAll = new GridData(1808);
        this.wRemoveAll.setLayoutData((Object)gdRemoveAll);
        GridData gdRemoveOne = new GridData(1808);
        this.wRemoveOne.setLayoutData((Object)gdRemoveOne);
        FormData fdButtonGroup = new FormData();
        this.wAddAll.pack();
        fdButtonGroup.left = new FormAttachment(50, -(this.wAddAll.getSize().x / 2) - 5);
        fdButtonGroup.top = new FormAttachment(30, 0);
        gButtonGroup.setBackground(this.shell.getBackground());
        gButtonGroup.setLayoutData((Object)fdButtonGroup);
        Composite rightsplit = new Composite((Composite)sashform, 0);
        rightsplit.setLayout((Layout)new FormLayout());
        FormData fdRightsplit = new FormData();
        fdRightsplit.left = new FormAttachment(0, 0);
        fdRightsplit.top = new FormAttachment(0, 0);
        fdRightsplit.right = new FormAttachment(100, 0);
        fdRightsplit.bottom = new FormAttachment(100, 0);
        rightsplit.setLayoutData((Object)fdRightsplit);
        this.props.setLook((Control)rightsplit);
        this.wlListDest = new Label(rightsplit, 0);
        this.wlListDest.setText(BaseMessages.getString(PKG, (String)"EnterListDialog.Selection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlListDest);
        FormData fdlListDest = new FormData();
        fdlListDest.left = new FormAttachment(0, 0);
        fdlListDest.top = new FormAttachment(0, 0);
        this.wlListDest.setLayoutData((Object)fdlListDest);
        this.wListDest = new List(rightsplit, 2818);
        this.props.setLook((Control)this.wListDest);
        FormData fdListDest = new FormData();
        fdListDest.left = new FormAttachment(0, 0);
        fdListDest.top = new FormAttachment((Control)this.wlListDest, 0);
        fdListDest.right = new FormAttachment(100, 0);
        fdListDest.bottom = new FormAttachment(100, 0);
        this.wListDest.setLayoutData((Object)fdListDest);
        sashform.setWeights(new int[]{40, 16, 40});
        this.wOK = new Button(bottom, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button(bottom, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdOK = new FormData();
        FormData fdCancel = new FormData();
        fdOK.left = new FormAttachment(35, 0);
        fdOK.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOK);
        fdCancel.left = new FormAttachment((Control)this.wOK, 10);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EnterListDialog.this.dispose();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EnterListDialog.this.handleOK();
            }
        });
        Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.wListSource, 3);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String[] ti = EnterListDialog.this.wListSource.getSelection();
                String data = new String();
                for (int i = 0; i < ti.length; ++i) {
                    data = data + ti[i] + Const.CR;
                }
                event.data = data;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget ddTarget = new DropTarget((Control)this.wListDest, 3);
        ddTarget.setTransfer(ttypes);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                StringTokenizer strtok = new StringTokenizer((String)event.data, Const.CR);
                while (strtok.hasMoreTokens()) {
                    String source = strtok.nextToken();
                    EnterListDialog.this.addToDestination(source);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.wListSource.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterListDialog.this.addToSelection(EnterListDialog.this.wListSource.getSelection());
                }
            }
        });
        this.wListDest.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterListDialog.this.delFromSelection(EnterListDialog.this.wListDest.getSelection());
                }
            }
        });
        this.wListSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterListDialog.this.addToSelection(EnterListDialog.this.wListSource.getSelection());
            }
        });
        this.wListDest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterListDialog.this.delFromSelection(EnterListDialog.this.wListDest.getSelection());
            }
        });
        this.wAddOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterListDialog.this.addToSelection(EnterListDialog.this.wListSource.getSelection());
            }
        });
        this.wRemoveOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterListDialog.this.delFromSelection(EnterListDialog.this.wListDest.getSelection());
            }
        });
        this.wAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterListDialog.this.addToSelection(EnterListDialog.this.wListSource.getItems());
            }
        });
        this.wRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterListDialog.this.delFromSelection(EnterListDialog.this.wListDest.getItems());
            }
        });
        this.opened = true;
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.retval;
    }

    public void getData() {
        if (!this.opened) {
            return;
        }
        this.wListSource.removeAll();
        this.wListDest.removeAll();
        for (int i = 0; i < this.input.length; ++i) {
            Integer idx = i;
            String str = this.selection.get(idx);
            if (str == null) {
                this.wListSource.add(this.input[i]);
                continue;
            }
            this.wListDest.add(this.input[i]);
        }
    }

    public void addToSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.addToDestination(string[i]);
        }
    }

    public void delFromSelection(String[] string) {
        for (int i = 0; i < string.length; ++i) {
            this.delFromDestination(string[i]);
        }
    }

    public void addToDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.put(idxInput, string);
        this.getData();
    }

    public void delFromDestination(String string) {
        int idxInput = Const.indexOfString((String)string, (String[])this.input);
        this.selection.remove(idxInput);
        this.getData();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void handleOK() {
        this.retval = this.wListDest.getItems();
        this.dispose();
    }
}

