/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterMappingDialog
extends Dialog {
    private static Class<?> PKG = DatabaseDialog.class;
    public static final String STRING_ORIGIN_SEPARATOR = "            (";
    private Label wlSource;
    private org.eclipse.swt.widgets.List wSource;
    private FormData fdlSource;
    private FormData fdSource;
    private Label wlSourceAuto;
    private Button wSourceAuto;
    private FormData fdlSourceAuto;
    private FormData fdSourceAuto;
    private Label wlSourceHide;
    private Button wSourceHide;
    private FormData fdlSourceHide;
    private FormData fdSourceHide;
    private Label wlTarget;
    private org.eclipse.swt.widgets.List wTarget;
    private FormData fdlTarget;
    private FormData fdTarget;
    private Label wlTargetAuto;
    private Button wTargetAuto;
    private FormData fdlTargetAuto;
    private FormData fdTargetAuto;
    private Label wlTargetHide;
    private Button wTargetHide;
    private FormData fdlTargetHide;
    private FormData fdTargetHide;
    private Label wlResult;
    private org.eclipse.swt.widgets.List wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Button wAdd;
    private FormData fdAdd;
    private Button wDelete;
    private FormData fdDelete;
    private Button wOK;
    private Button wGuess;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsGuess;
    private Listener lsCancel;
    private Shell shell;
    private String[] sourceList;
    private String[] targetList;
    private PropsUI props = PropsUI.getInstance();
    private List<SourceToTargetMapping> mappings;

    public EnterMappingDialog(Shell parent, String[] source, String[] target) {
        this(parent, source, target, new ArrayList<SourceToTargetMapping>());
    }

    public EnterMappingDialog(Shell parent, String[] source, String[] target, List<SourceToTargetMapping> mappings) {
        super(parent, 0);
        this.sourceList = source;
        this.targetList = target;
        this.mappings = mappings;
    }

    public List<SourceToTargetMapping> open() {
        int i;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 68848);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        int margin = 4;
        int buttonSpace = 90;
        this.wlSource = new Label((Composite)this.shell, 0);
        this.wlSource.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.SourceFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSource);
        this.fdlSource = new FormData();
        this.fdlSource.left = new FormAttachment(0, 0);
        this.fdlSource.top = new FormAttachment(0, margin);
        this.wlSource.setLayoutData((Object)this.fdlSource);
        this.wSource = new org.eclipse.swt.widgets.List((Composite)this.shell, 133892);
        for (i = 0; i < this.sourceList.length; ++i) {
            this.wSource.add(this.sourceList[i]);
        }
        this.props.setLook((Control)this.wSource);
        this.fdSource = new FormData();
        this.fdSource.left = new FormAttachment(0, 0);
        this.fdSource.right = new FormAttachment(25, 0);
        this.fdSource.top = new FormAttachment((Control)this.wlSource, margin);
        this.fdSource.bottom = new FormAttachment(100, -buttonSpace);
        this.wSource.setLayoutData((Object)this.fdSource);
        this.wlSourceAuto = new Label((Composite)this.shell, 0);
        this.wlSourceAuto.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.AutoTargetSelection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSourceAuto);
        this.fdlSourceAuto = new FormData();
        this.fdlSourceAuto.left = new FormAttachment(0, 0);
        this.fdlSourceAuto.top = new FormAttachment((Control)this.wSource, margin);
        this.wlSourceAuto.setLayoutData((Object)this.fdlSourceAuto);
        this.wSourceAuto = new Button((Composite)this.shell, 32);
        this.wSourceAuto.setSelection(true);
        this.props.setLook((Control)this.wSourceAuto);
        this.fdSourceAuto = new FormData();
        this.fdSourceAuto.left = new FormAttachment((Control)this.wlSourceAuto, margin * 2);
        this.fdSourceAuto.right = new FormAttachment(25, 0);
        this.fdSourceAuto.top = new FormAttachment((Control)this.wSource, margin);
        this.wSourceAuto.setLayoutData((Object)this.fdSourceAuto);
        this.wlSourceHide = new Label((Composite)this.shell, 0);
        this.wlSourceHide.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.HideUsedSources", (String[])new String[0]));
        this.props.setLook((Control)this.wlSourceHide);
        this.fdlSourceHide = new FormData();
        this.fdlSourceHide.left = new FormAttachment(0, 0);
        this.fdlSourceHide.top = new FormAttachment((Control)this.wSourceAuto, margin);
        this.wlSourceHide.setLayoutData((Object)this.fdlSourceHide);
        this.wSourceHide = new Button((Composite)this.shell, 32);
        this.wSourceHide.setSelection(true);
        this.props.setLook((Control)this.wSourceHide);
        this.fdSourceHide = new FormData();
        this.fdSourceHide.left = new FormAttachment((Control)this.wlSourceHide, margin * 2);
        this.fdSourceHide.right = new FormAttachment(25, 0);
        this.fdSourceHide.top = new FormAttachment((Control)this.wSourceAuto, margin);
        this.wSourceHide.setLayoutData((Object)this.fdSourceHide);
        this.wSourceHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterMappingDialog.this.refreshMappings();
            }
        });
        this.wlTarget = new Label((Composite)this.shell, 0);
        this.wlTarget.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.TargetFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTarget);
        this.fdlTarget = new FormData();
        this.fdlTarget.left = new FormAttachment((Control)this.wSource, margin * 2);
        this.fdlTarget.top = new FormAttachment(0, margin);
        this.wlTarget.setLayoutData((Object)this.fdlTarget);
        this.wTarget = new org.eclipse.swt.widgets.List((Composite)this.shell, 19204);
        for (i = 0; i < this.targetList.length; ++i) {
            this.wTarget.add(this.targetList[i]);
        }
        this.props.setLook((Control)this.wTarget);
        this.fdTarget = new FormData();
        this.fdTarget.left = new FormAttachment((Control)this.wSource, margin * 2);
        this.fdTarget.right = new FormAttachment(50, 0);
        this.fdTarget.top = new FormAttachment((Control)this.wlTarget, margin);
        this.fdTarget.bottom = new FormAttachment(100, -buttonSpace);
        this.wTarget.setLayoutData((Object)this.fdTarget);
        this.wlTargetAuto = new Label((Composite)this.shell, 0);
        this.wlTargetAuto.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.AutoSourceSelection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetAuto);
        this.fdlTargetAuto = new FormData();
        this.fdlTargetAuto.left = new FormAttachment((Control)this.wSource, margin * 2);
        this.fdlTargetAuto.top = new FormAttachment((Control)this.wTarget, margin);
        this.wlTargetAuto.setLayoutData((Object)this.fdlTargetAuto);
        this.wTargetAuto = new Button((Composite)this.shell, 32);
        this.wTargetAuto.setSelection(false);
        this.props.setLook((Control)this.wTargetAuto);
        this.fdTargetAuto = new FormData();
        this.fdTargetAuto.left = new FormAttachment((Control)this.wlTargetAuto, margin * 2);
        this.fdTargetAuto.right = new FormAttachment(50, 0);
        this.fdTargetAuto.top = new FormAttachment((Control)this.wTarget, margin);
        this.wTargetAuto.setLayoutData((Object)this.fdTargetAuto);
        this.wlTargetHide = new Label((Composite)this.shell, 0);
        this.wlTargetHide.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.HideUsedTargets", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetHide);
        this.fdlTargetHide = new FormData();
        this.fdlTargetHide.left = new FormAttachment((Control)this.wSource, margin * 2);
        this.fdlTargetHide.top = new FormAttachment((Control)this.wTargetAuto, margin);
        this.wlTargetHide.setLayoutData((Object)this.fdlTargetHide);
        this.wTargetHide = new Button((Composite)this.shell, 32);
        this.wTargetHide.setSelection(true);
        this.props.setLook((Control)this.wTargetHide);
        this.fdTargetHide = new FormData();
        this.fdTargetHide.left = new FormAttachment((Control)this.wlTargetHide, margin * 2);
        this.fdTargetHide.right = new FormAttachment(50, 0);
        this.fdTargetHide.top = new FormAttachment((Control)this.wTargetAuto, margin);
        this.wTargetHide.setLayoutData((Object)this.fdTargetHide);
        this.wTargetHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterMappingDialog.this.refreshMappings();
            }
        });
        this.wAdd = new Button((Composite)this.shell, 8);
        this.fdAdd = new FormData();
        this.wAdd.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Add", (String[])new String[0]));
        this.fdAdd.left = new FormAttachment((Control)this.wTarget, margin * 2);
        this.fdAdd.top = new FormAttachment((Control)this.wTarget, 0, 0x1000000);
        this.wAdd.setLayoutData((Object)this.fdAdd);
        Listener lsAdd = new Listener(){

            public void handleEvent(Event e) {
                EnterMappingDialog.this.add();
            }
        };
        this.wAdd.addListener(13, lsAdd);
        this.wDelete = new Button((Composite)this.shell, 8);
        this.fdDelete = new FormData();
        this.wDelete.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Delete", (String[])new String[0]));
        this.fdDelete.left = new FormAttachment((Control)this.wTarget, margin * 2);
        this.fdDelete.top = new FormAttachment((Control)this.wAdd, margin * 2);
        this.wDelete.setLayoutData((Object)this.fdDelete);
        Listener lsDelete = new Listener(){

            public void handleEvent(Event e) {
                EnterMappingDialog.this.delete();
            }
        };
        this.wDelete.addListener(13, lsDelete);
        this.wlResult = new Label((Composite)this.shell, 0);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.ResultMappings.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment((Control)this.wDelete, margin * 2);
        this.fdlResult.top = new FormAttachment(0, margin);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new org.eclipse.swt.widgets.List((Composite)this.shell, 19202);
        for (int i2 = 0; i2 < this.targetList.length; ++i2) {
            this.wResult.add(this.targetList[i2]);
        }
        this.props.setLook((Control)this.wResult);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment((Control)this.wDelete, margin * 2);
        this.fdResult.right = new FormAttachment(100, 0);
        this.fdResult.top = new FormAttachment((Control)this.wlResult, margin);
        this.fdResult.bottom = new FormAttachment(100, -30);
        this.wResult.setLayoutData((Object)this.fdResult);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterMappingDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGuess = new Button((Composite)this.shell, 8);
        this.wGuess.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Guess", (String[])new String[0]));
        this.lsGuess = new Listener(){

            public void handleEvent(Event e) {
                EnterMappingDialog.this.guess();
            }
        };
        this.wGuess.addListener(13, this.lsGuess);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterMappingDialog.this.cancel();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wGuess, this.wCancel}, margin, null);
        this.wSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnterMappingDialog.this.wSourceAuto.getSelection()) {
                    EnterMappingDialog.this.findTarget();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterMappingDialog.this.add();
            }
        });
        this.wTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnterMappingDialog.this.wTargetAuto.getSelection()) {
                    EnterMappingDialog.this.findSource();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterMappingDialog.this.add();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterMappingDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mappings;
    }

    private void guess() {
        for (int i = 0; i < this.sourceList.length; ++i) {
            int idx = Const.indexOfString((String)this.sourceList[i], (String[])this.wSource.getItems());
            if (idx < 0) continue;
            this.wSource.select(idx);
            if (!this.findTarget()) continue;
            this.add();
        }
    }

    private boolean findTarget() {
        boolean found = false;
        int sourceIndex = this.wSource.getSelectionIndex();
        if (sourceIndex < 0) {
            return false;
        }
        String sourceStr = this.wSource.getItem(sourceIndex).toUpperCase();
        int indexOfBracket = sourceStr.indexOf(STRING_ORIGIN_SEPARATOR);
        String sourceString = sourceStr;
        if (indexOfBracket >= 0) {
            sourceString = sourceStr.substring(0, indexOfBracket);
        }
        boolean first = true;
        for (int length = sourceString.length(); !found && (length >= 2 || first); --length) {
            first = false;
            for (int i = 0; i < this.wTarget.getItemCount() && !found; ++i) {
                if (this.wTarget.getItem(i).toUpperCase().indexOf(sourceString.substring(0, length)) < 0) continue;
                this.wTarget.setSelection(i);
                found = true;
            }
        }
        return found;
    }

    private boolean findSource() {
        boolean found = false;
        int targetIndex = this.wTarget.getSelectionIndex();
        String targetString = this.wTarget.getItem(targetIndex).toUpperCase();
        boolean first = true;
        for (int length = targetString.length(); !found && (length >= 2 || first); --length) {
            first = false;
            for (int i = 0; i < this.wSource.getItemCount() && !found; ++i) {
                if (this.wSource.getItem(i).toUpperCase().indexOf(targetString.substring(0, length)) < 0) continue;
                this.wSource.setSelection(i);
                found = true;
            }
        }
        return found;
    }

    private void add() {
        if (this.wSource.getSelectionCount() == 1 && this.wTarget.getSelectionCount() == 1) {
            String sourceString = this.wSource.getSelection()[0];
            String targetString = this.wTarget.getSelection()[0];
            int srcIndex = Const.indexOfString((String)sourceString, (String[])this.sourceList);
            int tgtIndex = Const.indexOfString((String)targetString, (String[])this.targetList);
            if (srcIndex >= 0 && tgtIndex >= 0) {
                SourceToTargetMapping mapping = new SourceToTargetMapping(srcIndex, tgtIndex);
                this.mappings.add(mapping);
                this.refreshMappings();
            }
        }
    }

    private void refreshMappings() {
        SourceToTargetMapping mapping;
        int a;
        this.wResult.removeAll();
        for (int i = 0; i < this.mappings.size(); ++i) {
            SourceToTargetMapping mapping2 = this.mappings.get(i);
            String mappingString = this.sourceList[mapping2.getSourcePosition()] + " --> " + this.targetList[mapping2.getTargetPosition()];
            this.wResult.add(mappingString);
        }
        this.wSource.removeAll();
        for (a = 0; a < this.sourceList.length; ++a) {
            boolean found = false;
            if (this.wSourceHide.getSelection()) {
                for (int b = 0; b < this.mappings.size() && !found; ++b) {
                    mapping = this.mappings.get(b);
                    if (mapping.getSourcePosition() != Const.indexOfString((String)this.sourceList[a], (String[])this.sourceList)) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.wSource.add(this.sourceList[a]);
        }
        this.wTarget.removeAll();
        for (a = 0; a < this.targetList.length; ++a) {
            boolean found = false;
            if (this.wTargetHide.getSelection()) {
                for (int b = 0; b < this.mappings.size() && !found; ++b) {
                    mapping = this.mappings.get(b);
                    if (mapping.getTargetPosition() != Const.indexOfString((String)this.targetList[a], (String[])this.targetList)) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.wTarget.add(this.targetList[a]);
        }
    }

    private void delete() {
        String[] result = this.wResult.getSelection();
        for (int i = result.length - 1; i >= 0; --i) {
            int idx = this.wResult.indexOf(result[i]);
            if (idx < 0 || idx >= this.mappings.size()) continue;
            this.mappings.remove(idx);
        }
        this.refreshMappings();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.refreshMappings();
    }

    private void cancel() {
        this.mappings = null;
        this.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

