/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterPrintDialog
extends Dialog {
    private static Class<?> PKG = EnterPrintDialog.class;
    private int retval;
    private Image image;
    private Label wlCanvas;
    private Canvas wCanvas;
    private FormData fdlCanvas;
    private FormData fdCanvas;
    private Label wlCols;
    private Slider wCols;
    private FormData fdlCols;
    private FormData fdCols;
    private Label wlRows;
    private Slider wRows;
    private FormData fdlRows;
    private FormData fdRows;
    private Label wlScale;
    private Slider wScale;
    private FormData fdlScale;
    private FormData fdScale;
    private Label wlLeft;
    private Text wLeft;
    private FormData fdlLeft;
    private FormData fdLeft;
    private Label wlRight;
    private Text wRight;
    private FormData fdlRight;
    private FormData fdRight;
    private Label wlTop;
    private Text wTop;
    private FormData fdlTop;
    private FormData fdTop;
    private Label wlBottom;
    private Text wBottom;
    private FormData fdlBottom;
    private FormData fdBottom;
    private Button wOK;
    private Button wCancel;
    private FormData fdOK;
    private FormData fdCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    public int nrcols;
    public int nrrows;
    public int scale;
    public Point page;
    public double factorx;
    public double factory;
    public double leftMargin;
    public double rightMargin;
    public double topMargin;
    public double bottomMargin;

    public EnterPrintDialog(Shell parent, int nrcols, int nrrows, int scale, double factorX, double factorY, Rectangle m, double marginLeft, double marginRigth, double marginTop, double marginBottom, Image image) {
        super(parent, 0);
        this.nrcols = nrcols;
        this.nrrows = nrrows;
        this.scale = scale;
        this.image = image;
        this.factorx = factorX;
        this.factory = factorY;
        this.leftMargin = marginLeft;
        this.rightMargin = marginRigth;
        this.topMargin = marginTop;
        this.bottomMargin = marginBottom;
        this.page = new Point(m.width, m.height);
    }

    public int open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.retval = 32;
        this.shell = new Shell(parent, 68848);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlCanvas = new Label((Composite)this.shell, 0);
        this.wlCanvas.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.PrintArea.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCanvas);
        this.fdlCanvas = new FormData();
        this.fdlCanvas.left = new FormAttachment(0, 0);
        this.fdlCanvas.top = new FormAttachment(0, margin);
        this.wlCanvas.setLayoutData((Object)this.fdlCanvas);
        this.wCanvas = new Canvas((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wCanvas);
        this.wCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                EnterPrintDialog.this.repaint(pe.gc, pe.width, pe.height);
            }
        });
        this.fdCanvas = new FormData();
        this.fdCanvas.left = new FormAttachment(0, 0);
        this.fdCanvas.top = new FormAttachment((Control)this.wlCanvas, margin);
        this.fdCanvas.right = new FormAttachment(100, 0);
        this.fdCanvas.bottom = new FormAttachment(100, -220);
        this.wCanvas.setLayoutData((Object)this.fdCanvas);
        this.wlRows = new Label((Composite)this.shell, 0);
        this.wlRows.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Rows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRows);
        this.fdlRows = new FormData();
        this.fdlRows.left = new FormAttachment(0, 0);
        this.fdlRows.right = new FormAttachment(middle, -margin);
        this.fdlRows.top = new FormAttachment((Control)this.wCanvas, margin);
        this.wlRows.setLayoutData((Object)this.fdlRows);
        this.wRows = new Slider((Composite)this.shell, 256);
        this.wRows.setIncrement(1);
        this.wRows.setMinimum(1);
        this.wRows.setMaximum(11);
        this.wRows.setThumb(1);
        this.wRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.nrrows = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        this.props.setLook((Control)this.wRows);
        this.fdRows = new FormData();
        this.fdRows.left = new FormAttachment(middle, 0);
        this.fdRows.top = new FormAttachment((Control)this.wCanvas, margin);
        this.fdRows.right = new FormAttachment(100, 0);
        this.wRows.setLayoutData((Object)this.fdRows);
        this.wlCols = new Label((Composite)this.shell, 0);
        this.wlCols.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Cols.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCols);
        this.fdlCols = new FormData();
        this.fdlCols.left = new FormAttachment(0, 0);
        this.fdlCols.right = new FormAttachment(middle, -margin);
        this.fdlCols.top = new FormAttachment((Control)this.wRows, margin);
        this.wlCols.setLayoutData((Object)this.fdlCols);
        this.wCols = new Slider((Composite)this.shell, 256);
        this.wCols.setIncrement(1);
        this.wCols.setMinimum(1);
        this.wCols.setMaximum(11);
        this.wCols.setThumb(1);
        this.wCols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.nrcols = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        this.props.setLook((Control)this.wCols);
        this.fdCols = new FormData();
        this.fdCols.left = new FormAttachment(middle, 0);
        this.fdCols.top = new FormAttachment((Control)this.wRows, margin);
        this.fdCols.right = new FormAttachment(100, 0);
        this.wCols.setLayoutData((Object)this.fdCols);
        this.wlScale = new Label((Composite)this.shell, 0);
        this.wlScale.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.Scaling.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlScale);
        this.fdlScale = new FormData();
        this.fdlScale.left = new FormAttachment(0, 0);
        this.fdlScale.right = new FormAttachment(middle, -margin);
        this.fdlScale.top = new FormAttachment((Control)this.wCols, margin);
        this.wlScale.setLayoutData((Object)this.fdlScale);
        this.wScale = new Slider((Composite)this.shell, 256);
        this.wScale.setIncrement(10);
        this.wScale.setMinimum(10);
        this.wScale.setMaximum(500);
        this.wScale.setThumb(10);
        this.wScale.setPageIncrement(25);
        this.wScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Slider sl = (Slider)se.widget;
                EnterPrintDialog.this.scale = sl.getSelection();
                EnterPrintDialog.this.wCanvas.redraw();
            }
        });
        this.props.setLook((Control)this.wScale);
        this.fdScale = new FormData();
        this.fdScale.left = new FormAttachment(middle, 0);
        this.fdScale.top = new FormAttachment((Control)this.wCols, margin);
        this.fdScale.right = new FormAttachment(100, 0);
        this.wScale.setLayoutData((Object)this.fdScale);
        this.wlLeft = new Label((Composite)this.shell, 0);
        this.wlLeft.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.LeftMargin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLeft);
        this.fdlLeft = new FormData();
        this.fdlLeft.left = new FormAttachment(0, 0);
        this.fdlLeft.right = new FormAttachment(middle, -margin);
        this.fdlLeft.top = new FormAttachment((Control)this.wScale, margin);
        this.wlLeft.setLayoutData((Object)this.fdlLeft);
        this.wLeft = new Text((Composite)this.shell, 2048);
        this.wLeft.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text w = (Text)e.widget;
                EnterPrintDialog.this.leftMargin = Const.toDouble((String)w.getText(), (double)0.0);
            }
        });
        this.props.setLook((Control)this.wLeft);
        this.fdLeft = new FormData();
        this.fdLeft.left = new FormAttachment(middle, 0);
        this.fdLeft.top = new FormAttachment((Control)this.wScale, margin);
        this.fdLeft.right = new FormAttachment(100, 0);
        this.wLeft.setLayoutData((Object)this.fdLeft);
        this.wlRight = new Label((Composite)this.shell, 0);
        this.wlRight.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.RightMargin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRight);
        this.fdlRight = new FormData();
        this.fdlRight.left = new FormAttachment(0, 0);
        this.fdlRight.right = new FormAttachment(middle, -margin);
        this.fdlRight.top = new FormAttachment((Control)this.wLeft, margin);
        this.wlRight.setLayoutData((Object)this.fdlRight);
        this.wRight = new Text((Composite)this.shell, 2048);
        this.wRight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text w = (Text)e.widget;
                EnterPrintDialog.this.rightMargin = Const.toDouble((String)w.getText(), (double)0.0);
            }
        });
        this.props.setLook((Control)this.wRight);
        this.fdRight = new FormData();
        this.fdRight.left = new FormAttachment(middle, 0);
        this.fdRight.top = new FormAttachment((Control)this.wLeft, margin);
        this.fdRight.right = new FormAttachment(100, 0);
        this.wRight.setLayoutData((Object)this.fdRight);
        this.wlTop = new Label((Composite)this.shell, 0);
        this.wlTop.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.TopMargin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTop);
        this.fdlTop = new FormData();
        this.fdlTop.left = new FormAttachment(0, 0);
        this.fdlTop.right = new FormAttachment(middle, -margin);
        this.fdlTop.top = new FormAttachment((Control)this.wRight, margin);
        this.wlTop.setLayoutData((Object)this.fdlTop);
        this.wTop = new Text((Composite)this.shell, 2048);
        this.wTop.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text w = (Text)e.widget;
                EnterPrintDialog.this.topMargin = Const.toDouble((String)w.getText(), (double)0.0);
            }
        });
        this.props.setLook((Control)this.wTop);
        this.fdTop = new FormData();
        this.fdTop.left = new FormAttachment(middle, 0);
        this.fdTop.top = new FormAttachment((Control)this.wRight, margin);
        this.fdTop.right = new FormAttachment(100, 0);
        this.wTop.setLayoutData((Object)this.fdTop);
        this.wlBottom = new Label((Composite)this.shell, 0);
        this.wlBottom.setText(BaseMessages.getString(PKG, (String)"EnterPrintDialog.BottomMargin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBottom);
        this.fdlBottom = new FormData();
        this.fdlBottom.left = new FormAttachment(0, 0);
        this.fdlBottom.right = new FormAttachment(middle, -margin);
        this.fdlBottom.top = new FormAttachment((Control)this.wTop, margin);
        this.wlBottom.setLayoutData((Object)this.fdlBottom);
        this.wBottom = new Text((Composite)this.shell, 2048);
        this.wBottom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text w = (Text)e.widget;
                EnterPrintDialog.this.bottomMargin = Const.toDouble((String)w.getText(), (double)0.0);
            }
        });
        this.props.setLook((Control)this.wBottom);
        this.fdBottom = new FormData();
        this.fdBottom.left = new FormAttachment(middle, 0);
        this.fdBottom.top = new FormAttachment((Control)this.wTop, margin);
        this.fdBottom.right = new FormAttachment(100, 0);
        this.wBottom.setLayoutData((Object)this.fdBottom);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.fdOK = new FormData();
        this.fdOK.left = new FormAttachment(33, 0);
        this.fdOK.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)this.fdOK);
        this.fdCancel = new FormData();
        this.fdCancel.left = new FormAttachment(66, 0);
        this.fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)this.fdCancel);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterPrintDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterPrintDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterPrintDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.retval;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wCols.setSelection(this.nrcols);
        this.wRows.setSelection(this.nrrows);
        this.wScale.setSelection(this.scale);
        this.wLeft.setText(Double.toString(this.leftMargin));
        this.wRight.setText(Double.toString(this.rightMargin));
        this.wTop.setText(Double.toString(this.topMargin));
        this.wBottom.setText(Double.toString(this.bottomMargin));
    }

    private void cancel() {
        this.retval = 256;
        this.dispose();
    }

    private void ok() {
        this.nrcols = this.wCols.getSelection();
        this.nrrows = this.wRows.getSelection();
        this.scale = this.wScale.getSelection();
        this.dispose();
    }

    private void repaint(GC gc, int width, int height) {
        ImageData imd = this.image.getImageData();
        double sizeOnPaperX = (double)imd.width * this.factorx;
        double sizeOnPaperY = (double)imd.height * this.factory;
        double actualSizeX = sizeOnPaperX * (double)this.scale / 100.0;
        double actualSizeY = sizeOnPaperY * (double)this.scale / 100.0;
        double percentScreenX = actualSizeX / (double)(this.page.x * this.nrcols);
        double percentScreenY = actualSizeY / (double)(this.page.y * this.nrrows);
        gc.drawImage(this.image, 0, 0, imd.width, imd.height, 0, 0, (int)((double)width * percentScreenX), (int)((double)height * percentScreenY));
        StringBuffer text = new StringBuffer();
        text.append(this.nrcols).append("x").append(this.nrrows).append(" @ ").append(this.scale).append("%");
        gc.drawText(text.toString(), 0, 0);
        for (int c = 1; c < this.nrcols; ++c) {
            gc.drawLine(c * (width / this.nrcols), 0, c * (width / this.nrcols), height);
        }
        for (int r = 1; r < this.nrrows; ++r) {
            gc.drawLine(0, r * (height / this.nrrows), width, r * (height / this.nrrows));
        }
    }
}

