/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterStringDialog
extends Dialog {
    private static Class<?> PKG = EnterStringDialog.class;
    private Label wlString;
    private Text wString;
    private TextVar wStringVar;
    private TransMeta transMeta;
    private boolean allowVariables;
    private FormData fdlString;
    private FormData fdString;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private SelectionAdapter lsDef;
    private String string;
    private String shellText;
    private String lineText;
    private PropsUI props = PropsUI.getInstance();
    private boolean manditory;

    public EnterStringDialog(Shell parent, String string, String shellText, String lineText) {
        this(parent, string, shellText, lineText, false, null);
    }

    public EnterStringDialog(Shell parent, String string, String shellText, String lineText, boolean allowVariables, TransMeta transMeta) {
        super(parent, 0);
        this.string = string;
        this.shellText = shellText;
        this.lineText = lineText;
        this.allowVariables = allowVariables;
        this.transMeta = transMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 67696);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setText(this.shellText);
        int margin = 4;
        this.wlString = new Label((Composite)this.shell, 0);
        this.wlString.setText(this.lineText);
        this.props.setLook((Control)this.wlString);
        this.fdlString = new FormData();
        this.fdlString.left = new FormAttachment(0, 0);
        this.fdlString.top = new FormAttachment(0, margin);
        this.wlString.setLayoutData((Object)this.fdlString);
        if (this.allowVariables) {
            this.wStringVar = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
            this.wStringVar.setText(this.string);
            this.props.setLook((Control)this.wStringVar);
        } else {
            this.wString = new Text((Composite)this.shell, 18436);
            this.wString.setText(this.string);
            this.props.setLook((Control)this.wString);
        }
        this.fdString = new FormData();
        this.fdString.left = new FormAttachment(0, 0);
        this.fdString.top = new FormAttachment((Control)this.wlString, margin);
        this.fdString.right = new FormAttachment(100, -margin);
        if (this.allowVariables) {
            this.wStringVar.setLayoutData(this.fdString);
            this.wStringVar.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    EnterStringDialog.this.setFlags();
                }
            });
        } else {
            this.wString.setLayoutData((Object)this.fdString);
            this.wString.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    EnterStringDialog.this.setFlags();
                }
            });
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wString);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterStringDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterStringDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterStringDialog.this.ok();
            }
        };
        if (this.allowVariables) {
            this.wStringVar.addSelectionListener(this.lsDef);
        } else {
            this.wString.addSelectionListener((SelectionListener)this.lsDef);
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterStringDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.string;
    }

    protected void setFlags() {
        String string = this.allowVariables ? this.wStringVar.getText() : this.wString.getText();
        boolean enabled = !this.manditory || !Const.isEmpty((String)string);
        this.wOK.setEnabled(enabled);
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.allowVariables) {
            this.wStringVar.setText(Const.NVL((String)this.string, (String)""));
            this.wStringVar.selectAll();
        } else {
            this.wString.setText(Const.NVL((String)this.string, (String)""));
            this.wString.selectAll();
        }
        this.setFlags();
    }

    private void cancel() {
        this.string = null;
        this.dispose();
    }

    private void ok() {
        this.string = this.allowVariables ? this.wStringVar.getText() : this.wString.getText();
        this.dispose();
    }

    public boolean isManditory() {
        return this.manditory;
    }

    public void setManditory(boolean manditory) {
        this.manditory = manditory;
    }
}

