/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterStringsDialog
extends Dialog {
    private static Class<?> PKG = EnterStringsDialog.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private RowMetaAndData strings;
    private PropsUI props;
    private boolean readOnly;
    private String message;
    private String title;
    private Image shellImage;

    public EnterStringsDialog(Shell parent, int style, RowMetaAndData strings) {
        super(parent, style);
        this.strings = strings;
        this.props = PropsUI.getInstance();
        this.readOnly = false;
        this.title = BaseMessages.getString(PKG, (String)"EnterStringsDialog.Title", (String[])new String[0]);
        this.message = BaseMessages.getString(PKG, (String)"EnterStringsDialog.Message", (String[])new String[0]);
    }

    public RowMetaAndData open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = 4;
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(this.message);
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.strings.getRowMeta().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"EnterStringsDialog.StringName.Label", (String[])new String[0]), 1, false, this.readOnly), new ColumnInfo(BaseMessages.getString(PKG, (String)"EnterStringsDialog.StringValue.Label", (String[])new String[0]), 1, false, this.readOnly)};
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 67586, colinf, FieldsRows, null, this.props);
        this.wFields.setReadonly(this.readOnly);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, 30);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterStringsDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterStringsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterStringsDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        if (this.shellImage != null) {
            this.shell.setImage(this.shellImage);
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.strings;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.strings != null) {
            for (int i = 0; i < this.strings.getRowMeta().size(); ++i) {
                String string;
                ValueMetaInterface valueMeta = this.strings.getRowMeta().getValueMeta(i);
                Object valueData = this.strings.getData()[i];
                try {
                    string = valueMeta.getString(valueData);
                }
                catch (KettleValueException e) {
                    string = "";
                }
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, valueMeta.getName());
                if (Const.isEmpty((String)string)) continue;
                item.setText(2, string);
            }
        }
        this.wFields.sortTable(1);
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.strings = null;
        this.dispose();
    }

    private void ok() {
        if (this.readOnly) {
            int nrNonEmptyFields = this.wFields.nrNonEmpty();
            for (int i = 0; i < nrNonEmptyFields; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                String name = item.getText(1);
                for (int j = 0; j < this.strings.getRowMeta().size(); ++j) {
                    ValueMetaInterface valueMeta = this.strings.getRowMeta().getValueMeta(j);
                    if (!valueMeta.getName().equalsIgnoreCase(name)) continue;
                    String stringValue = item.getText(2);
                    this.strings.getData()[j] = stringValue;
                }
            }
        } else {
            this.strings.clear();
            int nrNonEmptyFields = this.wFields.nrNonEmpty();
            for (int i = 0; i < nrNonEmptyFields; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                String name = item.getText(1);
                String value = item.getText(2);
                this.strings.addValue(new ValueMeta(name, 2), (Object)value);
            }
        }
        this.dispose();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShellImage(Image shellImage) {
        this.shellImage = shellImage;
    }
}

