/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DescriptionInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterTextDialog
extends Dialog {
    private static Class<?> PKG = EnterTextDialog.class;
    private String title;
    private String message;
    private Label wlDesc;
    private Text wDesc;
    private FormData fdlDesc;
    private FormData fdDesc;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell parent;
    private Shell shell;
    private SelectionAdapter lsDef;
    private PropsUI props;
    private String text;
    private boolean fixed;
    private boolean readonly;
    private boolean modal;
    private boolean singleLine;
    private String origText;

    public EnterTextDialog(Shell parent, String title, String message, String text, boolean fixed) {
        this(parent, title, message, text);
        this.fixed = fixed;
    }

    public EnterTextDialog(Shell parent, String title, String message, String text) {
        super(parent, 0);
        this.parent = parent;
        this.props = PropsUI.getInstance();
        this.title = title;
        this.message = message;
        this.text = text;
        this.fixed = false;
        this.readonly = false;
        this.singleLine = false;
    }

    public void setReadOnly() {
        this.readonly = true;
    }

    public void setModal() {
        this.modal = true;
    }

    public void setSingleLine() {
        this.singleLine = true;
    }

    public String open() {
        Display display = this.parent.getDisplay();
        this.modal |= Const.isLinux();
        this.shell = new Shell(this.parent, 0xCF0 | (this.modal ? 65536 : 0));
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = 4;
        this.wlDesc = new Label((Composite)this.shell, 0);
        this.wlDesc.setText(this.message);
        this.props.setLook((Control)this.wlDesc);
        this.fdlDesc = new FormData();
        this.fdlDesc.left = new FormAttachment(0, 0);
        this.fdlDesc.top = new FormAttachment(0, margin);
        this.wlDesc.setLayoutData((Object)this.fdlDesc);
        this.wDesc = this.singleLine ? new Text((Composite)this.shell, 18436) : new Text((Composite)this.shell, 19202);
        this.wDesc.setText("");
        if (this.fixed) {
            this.props.setLook((Control)this.wDesc, 1);
        } else {
            this.props.setLook((Control)this.wDesc);
        }
        this.fdDesc = new FormData();
        this.fdDesc.left = new FormAttachment(0, 0);
        this.fdDesc.top = new FormAttachment((Control)this.wlDesc, margin);
        this.fdDesc.right = new FormAttachment(100, 0);
        this.fdDesc.bottom = new FormAttachment(100, -50);
        this.wDesc.setLayoutData((Object)this.fdDesc);
        this.wDesc.setEditable(!this.readonly);
        if (!this.readonly) {
            this.wOK = new Button((Composite)this.shell, 8);
            this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
            this.lsCancel = new Listener(){

                public void handleEvent(Event e) {
                    EnterTextDialog.this.cancel();
                }
            };
            this.lsOK = new Listener(){

                public void handleEvent(Event e) {
                    EnterTextDialog.this.ok();
                }
            };
            this.wOK.addListener(13, this.lsOK);
            this.wCancel.addListener(13, this.lsCancel);
        } else {
            this.wOK = new Button((Composite)this.shell, 8);
            this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
            BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK}, margin, null);
            this.lsOK = new Listener(){

                public void handleEvent(Event e) {
                    EnterTextDialog.this.ok();
                }
            };
            this.wOK.addListener(13, this.lsOK);
        }
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterTextDialog.this.ok();
            }
        };
        this.wDesc.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterTextDialog.this.checkCancel(e);
            }
        });
        this.origText = this.text;
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.text;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.text != null) {
            this.wDesc.setText(this.text);
        }
        if (this.readonly) {
            this.wOK.setFocus();
        } else {
            this.wDesc.setFocus();
        }
    }

    public void checkCancel(ShellEvent e) {
        String newText = this.wDesc.getText();
        if (!newText.equals(this.origText)) {
            int save = JobGraph.showChangedWarning(this.shell, this.title);
            if (save == 256) {
                e.doit = false;
            } else if (save == 64) {
                this.ok();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    private void cancel() {
        this.text = null;
        this.dispose();
    }

    private void ok() {
        this.text = this.wDesc.getText();
        this.dispose();
    }

    public static final void editDescription(Shell shell, DescriptionInterface descriptionInterface, String shellText, String message) {
        EnterTextDialog textDialog = new EnterTextDialog(shell, shellText, message, descriptionInterface.getDescription());
        String description = textDialog.open();
        if (description != null) {
            descriptionInterface.setDescription(description);
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }
}

