/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ErrorDialog
extends Dialog {
    private static Class<?> PKG = ErrorDialog.class;
    private Label wlDesc;
    private Text wDesc;
    private FormData fdlDesc;
    private FormData fdDesc;
    private Button wOK;
    private Button wDetails;
    private Button wCancel;
    private Shell shell;
    private SelectionAdapter lsDef;
    private PropsUI props;
    private boolean cancelled;

    public ErrorDialog(Shell parent, String title, String message, Throwable throwable) {
        super(parent, 0);
        throwable.printStackTrace();
        if (throwable instanceof Exception) {
            this.showErrorDialog(parent, title, message, (Exception)throwable, false);
        } else {
            this.showErrorDialog(parent, title, message + Const.CR + Const.getStackTracker((Throwable)throwable), null, false);
        }
    }

    public ErrorDialog(Shell parent, String title, String message, Exception exception) {
        super(parent, 0);
        this.showErrorDialog(parent, title, message, exception, false);
    }

    public ErrorDialog(Shell parent, String title, String message, Exception exception, boolean showCancelButton) {
        super(parent, 0);
        this.showErrorDialog(parent, title, message, exception, showCancelButton);
    }

    private void showErrorDialog(Shell parent, String title, String message, Exception exception, boolean showCancelButton) {
        if (parent.isDisposed()) {
            exception.printStackTrace();
            return;
        }
        this.props = PropsUI.getInstance();
        Display display = parent.getDisplay();
        Font largeFont = GUIResource.getInstance().getFontBold();
        Color gray = GUIResource.getInstance().getColorDemoGray();
        this.shell = new Shell(parent, 68848);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageShowErrorLines());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(title);
        int margin = 4;
        this.wlDesc = new Label((Composite)this.shell, 0);
        this.wlDesc.setText(message);
        this.props.setLook((Control)this.wlDesc);
        this.fdlDesc = new FormData();
        this.fdlDesc.left = new FormAttachment(0, 0);
        this.fdlDesc.top = new FormAttachment(0, margin);
        this.wlDesc.setLayoutData((Object)this.fdlDesc);
        this.wlDesc.setFont(largeFont);
        this.wDesc = new Text((Composite)this.shell, 19202);
        StringBuffer text = new StringBuffer();
        final StringBuffer details = new StringBuffer();
        if (exception != null) {
            if (exception instanceof KettleException) {
                KettleException ke = (KettleException)((Object)exception);
                text.append(ke.getMessage());
            } else if (exception instanceof InvocationTargetException) {
                Throwable cause = exception.getCause();
                if (cause instanceof KettleException) {
                    KettleException ke = (KettleException)cause;
                    text.append(ke.getMessage());
                } else {
                    text.append(Const.NVL((String)cause.getMessage(), (String)cause.toString()));
                    while (text.length() == 0 && cause != null) {
                        if ((cause = cause.getCause()) == null) continue;
                        text.append(Const.NVL((String)cause.getMessage(), (String)cause.toString()));
                    }
                }
            } else if (exception.getMessage() == null) {
                text.append(message);
            } else {
                text.append(exception.getMessage());
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            details.append(sw.getBuffer());
            this.wDesc.setText(text.toString());
        } else {
            text.append(message);
            this.wDesc.setText(text.toString());
        }
        this.wDesc.setBackground(gray);
        this.fdDesc = new FormData();
        this.fdDesc.left = new FormAttachment(0, 0);
        this.fdDesc.top = new FormAttachment((Control)this.wlDesc, margin);
        this.fdDesc.right = new FormAttachment(100, 0);
        this.fdDesc.bottom = new FormAttachment(100, -50);
        this.wDesc.setLayoutData((Object)this.fdDesc);
        this.wDesc.setEditable(false);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        if (showCancelButton) {
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        }
        this.wDetails = new Button((Composite)this.shell, 8);
        this.wDetails.setText(BaseMessages.getString(PKG, (String)"System.Button.Details", (String[])new String[0]));
        Button[] buttons = showCancelButton ? new Button[]{this.wOK, this.wCancel, this.wDetails} : new Button[]{this.wOK, this.wDetails};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, margin, null);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ErrorDialog.this.ok();
            }
        });
        if (showCancelButton) {
            this.wCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ErrorDialog.this.cancel();
                }
            });
        }
        this.wDetails.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ErrorDialog.this.showDetails(details.toString());
            }
        });
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorDialog.this.ok();
            }
        };
        this.wDesc.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ErrorDialog.this.ok();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.wOK.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void showDetails(String details) {
        EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"ErrorDialog.ShowDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ErrorDialog.ShowDetails.Message", (String[])new String[0]), details);
        dialog.setReadOnly();
        dialog.open();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }

    private void cancel() {
        this.cancelled = true;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

