/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.DialogClosedListener;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewRowsDialog {
    private static Class<?> PKG = PreviewRowsDialog.class;
    public static final int MAX_BINARY_STRING_PREVIEW_SIZE = 1000000;
    private String stepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wClose;
    private Button wStop;
    private Button wNext;
    private Button wLog;
    private Shell shell;
    private List<Object[]> buffer;
    private PropsUI props;
    private String title;
    private String message;
    private Rectangle bounds;
    private int hscroll;
    private int vscroll;
    private int hmax;
    private int vmax;
    private String loggingText;
    private boolean proposingToGetMoreRows;
    private boolean proposingToStop;
    private boolean askingForMoreRows;
    private boolean askingToStop;
    private RowMetaInterface rowMeta;
    private VariableSpace variables;
    private LogChannelInterface log;
    private boolean dynamic;
    private boolean waitingForRows;
    protected int lineNr;
    private int style = 3312;
    private Shell parentShell;
    private List<DialogClosedListener> dialogClosedListeners;

    public PreviewRowsDialog(Shell parent, VariableSpace space, int style, String stepName, RowMetaInterface rowMeta, List<Object[]> rowBuffer) {
        this(parent, space, style, stepName, rowMeta, rowBuffer, null);
    }

    public PreviewRowsDialog(Shell parent, VariableSpace space, int style, String stepName, RowMetaInterface rowMeta, List<Object[]> rowBuffer, String loggingText) {
        this.stepname = stepName;
        this.buffer = rowBuffer;
        this.loggingText = loggingText;
        this.rowMeta = rowMeta;
        this.variables = space;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.dialogClosedListeners = new ArrayList<DialogClosedListener>();
        this.props = PropsUI.getInstance();
        this.bounds = null;
        this.hscroll = -1;
        this.vscroll = -1;
        this.title = null;
        this.message = null;
        this.log = new LogChannel((Object)"Row Preview");
    }

    public void setTitleMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, this.style);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        if (this.title == null) {
            this.title = BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Title", (String[])new String[0]);
        }
        if (this.message == null) {
            this.message = BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Header", (String[])new String[]{this.stepname});
        }
        if (this.buffer != null) {
            this.message = this.message + " " + BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NrRows", (String[])new String[]{"" + this.buffer.size()});
        }
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        if (this.addFields()) {
            return;
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wClose.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PreviewRowsDialog.this.close();
            }
        });
        buttons.add(this.wClose);
        if (!Const.isEmpty((String)this.loggingText)) {
            this.wLog = new Button((Composite)this.shell, 8);
            this.wLog.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.ShowLog", (String[])new String[0]));
            this.wLog.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PreviewRowsDialog.this.log();
                }
            });
            buttons.add(this.wLog);
        }
        if (this.proposingToStop) {
            this.wStop = new Button((Composite)this.shell, 8);
            this.wStop.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Stop.Label", (String[])new String[0]));
            this.wStop.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Stop.ToolTip", (String[])new String[0]));
            this.wStop.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PreviewRowsDialog.this.askingToStop = true;
                    PreviewRowsDialog.this.close();
                }
            });
            buttons.add(this.wStop);
        }
        if (this.proposingToGetMoreRows) {
            this.wNext = new Button((Composite)this.shell, 8);
            this.wNext.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Next.Label", (String[])new String[0]));
            this.wNext.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Next.ToolTip", (String[])new String[0]));
            this.wNext.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PreviewRowsDialog.this.askingForMoreRows = true;
                    PreviewRowsDialog.this.close();
                }
            });
            buttons.add(this.wNext);
        }
        if (this.proposingToGetMoreRows || this.proposingToStop) {
            this.wClose.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Close.Label", (String[])new String[0]));
            this.wClose.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Close.ToolTip", (String[])new String[0]));
        }
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[buttons.size()]), 4, null);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PreviewRowsDialog.this.close();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        if (!this.waitingForRows) {
            while (!this.shell.isDisposed()) {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
        }
    }

    private boolean addFields() {
        int margin = 4;
        if (this.wlFields == null) {
            this.wlFields = new Label((Composite)this.shell, 16384);
            this.wlFields.setText(this.message);
            this.props.setLook((Control)this.wlFields);
            this.fdlFields = new FormData();
            this.fdlFields.left = new FormAttachment(0, 0);
            this.fdlFields.right = new FormAttachment(100, 0);
            this.fdlFields.top = new FormAttachment(0, margin);
            this.wlFields.setLayoutData((Object)this.fdlFields);
        } else {
            this.wFields.dispose();
        }
        if (this.dynamic && this.rowMeta == null) {
            this.rowMeta = new RowMeta();
            this.rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("<waiting for rows>", 2));
            this.waitingForRows = true;
        }
        if (!(this.dynamic || this.buffer != null && this.buffer.size() != 0)) {
            ShowMessageDialog dialog = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NoRows.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NoRows.Message", (String[])new String[0]));
            dialog.open();
            this.shell.dispose();
            return true;
        }
        ColumnInfo[] colinf = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            ValueMetaInterface v = this.rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setValueMeta(v);
        }
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, 0, null, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        if (this.dynamic) {
            this.shell.layout(true, true);
        }
        return false;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.bounds = this.shell.getBounds();
        this.hscroll = this.wFields.getHorizontalBar().getSelection();
        this.vscroll = this.wFields.getVerticalBar().getSelection();
        this.shell.dispose();
    }

    private void getData() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                int nrErrors = 0;
                PreviewRowsDialog.this.lineNr = 0;
                for (int i = 0; i < PreviewRowsDialog.this.buffer.size(); ++i) {
                    TableItem item = i == 0 ? ((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.getItem(i) : new TableItem(((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table, 0);
                    Object[] row = (Object[])PreviewRowsDialog.this.buffer.get(i);
                    nrErrors += PreviewRowsDialog.this.getDataForRow(item, row);
                }
                if (!PreviewRowsDialog.this.wFields.isDisposed()) {
                    PreviewRowsDialog.this.wFields.optWidth(true, 200);
                }
            }
        });
    }

    protected int getDataForRow(TableItem item, Object[] row) {
        String strNr;
        int nrErrors = 0;
        ++this.lineNr;
        try {
            strNr = this.wFields.getNumberColumn().getValueMeta().getString((Object)new Long(this.lineNr));
        }
        catch (Exception e) {
            strNr = Integer.toString(this.lineNr);
        }
        item.setText(0, strNr);
        for (int c = 0; c < this.rowMeta.size(); ++c) {
            String show;
            ValueMetaInterface v = this.rowMeta.getValueMeta(c);
            try {
                show = v.getString(row[c]);
                if (v.isBinary() && show != null && show.length() > 1000000) {
                    show = show.substring(0, 1000000);
                }
            }
            catch (KettleValueException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            if (show == null) continue;
            item.setText(c + 1, show);
        }
        return nrErrors;
    }

    private void close() {
        this.stepname = null;
        this.dispose();
    }

    private void log() {
        if (this.loggingText != null) {
            EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"PreviewRowsDialog.ShowLogging.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PreviewRowsDialog.ShowLogging.Message", (String[])new String[0]), this.loggingText);
            etd.open();
        }
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle b) {
        this.bounds = b;
    }

    public int getHScroll() {
        return this.hscroll;
    }

    public void setHScroll(int s) {
        this.hscroll = s;
    }

    public int getVScroll() {
        return this.vscroll;
    }

    public void setVScroll(int s) {
        this.vscroll = s;
    }

    public int getHMax() {
        return this.hmax;
    }

    public void setHMax(int m) {
        this.hmax = m;
    }

    public int getVMax() {
        return this.vmax;
    }

    public void setVMax(int m) {
        this.vmax = m;
    }

    public boolean isAskingForMoreRows() {
        return this.askingForMoreRows;
    }

    public boolean isProposingToGetMoreRows() {
        return this.proposingToGetMoreRows;
    }

    public void setProposingToGetMoreRows(boolean proposingToGetMoreRows) {
        this.proposingToGetMoreRows = proposingToGetMoreRows;
    }

    public boolean isAskingToStop() {
        return this.askingToStop;
    }

    public boolean isProposingToStop() {
        return this.proposingToStop;
    }

    public void setProposingToStop(boolean proposingToStop) {
        this.proposingToStop = proposingToStop;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public synchronized void addDataRow(final RowMetaInterface rowMeta, final Object[] rowData) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (PreviewRowsDialog.this.wFields.isDisposed()) {
                    return;
                }
                if (PreviewRowsDialog.this.waitingForRows) {
                    PreviewRowsDialog.this.rowMeta = rowMeta;
                    PreviewRowsDialog.this.addFields();
                }
                TableItem item = new TableItem(((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table, 0);
                PreviewRowsDialog.this.getDataForRow(item, rowData);
                if (PreviewRowsDialog.this.waitingForRows) {
                    PreviewRowsDialog.this.waitingForRows = false;
                    PreviewRowsDialog.this.wFields.removeEmptyRows();
                    PreviewRowsDialog.this.rowMeta = rowMeta;
                    if (((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.getItemCount() < 10) {
                        PreviewRowsDialog.this.wFields.optWidth(true);
                    }
                }
                if (((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.getItemCount() > PreviewRowsDialog.this.props.getDefaultPreviewSize()) {
                    ((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.remove(0);
                }
                ((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.setTopIndex(((PreviewRowsDialog)PreviewRowsDialog.this).wFields.table.getItemCount() - 1);
            }
        });
    }

    public void addDialogClosedListener(DialogClosedListener listener) {
        this.dialogClosedListeners.add(listener);
    }
}

