/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRowDialog
extends Dialog {
    private static Class<?> PKG = SelectRowDialog.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdFields;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private List<RowMetaAndData> buffer;
    private PropsUI props;
    private String title;
    private RowMetaAndData selection;
    private RowMetaInterface rowMeta;
    private VariableSpace variables;

    public SelectRowDialog(Shell parent, VariableSpace space, int style, List<RowMetaAndData> buffer) {
        super(parent, style);
        this.buffer = buffer;
        this.variables = space;
        this.props = PropsUI.getInstance();
        this.selection = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RowMetaAndData open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        if (this.title == null) {
            this.title = BaseMessages.getString(PKG, (String)"SelectRowDialog.Title", (String[])new String[0]);
        }
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.shell.setText(this.title);
        int margin = 4;
        if (this.buffer == null || this.buffer.size() == 0) {
            return null;
        }
        this.rowMeta = this.buffer.get(0).getRowMeta();
        int FieldsRows = this.buffer.size();
        ColumnInfo[] colinf = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            ValueMetaInterface v = this.rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, false);
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setReadOnly(true);
        }
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, null, this.props);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wFields.setLayoutData(this.fdFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SelectRowDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SelectRowDialog.this.close();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SelectRowDialog.this.close();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void getData() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            RowMetaAndData rowMetaAndData = this.buffer.get(i);
            RowMetaInterface rowMeta = rowMetaAndData.getRowMeta();
            Object[] rowData = rowMetaAndData.getData();
            for (int c = 0; c < rowMeta.size(); ++c) {
                String show;
                ValueMetaInterface v = rowMeta.getValueMeta(c);
                try {
                    show = v.isNumeric() ? v.getString(rowData[c]) : v.getString(rowData[c]);
                }
                catch (KettleValueException e) {
                    show = "<conversion error>";
                }
                if (show == null) continue;
                this.wFields.table.getItem(i).setText(c + 1, show);
            }
        }
        this.wFields.optWidth(true);
    }

    private void close() {
        this.selection = null;
        this.dispose();
    }

    private void ok() {
        int[] idx = this.wFields.getSelectionIndices();
        if (idx.length > 0 && idx[0] < this.buffer.size()) {
            this.selection = this.buffer.get(idx[0]);
        }
        this.dispose();
    }
}

