/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.gui.GUIResource;

public class ShowBrowserDialog
extends Dialog {
    private static Class<?> PKG = DatabaseDialog.class;
    private String dialogTitle;
    private String content;
    private Button wOK;
    private FormData fdOK;
    private Listener lsOK;
    private Browser wBrowser;
    private FormData fdBrowser;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private int prefWidth = -1;
    private int prefHeight = -1;
    private int buttonHeight = 30;

    public ShowBrowserDialog(Shell parent, String dialogTitle, String content) {
        super(parent, 0);
        this.dialogTitle = dialogTitle;
        this.content = content;
        this.prefWidth = -1;
        this.prefHeight = -1;
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 68848);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.dialogTitle);
        int margin = 4;
        this.wBrowser = new Browser((Composite)this.shell, 0);
        this.props.setLook((Control)this.wBrowser);
        this.fdBrowser = new FormData();
        this.fdBrowser.left = new FormAttachment(0, 0);
        this.fdBrowser.top = new FormAttachment(0, margin);
        this.fdBrowser.right = new FormAttachment(100, 0);
        this.fdBrowser.bottom = new FormAttachment(100, -this.buttonHeight);
        this.wBrowser.setLayoutData((Object)this.fdBrowser);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.fdOK = new FormData();
        this.fdOK.left = new FormAttachment(50, 0);
        this.fdOK.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)this.fdOK);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ShowBrowserDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowBrowserDialog.this.ok();
            }
        });
        if (this.prefWidth > 0 && this.prefHeight > 0) {
            this.shell.setSize(this.prefWidth, this.prefHeight);
            Rectangle r = this.shell.getClientArea();
            int diffx = this.prefWidth - r.width;
            int diffy = this.prefHeight - r.height;
            this.shell.setSize(this.prefWidth + diffx, this.prefHeight + diffy);
        } else {
            this.shell.setSize(400, 400);
        }
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void getData() {
        this.wBrowser.setText(this.content);
    }

    private void ok() {
        this.dispose();
    }
}

