/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.ManagedColor;
import org.pentaho.di.ui.core.gui.ManagedFont;
import org.pentaho.di.ui.util.ImageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIResource {
    private static LogChannelInterface log = new LogChannel((Object)"GUIResource");
    private static GUIResource guiResource;
    private Display display;
    private ManagedColor colorBackground;
    private ManagedColor colorGraph;
    private ManagedColor colorTab;
    private ManagedColor colorRed;
    private ManagedColor colorSuccessGreen;
    private ManagedColor colorBlueCustomGrid;
    private ManagedColor colorGreen;
    private ManagedColor colorBlue;
    private ManagedColor colorOrange;
    private ManagedColor colorYellow;
    private ManagedColor colorMagenta;
    private ManagedColor colorBlack;
    private ManagedColor colorGray;
    private ManagedColor colorDarkGray;
    private ManagedColor colorLightGray;
    private ManagedColor colorDemoGray;
    private ManagedColor colorWhite;
    private ManagedColor colorDirectory;
    private ManagedColor colorPentaho;
    private ManagedColor colorLightPentaho;
    private ManagedColor colorCreamPentaho;
    private ManagedFont fontGraph;
    private ManagedFont fontNote;
    private ManagedFont fontFixed;
    private ManagedFont fontMedium;
    private ManagedFont fontMediumBold;
    private ManagedFont fontLarge;
    private ManagedFont fontTiny;
    private ManagedFont fontSmall;
    private Map<String, Image> imagesSteps;
    private Map<String, Image> imagesStepsSmall;
    private Map<String, Image> imagesJobentries;
    private Map<String, Image> imagesJobentriesSmall;
    private Image imageHop;
    private Image imageDisabledHop;
    private Image imageConnection;
    private Image imageAdd;
    private Image imageTable;
    private Image imageKeySmall;
    private Image imageColumnSmall;
    private Image imageSchema;
    private Image imageSynonym;
    private Image imageProcedure;
    private Image imageExploreDbSmall;
    private Image imageView;
    private Image imageKettleLogo;
    private Image imageLogoSmall;
    private Image imageBanner;
    private Image imageBol;
    private Image imageCalendar;
    private Image imageCluster;
    private Image imageSlave;
    private Image imageArrow;
    private Image imageWizard;
    private Image imageCredits;
    private Image imageStart;
    private Image imageDummy;
    private Image imageStartSmall;
    private Image imageDummySmall;
    private Image imageSpoon;
    private Image imageJob;
    private Image imagePentaho;
    private Image imageVariable;
    private Image imageTransGraph;
    private Image imageJobGraph;
    private Image imageUser;
    private Image imageProfil;
    private Image imageFolderConnections;
    private Image imageEditOptionButton;
    private Image imageEditSmall;
    private Image imageExploreSolutionSmall;
    private Image imageColor;
    private Image imageNoteSmall;
    private Image imageResetOptionButton;
    private Image imageShowLog;
    private Image imageShowGrid;
    private Image imageShowHistory;
    private Image imageShowPerf;
    private Image imageShowInactive;
    private Image imageHideInactive;
    private Image imageClosePanel;
    private Image imageMaximizePanel;
    private Image imageMinimizePanel;
    private Image imageShowErrorLines;
    private Image imageShowResults;
    private Image imageHideResults;
    private Image imageDesignPanel;
    private Image imageViewPanel;
    private Image imageExpandAll;
    private Image imageSearchSmall;
    private Image imageRegExSmall;
    private Image imageCollapseAll;
    private Image imageStepError;
    private Image imageCopyHop;
    private Image imageErrorHop;
    private Image imageInfoHop;
    private Image imageWarning;
    private Image imageVersionBrowser;
    private Image imageNew;
    private Image imageEdit;
    private Image imageDelete;
    private Image imageShowDeleted;
    private Image imagePauseLog;
    private Image imageContinueLog;
    private Image imageImport;
    private Image imageExport;
    private Image imageHopInput;
    private Image imageHopOutput;
    private Image imageHopTarget;
    private Image imageLocked;
    private Image imageTrue;
    private Image imageFalse;
    private Image imageContextMenu;
    private Image imageUnconditionalHop;
    private Image imageParallelHop;
    private Image imageBusy;
    private Image imageEmpty16x16;
    private Map<String, Image> imageMap;
    private Map<RGB, Color> colorMap;
    private ManagedFont fontBold;
    private static Clipboard clipboard;

    private GUIResource(Display display) {
        this.display = display;
        this.getResources();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                GUIResource.this.dispose(false);
            }
        });
        clipboard = null;
    }

    public static final GUIResource getInstance() {
        if (guiResource != null) {
            return guiResource;
        }
        guiResource = new GUIResource(PropsUI.getDisplay());
        return guiResource;
    }

    public void reload() {
        this.dispose(true);
        this.getResources();
    }

    private void getResources() {
        PropsUI props = PropsUI.getInstance();
        this.imageMap = new HashMap<String, Image>();
        this.colorMap = new HashMap<RGB, Color>();
        this.colorBackground = new ManagedColor(this.display, props.getBackgroundRGB());
        this.colorGraph = new ManagedColor(this.display, props.getGraphColorRGB());
        this.colorTab = new ManagedColor(this.display, props.getTabColorRGB());
        this.colorSuccessGreen = new ManagedColor(this.display, 0, 139, 0);
        this.colorRed = new ManagedColor(this.display, 255, 0, 0);
        this.colorGreen = new ManagedColor(this.display, 0, 255, 0);
        this.colorBlue = new ManagedColor(this.display, 0, 0, 255);
        this.colorYellow = new ManagedColor(this.display, 255, 255, 0);
        this.colorMagenta = new ManagedColor(this.display, 255, 0, 255);
        this.colorOrange = new ManagedColor(this.display, 255, 165, 0);
        this.colorBlueCustomGrid = new ManagedColor(this.display, 240, 248, 255);
        this.colorWhite = new ManagedColor(this.display, 255, 255, 255);
        this.colorDemoGray = new ManagedColor(this.display, 240, 240, 240);
        this.colorLightGray = new ManagedColor(this.display, 225, 225, 225);
        this.colorGray = new ManagedColor(this.display, 215, 215, 215);
        this.colorDarkGray = new ManagedColor(this.display, 100, 100, 100);
        this.colorBlack = new ManagedColor(this.display, 0, 0, 0);
        this.colorDirectory = new ManagedColor(this.display, 0, 0, 255);
        this.colorPentaho = new ManagedColor(this.display, 188, 198, 82);
        this.colorLightPentaho = new ManagedColor(this.display, 238, 248, 152);
        this.colorCreamPentaho = new ManagedColor(this.display, 248, 246, 231);
        this.loadFonts();
        this.loadCommonImages();
        this.loadStepImages();
        this.loadJobEntryImages();
    }

    private void dispose(boolean reload) {
        this.colorBackground.dispose();
        this.colorGraph.dispose();
        this.colorTab.dispose();
        this.colorRed.dispose();
        this.colorSuccessGreen.dispose();
        this.colorGreen.dispose();
        this.colorBlue.dispose();
        this.colorGray.dispose();
        this.colorYellow.dispose();
        this.colorMagenta.dispose();
        this.colorOrange.dispose();
        this.colorBlueCustomGrid.dispose();
        this.colorWhite.dispose();
        this.colorDemoGray.dispose();
        this.colorLightGray.dispose();
        this.colorDarkGray.dispose();
        this.colorBlack.dispose();
        this.colorDirectory.dispose();
        this.colorPentaho.dispose();
        this.colorLightPentaho.dispose();
        this.colorCreamPentaho.dispose();
        this.disposeColors(this.colorMap.values());
        if (!reload) {
            this.fontGraph.dispose();
            this.fontNote.dispose();
            this.fontFixed.dispose();
            this.fontMedium.dispose();
            this.fontMediumBold.dispose();
            this.fontLarge.dispose();
            this.fontTiny.dispose();
            this.fontSmall.dispose();
            this.fontBold.dispose();
            this.imageHop.dispose();
            this.imageDisabledHop.dispose();
            this.imageConnection.dispose();
            this.imageAdd.dispose();
            this.imageTable.dispose();
            this.imageSchema.dispose();
            this.imageSynonym.dispose();
            this.imageProcedure.dispose();
            this.imageExploreDbSmall.dispose();
            this.imageView.dispose();
            this.imageLogoSmall.dispose();
            this.imageKettleLogo.dispose();
            this.imageBanner.dispose();
            this.imageBol.dispose();
            this.imageCalendar.dispose();
            this.imageCluster.dispose();
            this.imageSlave.dispose();
            this.imageArrow.dispose();
            this.imageWizard.dispose();
            this.imageCredits.dispose();
            this.imageStart.dispose();
            this.imageDummy.dispose();
            this.imageStartSmall.dispose();
            this.imageDummySmall.dispose();
            this.imageSpoon.dispose();
            this.imageJob.dispose();
            this.imagePentaho.dispose();
            this.imageVariable.dispose();
            this.imageTransGraph.dispose();
            this.imageJobGraph.dispose();
            this.imageUser.dispose();
            this.imageProfil.dispose();
            this.imageFolderConnections.dispose();
            this.imageShowResults.dispose();
            this.imageHideResults.dispose();
            this.imageCollapseAll.dispose();
            this.imageStepError.dispose();
            this.imageCopyHop.dispose();
            this.imageErrorHop.dispose();
            this.imageInfoHop.dispose();
            this.imageWarning.dispose();
            this.imageVersionBrowser.dispose();
            this.imageExpandAll.dispose();
            this.imageSearchSmall.dispose();
            this.imageRegExSmall.dispose();
            this.imageViewPanel.dispose();
            this.imageDesignPanel.dispose();
            this.imageNew.dispose();
            this.imageEdit.dispose();
            this.imageDelete.dispose();
            this.imageShowDeleted.dispose();
            this.imagePauseLog.dispose();
            this.imageContinueLog.dispose();
            this.imageLocked.dispose();
            this.imageImport.dispose();
            this.imageExport.dispose();
            this.imageHopInput.dispose();
            this.imageHopOutput.dispose();
            this.imageHopTarget.dispose();
            this.imageKeySmall.dispose();
            this.imageColumnSmall.dispose();
            this.imageTrue.dispose();
            this.imageFalse.dispose();
            this.imageContextMenu.dispose();
            this.imageParallelHop.dispose();
            this.imageUnconditionalHop.dispose();
            this.imageBusy.dispose();
            this.imageEmpty16x16.dispose();
            this.disposeImage(this.imageNoteSmall);
            this.disposeImage(this.imageColor);
            this.disposeImage(this.imageEditOptionButton);
            this.disposeImage(this.imageResetOptionButton);
            this.disposeImage(this.imageEditSmall);
            this.disposeImage(this.imageExploreSolutionSmall);
            this.disposeImage(this.imageShowLog);
            this.disposeImage(this.imageShowGrid);
            this.disposeImage(this.imageShowHistory);
            this.disposeImage(this.imageShowPerf);
            this.disposeImage(this.imageShowInactive);
            this.disposeImage(this.imageHideInactive);
            this.disposeImage(this.imageClosePanel);
            this.disposeImage(this.imageMaximizePanel);
            this.disposeImage(this.imageMinimizePanel);
            this.disposeImage(this.imageShowErrorLines);
            this.disposeImages(this.imagesSteps.values());
            this.disposeImages(this.imagesStepsSmall.values());
            this.disposeImages(this.imageMap.values());
        }
    }

    private void disposeImages(Collection<Image> c) {
        for (Image image : c) {
            this.disposeImage(image);
        }
    }

    private void disposeColors(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
    }

    private void disposeImage(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    private void loadStepImages() {
        this.imagesSteps = new Hashtable<String, Image>();
        this.imagesStepsSmall = new Hashtable<String, Image>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List steps = registry.getPlugins(StepPluginType.class);
        for (int i = 0; i < steps.size(); ++i) {
            Image image = null;
            Image small_image = null;
            String filename = ((PluginInterface)steps.get(i)).getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader((PluginInterface)steps.get(i));
                image = ImageUtil.getImage(this.display, classLoader, filename);
            }
            catch (Exception e) {
                log.logError("Unable to find required step image file or image format not supported (e.g. interlaced) [" + filename + " : ", (Throwable)e);
                image = new Image((Device)this.display, 32, 32);
                GC gc = new GC((Drawable)image);
                gc.drawRectangle(0, 0, 32, 32);
                gc.drawLine(0, 0, 32, 32);
                gc.drawLine(32, 0, 0, 32);
                gc.dispose();
            }
            if (image != null) {
                int xsize = image.getBounds().width;
                int ysize = image.getBounds().height;
                small_image = new Image((Device)this.display, 16, 16);
                GC gc = new GC((Drawable)small_image);
                gc.drawImage(image, 0, 0, xsize, ysize, 0, 0, 16, 16);
                gc.dispose();
            }
            this.imagesSteps.put(((PluginInterface)steps.get(i)).getIds()[0], image);
            this.imagesStepsSmall.put(((PluginInterface)steps.get(i)).getIds()[0], small_image);
        }
    }

    private void loadFonts() {
        PropsUI props = PropsUI.getInstance();
        this.fontGraph = new ManagedFont(this.display, props.getGraphFont());
        this.fontNote = new ManagedFont(this.display, props.getNoteFont());
        this.fontFixed = new ManagedFont(this.display, props.getFixedFont());
        FontData mediumFontData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle());
        this.fontMedium = new ManagedFont(this.display, mediumFontData);
        FontData mediumFontBoldData = new FontData(props.getGraphFont().getName(), (int)Math.round((double)props.getGraphFont().getHeight() * 1.2), props.getGraphFont().getStyle() | 1);
        this.fontMediumBold = new ManagedFont(this.display, mediumFontBoldData);
        FontData largeFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() * 3, props.getGraphFont().getStyle());
        this.fontLarge = new ManagedFont(this.display, largeFontData);
        FontData tinyFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() - 2, props.getGraphFont().getStyle());
        this.fontTiny = new ManagedFont(this.display, tinyFontData);
        FontData smallFontData = new FontData(props.getGraphFont().getName(), props.getGraphFont().getHeight() - 1, props.getGraphFont().getStyle());
        this.fontSmall = new ManagedFont(this.display, smallFontData);
        int extraHeigth = 0;
        if (Const.isOSX()) {
            extraHeigth = 3;
        }
        FontData boldFontData = new FontData(props.getDefaultFont().getName(), props.getDefaultFont().getHeight() + extraHeigth, props.getDefaultFont().getStyle() | 1);
        this.fontBold = new ManagedFont(this.display, boldFontData);
    }

    private void loadCommonImages() {
        this.imageHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HOP_image"));
        this.imageConnection = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CNC_image"));
        this.imageAdd = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Add_image"));
        this.imageDisabledHop = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Disabled_HOP_image")), new RGB(255, 255, 255));
        this.imageTable = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Table_image"));
        this.imageSchema = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Schema_image"));
        this.imageSynonym = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Synonym_image"));
        this.imageView = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"View_image"));
        this.imageColor = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Color_image"));
        this.imageNoteSmall = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Note_image"));
        this.imageProcedure = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ProcedureSmall_image"));
        this.imageExploreDbSmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ExploreDbSmall_image")), new RGB(255, 255, 255));
        this.imageCluster = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Cluster_image"));
        this.imageSlave = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Slave_image")), new RGB(255, 255, 255));
        this.imageKettleLogo = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Logo_lrg_image"));
        this.imageBanner = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Banner_bg_image"));
        this.imageBol = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"BOL_image"));
        this.imageCalendar = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Calendar_image")), new RGB(255, 255, 255));
        this.imageCredits = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Credits_image"));
        this.imageStart = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"STR_image"));
        this.imageDummy = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"DUM_image"));
        this.imageSpoon = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"spoon_image"));
        this.imageJob = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Chef_image"));
        this.imagePentaho = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CorpLogo_image"));
        this.imageVariable = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Variable_image"));
        this.imageEditOptionButton = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"EditOption_image"));
        this.imageResetOptionButton = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ResetOption_image"));
        this.imageEditSmall = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"EditSmall_image"));
        this.imageExploreSolutionSmall = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ExploreSolutionSmall_image"));
        this.imageShowLog = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowLog_image"));
        this.imageShowGrid = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowGrid_image"));
        this.imageShowHistory = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowHistory_image"));
        this.imageShowPerf = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowPerf_image"));
        this.imageShowInactive = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowInactive_image"));
        this.imageHideInactive = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HideInactive_image"));
        this.imageClosePanel = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ClosePanel_image"));
        this.imageMaximizePanel = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"MaximizePanel_image"));
        this.imageMinimizePanel = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"MinimizePanel_image"));
        this.imageShowErrorLines = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowErrorLines_image"));
        this.imageShowResults = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowResults_image"));
        this.imageHideResults = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HideResults_image"));
        this.imageDesignPanel = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"DesignPanel_image"));
        this.imageViewPanel = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ViewPanel_image"));
        this.imageExpandAll = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ExpandAll_image"));
        this.imageCollapseAll = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CollapseAll_image"));
        this.imageStepError = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"StepErrorLines_image"));
        this.imageCopyHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"CopyHop_image"));
        this.imageErrorHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ErrorHop_image"));
        this.imageInfoHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"InfoHop_image"));
        this.imageWarning = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Warning_image"));
        this.imageVersionBrowser = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"VersionBrowser_image"));
        this.imageNew = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"New_image"));
        this.imageEdit = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Edit_image"));
        this.imageDelete = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Delete_image"));
        this.imageShowDeleted = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ShowDeleted_image"));
        this.imagePauseLog = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"PauseLog_image"));
        this.imageContinueLog = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ContinueLog_image"));
        this.imageImport = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Import_image"));
        this.imageExport = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Export_image"));
        this.imageHopInput = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopInput_image"));
        this.imageHopOutput = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopOutput_image"));
        this.imageHopTarget = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"HopTarget_image"));
        this.imageLocked = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Locked_image"));
        this.imageTrue = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"True_image"));
        this.imageFalse = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"False_image"));
        this.imageContextMenu = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ContextMenu_image"));
        this.imageParallelHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ParallelHop_image"));
        this.imageUnconditionalHop = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"UnconditionalHop_image"));
        this.imageBusy = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Busy_image"));
        this.imageEmpty16x16 = new Image((Device)this.display, 16, 16);
        this.imageStartSmall = new Image((Device)this.display, 16, 16);
        GC gc = new GC((Drawable)this.imageStartSmall);
        gc.drawImage(this.imageStart, 0, 0, 32, 32, 0, 0, 16, 16);
        gc.dispose();
        this.imageDummySmall = new Image((Device)this.display, 16, 16);
        gc = new GC((Drawable)this.imageDummySmall);
        gc.drawImage(this.imageDummy, 0, 0, 32, 32, 0, 0, 16, 16);
        gc.dispose();
        this.imageTransGraph = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"SpoonIcon_image")), new RGB(255, 255, 255));
        this.imageJobGraph = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ChefIcon_image")), new RGB(255, 255, 255));
        this.imageLogoSmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Logo_sml_image")), new RGB(255, 255, 255));
        this.imageArrow = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ArrowIcon_image")), new RGB(255, 255, 255));
        this.imageWizard = ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Wizard_image"));
        this.imageBanner = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Banner_bg_image")), new RGB(255, 255, 255));
        this.imageUser = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"User_image")), new RGB(255, 255, 255));
        this.imageProfil = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"Profil_image")), new RGB(255, 255, 255));
        this.imageFolderConnections = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"FolderConnections_image")), new RGB(255, 255, 255));
        this.imageRegExSmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"RegExSmall_image")), new RGB(255, 255, 255));
        this.imageSearchSmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"SearchSmall_image")), new RGB(255, 255, 255));
        this.imageKeySmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"KeySmall_image")), new RGB(255, 255, 255));
        this.imageColumnSmall = ImageUtil.makeImageTransparent(this.display, ImageUtil.getImageAsResource(this.display, BasePropertyHandler.getProperty((String)"ColumnSmall_image")), new RGB(255, 255, 255));
    }

    private void loadJobEntryImages() {
        this.imagesJobentries = new Hashtable<String, Image>();
        this.imagesJobentriesSmall = new Hashtable<String, Image>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(JobEntryPluginType.class);
        for (int i = 0; i < plugins.size(); ++i) {
            PluginInterface plugin = (PluginInterface)plugins.get(i);
            if ("SPECIAL".equals(plugin.getIds()[0])) continue;
            Image image = null;
            Image small_image = null;
            String filename = plugin.getImageFile();
            try {
                ClassLoader classLoader = registry.getClassLoader(plugin);
                image = ImageUtil.getImage(this.display, classLoader, filename);
            }
            catch (Exception e) {
                log.logError("Unable to find required job entry image file [" + filename + "] for id [" + plugin.getIds()[0] + "] : " + e.toString());
                image = new Image((Device)this.display, 32, 32);
                GC gc = new GC((Drawable)image);
                gc.drawRectangle(0, 0, 32, 32);
                gc.drawLine(0, 0, 32, 32);
                gc.drawLine(32, 0, 0, 32);
                gc.dispose();
            }
            if (image != null) {
                int xsize = image.getBounds().width;
                int ysize = image.getBounds().height;
                small_image = new Image((Device)this.display, 16, 16);
                GC gc = new GC((Drawable)small_image);
                gc.drawImage(image, 0, 0, xsize, ysize, 0, 0, 16, 16);
                gc.dispose();
            }
            this.imagesJobentries.put(plugin.getIds()[0], image);
            this.imagesJobentriesSmall.put(plugin.getIds()[0], small_image);
        }
    }

    public Color getColorBackground() {
        return this.colorBackground.getColor();
    }

    public Color getColorBlack() {
        return this.colorBlack.getColor();
    }

    public Color getColorBlue() {
        return this.colorBlue.getColor();
    }

    public Color getColorDarkGray() {
        return this.colorDarkGray.getColor();
    }

    public Color getColorDemoGray() {
        return this.colorDemoGray.getColor();
    }

    public Color getColorDirectory() {
        return this.colorDirectory.getColor();
    }

    public Color getColorGraph() {
        return this.colorGraph.getColor();
    }

    public Color getColorGray() {
        return this.colorGray.getColor();
    }

    public Color getColorGreen() {
        return this.colorGreen.getColor();
    }

    public Color getColorLightGray() {
        return this.colorLightGray.getColor();
    }

    public Color getColorMagenta() {
        return this.colorMagenta.getColor();
    }

    public Color getColorOrange() {
        return this.colorOrange.getColor();
    }

    public Color getColorSuccessGreen() {
        return this.colorSuccessGreen.getColor();
    }

    public Color getColorRed() {
        return this.colorRed.getColor();
    }

    public Color getColorBlueCustomGrid() {
        return this.colorBlueCustomGrid.getColor();
    }

    public Color getColorTab() {
        return this.colorTab.getColor();
    }

    public Color getColorWhite() {
        return this.colorWhite.getColor();
    }

    public Color getColorYellow() {
        return this.colorYellow.getColor();
    }

    public Display getDisplay() {
        return this.display;
    }

    public Font getFontFixed() {
        return this.fontFixed.getFont();
    }

    public Font getFontGraph() {
        return this.fontGraph.getFont();
    }

    public Font getFontNote() {
        return this.fontNote.getFont();
    }

    public Image getImageBol() {
        return this.imageBol;
    }

    public Image getImageCalendar() {
        return this.imageCalendar;
    }

    public Image getImageCluster() {
        return this.imageCluster;
    }

    public Image getImageSlave() {
        return this.imageSlave;
    }

    public Image getImageConnection() {
        return this.imageConnection;
    }

    public Image getImageAdd() {
        return this.imageAdd;
    }

    public Image getImageTable() {
        return this.imageTable;
    }

    public Image getImageKeySmall() {
        return this.imageKeySmall;
    }

    public Image getImageColumnSmall() {
        return this.imageColumnSmall;
    }

    public Image getImageSchema() {
        return this.imageSchema;
    }

    public Image getImageSynonym() {
        return this.imageSynonym;
    }

    public Image getImageProcedure() {
        return this.imageProcedure;
    }

    public Image getImageExploreDbSmall() {
        return this.imageExploreDbSmall;
    }

    public Image getImageView() {
        return this.imageView;
    }

    public Image getImageNoteSmall() {
        return this.imageNoteSmall;
    }

    public Image getImageColor() {
        return this.imageColor;
    }

    public Image getImageCredits() {
        return this.imageCredits;
    }

    public Image getImageDummy() {
        return this.imageDummy;
    }

    public Image getImageHop() {
        return this.imageHop;
    }

    public Image getImageDisabledHop() {
        return this.imageDisabledHop;
    }

    public Image getImageSpoon() {
        return this.imageSpoon;
    }

    public Image getImagePentaho() {
        return this.imagePentaho;
    }

    public Map<String, Image> getImagesSteps() {
        return this.imagesSteps;
    }

    public Map<String, Image> getImagesStepsSmall() {
        return this.imagesStepsSmall;
    }

    public Image getImageStart() {
        return this.imageStart;
    }

    public Map<String, Image> getImagesJobentries() {
        return this.imagesJobentries;
    }

    public void setImagesJobentries(Hashtable<String, Image> imagesJobentries) {
        this.imagesJobentries = imagesJobentries;
    }

    public Map<String, Image> getImagesJobentriesSmall() {
        return this.imagesJobentriesSmall;
    }

    public void setImagesJobentriesSmall(Hashtable<String, Image> imagesJobentriesSmall) {
        this.imagesJobentriesSmall = imagesJobentriesSmall;
    }

    public Image getImageChef() {
        return this.imageJob;
    }

    public void setImageChef(Image imageChef) {
        this.imageJob = imageChef;
    }

    public Font getFontLarge() {
        return this.fontLarge.getFont();
    }

    public Font getFontTiny() {
        return this.fontTiny.getFont();
    }

    public Font getFontSmall() {
        return this.fontSmall.getFont();
    }

    public Clipboard getNewClipboard() {
        if (clipboard != null) {
            clipboard.dispose();
            clipboard = null;
        }
        clipboard = new Clipboard(this.display);
        return clipboard;
    }

    public void toClipboard(String cliptext) {
        if (cliptext == null) {
            return;
        }
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{cliptext}, new Transfer[]{tran});
    }

    public String fromClipboard() {
        this.getNewClipboard();
        TextTransfer tran = TextTransfer.getInstance();
        return (String)clipboard.getContents((Transfer)tran);
    }

    public Font getFontBold() {
        return this.fontBold.getFont();
    }

    public Image getImageVariable() {
        return this.imageVariable;
    }

    public Image getImageTransGraph() {
        return this.imageTransGraph;
    }

    public Image getImageUser() {
        return this.imageUser;
    }

    public Image getImageProfil() {
        return this.imageProfil;
    }

    public Image getImageFolderConnections() {
        return this.imageFolderConnections;
    }

    public Image getImageJobGraph() {
        return this.imageJobGraph;
    }

    public Image getEditOptionButton() {
        return this.imageEditOptionButton;
    }

    public Image getResetOptionButton() {
        return this.imageResetOptionButton;
    }

    public Image getImageEditSmall() {
        return this.imageEditSmall;
    }

    public Image getImageExploreSolutionSmall() {
        return this.imageExploreSolutionSmall;
    }

    public Image getImageArrow() {
        return this.imageArrow;
    }

    public void setImageArrow(Image imageArrow) {
        this.imageArrow = imageArrow;
    }

    public Image getImageDummySmall() {
        return this.imageDummySmall;
    }

    public void setImageDummySmall(Image imageDummySmall) {
        this.imageDummySmall = imageDummySmall;
    }

    public Image getImageStartSmall() {
        return this.imageStartSmall;
    }

    public void setImageStartSmall(Image imageStartSmall) {
        this.imageStartSmall = imageStartSmall;
    }

    public Image getImageBanner() {
        return this.imageBanner;
    }

    public Image getImageWizard() {
        return this.imageWizard;
    }

    public void setImageBanner(Image imageBanner) {
        this.imageBanner = imageBanner;
    }

    public Image getImageKettleLogo() {
        return this.imageKettleLogo;
    }

    public void setImageKettleLogo(Image imageKettleLogo) {
        this.imageKettleLogo = imageKettleLogo;
    }

    public Color getColorPentaho() {
        return this.colorPentaho.getColor();
    }

    public Image getImageLogoSmall() {
        return this.imageLogoSmall;
    }

    public void setImageLogoSmall(Image imageLogoSmall) {
        this.imageLogoSmall = imageLogoSmall;
    }

    public Color getColorLightPentaho() {
        return this.colorLightPentaho.getColor();
    }

    public Color getColorCreamPentaho() {
        return this.colorCreamPentaho.getColor();
    }

    public void drawPentahoGradient(Display display, GC gc, Rectangle rect, boolean vertical) {
        if (!vertical) {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GUIResource.getInstance().getColorPentaho());
            gc.fillGradientRectangle(rect.x, rect.y, 2 * rect.width / 3, rect.height, vertical);
            gc.setForeground(GUIResource.getInstance().getColorPentaho());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x + 2 * rect.width / 3, rect.y, rect.width / 3 + 1, rect.height, vertical);
        } else {
            gc.setForeground(display.getSystemColor(22));
            gc.setBackground(GUIResource.getInstance().getColorPentaho());
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, 2 * rect.height / 3, vertical);
            gc.setForeground(GUIResource.getInstance().getColorPentaho());
            gc.setBackground(display.getSystemColor(22));
            gc.fillGradientRectangle(rect.x, rect.y + 2 * rect.height / 3, rect.width, rect.height / 3 + 1, vertical);
        }
    }

    public Object[] messageDialogWithToggle(Shell shell, String dialogTitle, Image image, String message, int dialogImageType, String[] buttonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        int imageType = 0;
        switch (dialogImageType) {
            case 1: {
                imageType = 4;
            }
        }
        MessageDialogWithToggle md = new MessageDialogWithToggle(shell, dialogTitle, image, message, imageType, buttonLabels, defaultIndex, toggleMessage, toggleState);
        int idx = md.open();
        return new Object[]{idx, md.getToggleState()};
    }

    public static Point calculateControlPosition(Control control) {
        Rectangle r = control.getBounds();
        Point p = control.getParent().toDisplay(r.x, r.y);
        return p;
    }

    public Font getFontMedium() {
        return this.fontMedium.getFont();
    }

    public Font getFontMediumBold() {
        return this.fontMediumBold.getFont();
    }

    public Image getImageShowLog() {
        return this.imageShowLog;
    }

    public Image getImageShowGrid() {
        return this.imageShowGrid;
    }

    public Image getImageShowHistory() {
        return this.imageShowHistory;
    }

    public Image getImageShowPerf() {
        return this.imageShowPerf;
    }

    public Image getImageHideInactive() {
        return this.imageHideInactive;
    }

    public Image getImageShowInactive() {
        return this.imageShowInactive;
    }

    public Image getImageClosePanel() {
        return this.imageClosePanel;
    }

    public Image getImageMaximizePanel() {
        return this.imageMaximizePanel;
    }

    public Image getImageMinimizePanel() {
        return this.imageMinimizePanel;
    }

    public Image getImageShowErrorLines() {
        return this.imageShowErrorLines;
    }

    public Image getImageShowResults() {
        return this.imageShowResults;
    }

    public Image getImageHideResults() {
        return this.imageHideResults;
    }

    public Image getImageDesignPanel() {
        return this.imageDesignPanel;
    }

    public Image getImageViewPanel() {
        return this.imageViewPanel;
    }

    public Image getImageExpandAll() {
        return this.imageExpandAll;
    }

    public Image getImageSearchSmall() {
        return this.imageSearchSmall;
    }

    public Image getImageRegexSmall() {
        return this.imageRegExSmall;
    }

    public Image getImageCollapseAll() {
        return this.imageCollapseAll;
    }

    public Image getImageStepError() {
        return this.imageStepError;
    }

    public Image getImageCopyHop() {
        return this.imageCopyHop;
    }

    public Image getImageErrorHop() {
        return this.imageErrorHop;
    }

    public Image getImageInfoHop() {
        return this.imageInfoHop;
    }

    public Image getImageWarning() {
        return this.imageWarning;
    }

    public Image getImageVersionBrowser() {
        return this.imageVersionBrowser;
    }

    public Image getImageNew() {
        return this.imageNew;
    }

    public Image getImageEdit() {
        return this.imageEdit;
    }

    public Image getImageDelete() {
        return this.imageDelete;
    }

    public Image getImageShowDeleted() {
        return this.imageShowDeleted;
    }

    public Image getImagePauseLog() {
        return this.imagePauseLog;
    }

    public Image getImageContinueLog() {
        return this.imageContinueLog;
    }

    public Image getImageImport() {
        return this.imageImport;
    }

    public Image getImageExport() {
        return this.imageExport;
    }

    public Image getImageHopInput() {
        return this.imageHopInput;
    }

    public Image getImageHopOutput() {
        return this.imageHopOutput;
    }

    public Image getImageHopTarget() {
        return this.imageHopTarget;
    }

    public Image getImageLocked() {
        return this.imageLocked;
    }

    public Image getImage(String location) {
        Image image = this.imageMap.get(location);
        if (image == null) {
            image = ImageUtil.getImage(this.display, location);
            this.imageMap.put(location, image);
        }
        return image;
    }

    public Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        Color color = this.colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colorMap.put(rgb, color);
        }
        return color;
    }

    public Map<String, Image> getImageMap() {
        return this.imageMap;
    }

    public Image getImageTrue() {
        return this.imageTrue;
    }

    public Image getImageFalse() {
        return this.imageFalse;
    }

    public Image getImageContextMenu() {
        return this.imageContextMenu;
    }

    public Image getImageParallelHop() {
        return this.imageParallelHop;
    }

    public Image getImageUnconditionalHop() {
        return this.imageUnconditionalHop;
    }

    public Image getImageBusy() {
        return this.imageBusy;
    }

    public Image getImageEmpty16x16() {
        return this.imageEmpty16x16;
    }
}

