/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ControlSpaceKeyAdapter;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;

public class ComboVar
extends Composite {
    private static Class<?> PKG = ComboVar.class;
    private String toolTipText;
    private ControlDecoration controlDecoration;
    private GetCaretPositionInterface getCaretPositionInterface;
    private InsertTextInterface insertTextInterface;
    private ControlSpaceKeyAdapter controlSpaceKeyAdapter;
    private VariableSpace variables;
    private CCombo wCombo;

    public ComboVar(VariableSpace space, Composite composite, int flags) {
        this(space, composite, flags, null, null, null);
    }

    public ComboVar(VariableSpace space, Composite composite, int flags, String toolTipText) {
        this(space, composite, flags, toolTipText, null, null);
    }

    public ComboVar(VariableSpace space, Composite composite, int flags, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this(space, composite, flags, null, getCaretPositionInterface, insertTextInterface);
    }

    public ComboVar(VariableSpace space, Composite composite, int flags, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        super(composite, 0);
        this.toolTipText = toolTipText;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
        this.variables = space;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wCombo = new CCombo((Composite)this, flags);
        this.controlDecoration = new ControlDecoration((Control)this.wCombo, 131200);
        Image image = GUIResource.getInstance().getImageVariable();
        this.controlDecoration.setImage(image);
        this.controlDecoration.setDescriptionText(BaseMessages.getString(PKG, (String)"TextVar.tooltip.InsertVariable", (String[])new String[0]));
        this.wCombo.addModifyListener(this.getModifyListenerTooltipText(this.wCombo));
        this.controlSpaceKeyAdapter = new ControlSpaceKeyAdapter(this.variables, (Control)this.wCombo, getCaretPositionInterface, insertTextInterface);
        this.wCombo.addKeyListener((KeyListener)this.controlSpaceKeyAdapter);
        FormData fdText = new FormData();
        fdText.top = new FormAttachment(0, 0);
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, -image.getBounds().width);
        this.wCombo.setLayoutData((Object)fdText);
    }

    public GetCaretPositionInterface getGetCaretPositionInterface() {
        return this.getCaretPositionInterface;
    }

    public void setGetCaretPositionInterface(GetCaretPositionInterface getCaretPositionInterface) {
        this.getCaretPositionInterface = getCaretPositionInterface;
    }

    public InsertTextInterface getInsertTextInterface() {
        return this.insertTextInterface;
    }

    public void setInsertTextInterface(InsertTextInterface insertTextInterface) {
        this.insertTextInterface = insertTextInterface;
    }

    private ModifyListener getModifyListenerTooltipText(final CCombo comboField) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tip = comboField.getText();
                if (!Const.isEmpty((String)tip) && !Const.isEmpty((String)ComboVar.this.toolTipText)) {
                    tip = tip + Const.CR + Const.CR + ComboVar.this.toolTipText;
                }
                if (Const.isEmpty((String)tip)) {
                    tip = ComboVar.this.toolTipText;
                }
                comboField.setToolTipText(ComboVar.this.variables.environmentSubstitute(tip));
            }
        };
    }

    public String getText() {
        return this.wCombo.getText();
    }

    public void setText(String text) {
        this.wCombo.setText(text);
    }

    public CCombo getCComboWidget() {
        return this.wCombo;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wCombo.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionAdapter lsDef) {
        this.wCombo.addSelectionListener((SelectionListener)lsDef);
    }

    public void addKeyListener(KeyListener lsKey) {
        this.wCombo.addKeyListener(lsKey);
    }

    public void addFocusListener(FocusListener lsFocus) {
        this.wCombo.addFocusListener(lsFocus);
    }

    public void setEnabled(boolean flag) {
        this.wCombo.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wCombo.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wCombo.addTraverseListener(tl);
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        this.wCombo.setToolTipText(toolTipText);
    }

    public void setEditable(boolean editable) {
        this.wCombo.setEditable(editable);
    }

    public void setVariables(VariableSpace vars) {
        this.variables = vars;
        this.controlSpaceKeyAdapter.setVariables(this.variables);
    }

    public void setItems(String[] items) {
        this.wCombo.setItems(items);
    }

    public String[] getItems() {
        return this.wCombo.getItems();
    }

    public void add(String item) {
        this.wCombo.add(item);
    }

    public int getItemCount() {
        return this.wCombo.getItemCount();
    }

    public void removeAll() {
        this.wCombo.removeAll();
    }

    public void remove(int index) {
        this.wCombo.remove(index);
    }

    public void select(int index) {
        this.wCombo.select(index);
    }
}

