/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ControlSpaceKeyAdapter;
import org.pentaho.di.ui.core.widget.StyledTextCompFind;
import org.pentaho.di.ui.core.widget.StyledTextCompReplace;
import org.pentaho.di.ui.core.widget.UndoRedoStack;

public class StyledTextComp
extends Composite {
    private static Class<?> PKG = StyledTextComp.class;
    private static final int MAX_STACK_SIZE = 25;
    private List<UndoRedoStack> undoStack;
    private List<UndoRedoStack> redoStack;
    private boolean bFullSelection = false;
    private StyledText styledText;
    private Menu styledTextPopupmenu;
    private String strTabName;
    private Composite xParent;
    private KeyListener kls;
    private VariableSpace variables;
    private boolean varsSensitive;

    public StyledTextComp(VariableSpace space, Composite parent, int args, String strTabName) {
        this(space, parent, args, strTabName, true);
    }

    public StyledTextComp(VariableSpace space, Composite parent, int args, String strTabName, boolean varsSensitive) {
        super(parent, 0);
        this.varsSensitive = varsSensitive;
        this.variables = space;
        this.undoStack = new LinkedList<UndoRedoStack>();
        this.redoStack = new LinkedList<UndoRedoStack>();
        this.styledText = new StyledText((Composite)this, args);
        this.styledTextPopupmenu = new Menu((Decorations)parent.getShell(), 8);
        this.xParent = parent;
        this.strTabName = strTabName;
        this.setLayout((Layout)new FillLayout());
        this.buildingStyledTextMenu();
        this.addUndoRedoSupport();
        this.kls = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 104 && (e.stateMask & 0x40000) != 0) {
                    new StyledTextCompReplace(StyledTextComp.this.styledTextPopupmenu.getShell(), StyledTextComp.this.styledText).open();
                } else if (e.keyCode == 122 && (e.stateMask & 0x40000) != 0) {
                    StyledTextComp.this.undo();
                } else if (e.keyCode == 121 && (e.stateMask & 0x40000) != 0) {
                    StyledTextComp.this.redo();
                } else if (e.keyCode == 97 && (e.stateMask & 0x40000) != 0) {
                    StyledTextComp.this.bFullSelection = true;
                    StyledTextComp.this.styledText.selectAll();
                } else if (e.keyCode == 102 && (e.stateMask & 0x40000) != 0) {
                    new StyledTextCompFind(StyledTextComp.this.styledTextPopupmenu.getShell(), StyledTextComp.this.styledText, BaseMessages.getString((Class)PKG, (String)"WidgetDialog.Styled.Find", (String[])new String[0])).open();
                }
            }
        };
        this.styledText.addKeyListener(this.kls);
        if (this.varsSensitive) {
            ControlDecoration controlDecoration = new ControlDecoration((Control)this.styledText, 131200);
            Image image = GUIResource.getInstance().getImageVariable();
            controlDecoration.setImage(image);
            controlDecoration.setDescriptionText(BaseMessages.getString(PKG, (String)"StyledTextComp.tooltip.InsertVariable", (String[])new String[0]));
            PropsUI.getInstance().setLook(controlDecoration.getControl());
            this.styledText.addKeyListener((KeyListener)new ControlSpaceKeyAdapter(this.variables, (Control)this.styledText));
        }
        DropTarget dt = new DropTarget((Control)this.styledText, 2);
        dt.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent e) {
                StyledTextComp.this.styledText.setFocus();
                Point location = StyledTextComp.this.xParent.getDisplay().map(null, (Control)StyledTextComp.this.styledText, e.x, e.y);
                location.x = Math.max(0, location.x);
                location.y = Math.max(0, location.y);
                try {
                    int offset = StyledTextComp.this.styledText.getOffsetAtLocation(new Point(location.x, location.y));
                    StyledTextComp.this.styledText.setCaretOffset(offset);
                }
                catch (IllegalArgumentException ex) {
                    int maxOffset = StyledTextComp.this.styledText.getCharCount();
                    Point maxLocation = StyledTextComp.this.styledText.getLocationAtOffset(maxOffset);
                    if (location.y >= maxLocation.y) {
                        if (location.x >= maxLocation.x) {
                            StyledTextComp.this.styledText.setCaretOffset(maxOffset);
                        } else {
                            int offset = StyledTextComp.this.styledText.getOffsetAtLocation(new Point(location.x, maxLocation.y));
                            StyledTextComp.this.styledText.setCaretOffset(offset);
                        }
                    }
                    StyledTextComp.this.styledText.setCaretOffset(maxOffset);
                }
            }

            public void drop(DropTargetEvent event) {
                StyledTextComp.this.styledText.insert((String)event.data);
            }
        });
    }

    public String getSelectionText() {
        return this.styledText.getSelectionText();
    }

    public String getText() {
        return this.styledText.getText();
    }

    public void setText(String text) {
        this.styledText.setText(text);
    }

    public int getCaretOffset() {
        return this.styledText.getCaretOffset();
    }

    public int getLineAtOffset(int iOffset) {
        return this.styledText.getLineAtOffset(iOffset);
    }

    public void insert(String strInsert) {
        this.styledText.insert(strInsert);
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.styledText.addModifyListener(lsMod);
    }

    public void addLineStyleListener(LineStyleListener lineStyler) {
        this.styledText.addLineStyleListener(lineStyler);
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        this.styledText.addKeyListener((KeyListener)keyAdapter);
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        this.styledText.addFocusListener((FocusListener)focusAdapter);
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.styledText.addMouseListener((MouseListener)mouseAdapter);
    }

    public int getSelectionCount() {
        return this.styledText.getSelectionCount();
    }

    public void setSelection(int arg0) {
        this.styledText.setSelection(arg0);
    }

    public void setSelection(int arg0, int arg1) {
        this.styledText.setSelection(arg0, arg1);
    }

    public void setFont(Font fnt) {
        this.styledText.setFont(fnt);
    }

    private void buildingStyledTextMenu() {
        MenuItem undoItem = new MenuItem(this.styledTextPopupmenu, 8);
        undoItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Undo", (String[])new String[0]));
        undoItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.undo();
            }
        });
        MenuItem redoItem = new MenuItem(this.styledTextPopupmenu, 8);
        redoItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Redo", (String[])new String[0]));
        redoItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.redo();
            }
        });
        new MenuItem(this.styledTextPopupmenu, 2);
        MenuItem cutItem = new MenuItem(this.styledTextPopupmenu, 8);
        cutItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Cut", (String[])new String[0]));
        cutItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.styledText.cut();
            }
        });
        MenuItem copyItem = new MenuItem(this.styledTextPopupmenu, 8);
        copyItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Copy", (String[])new String[0]));
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.styledText.copy();
            }
        });
        MenuItem pasteItem = new MenuItem(this.styledTextPopupmenu, 8);
        pasteItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Paste", (String[])new String[0]));
        pasteItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.styledText.paste();
            }
        });
        MenuItem selectAllItem = new MenuItem(this.styledTextPopupmenu, 8);
        selectAllItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.SelectAll", (String[])new String[0]));
        selectAllItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextComp.this.styledText.selectAll();
            }
        });
        new MenuItem(this.styledTextPopupmenu, 2);
        MenuItem findItem = new MenuItem(this.styledTextPopupmenu, 8);
        findItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Find", (String[])new String[0]));
        findItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextCompFind stFind = new StyledTextCompFind(StyledTextComp.this.styledText.getShell(), StyledTextComp.this.styledText, BaseMessages.getString((Class)PKG, (String)"WidgetDialog.Styled.FindString", (String[])new String[]{StyledTextComp.this.strTabName}));
                stFind.open();
            }
        });
        MenuItem replaceItem = new MenuItem(this.styledTextPopupmenu, 8);
        replaceItem.setText(BaseMessages.getString(PKG, (String)"WidgetDialog.Styled.Replace", (String[])new String[0]));
        replaceItem.setAccelerator(262216);
        replaceItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextCompReplace stReplace = new StyledTextCompReplace(StyledTextComp.this.styledText.getShell(), StyledTextComp.this.styledText);
                stReplace.open();
            }
        });
        this.styledText.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (StyledTextComp.this.undoStack.size() > 0) {
                    StyledTextComp.this.styledTextPopupmenu.getItem(0).setEnabled(true);
                } else {
                    StyledTextComp.this.styledTextPopupmenu.getItem(0).setEnabled(false);
                }
                if (StyledTextComp.this.redoStack.size() > 0) {
                    StyledTextComp.this.styledTextPopupmenu.getItem(1).setEnabled(true);
                } else {
                    StyledTextComp.this.styledTextPopupmenu.getItem(1).setEnabled(false);
                }
                StyledTextComp.this.styledTextPopupmenu.getItem(5).setEnabled(StyledTextComp.this.checkPaste());
                if (StyledTextComp.this.styledText.getSelectionCount() > 0) {
                    StyledTextComp.this.styledTextPopupmenu.getItem(3).setEnabled(true);
                    StyledTextComp.this.styledTextPopupmenu.getItem(4).setEnabled(true);
                } else {
                    StyledTextComp.this.styledTextPopupmenu.getItem(3).setEnabled(false);
                    StyledTextComp.this.styledTextPopupmenu.getItem(4).setEnabled(false);
                }
            }
        });
        this.styledText.setMenu(this.styledTextPopupmenu);
    }

    private boolean checkPaste() {
        try {
            Clipboard clipboard = new Clipboard(this.xParent.getDisplay());
            TextTransfer transfer = TextTransfer.getInstance();
            String text = (String)clipboard.getContents((Transfer)transfer);
            return text != null && text.length() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addUndoRedoSupport() {
        this.styledText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (StyledTextComp.this.styledText.getSelectionCount() == StyledTextComp.this.styledText.getCharCount()) {
                    StyledTextComp.this.bFullSelection = true;
                    try {
                        event.wait(2L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                int iEventLength = event.length;
                int iEventStartPostition = event.start;
                String newText = StyledTextComp.this.styledText.getText();
                String repText = event.replacedText;
                String oldText = "";
                int iEventType = -1;
                if (event.length != newText.length() || StyledTextComp.this.bFullSelection) {
                    if (repText != null && repText.length() > 0) {
                        oldText = newText.substring(0, event.start) + repText + newText.substring(event.start + event.length);
                        iEventType = 0;
                        iEventLength = repText.length();
                    } else {
                        oldText = newText.substring(0, event.start) + newText.substring(event.start + event.length);
                        iEventType = 1;
                    }
                    if (oldText != null && oldText.length() > 0 || iEventStartPostition == event.length) {
                        UndoRedoStack urs = new UndoRedoStack(iEventStartPostition, newText, oldText, iEventLength, iEventType);
                        if (StyledTextComp.this.undoStack.size() == 25) {
                            StyledTextComp.this.undoStack.remove(StyledTextComp.this.undoStack.size() - 1);
                        }
                        StyledTextComp.this.undoStack.add(0, urs);
                    }
                }
                StyledTextComp.this.bFullSelection = false;
            }
        });
    }

    private void undo() {
        if (this.undoStack.size() > 0) {
            UndoRedoStack urs = this.undoStack.remove(0);
            if (this.redoStack.size() == 25) {
                this.redoStack.remove(this.redoStack.size() - 1);
            }
            UndoRedoStack rro = new UndoRedoStack(urs.getCursorPosition(), urs.getReplacedText(), this.styledText.getText(), urs.getEventLength(), urs.getType());
            this.bFullSelection = false;
            this.styledText.setText(urs.getReplacedText());
            if (urs.getType() == 1) {
                this.styledText.setCaretOffset(urs.getCursorPosition());
            } else if (urs.getType() == 0) {
                this.styledText.setCaretOffset(urs.getCursorPosition() + urs.getEventLength());
                this.styledText.setSelection(urs.getCursorPosition(), urs.getCursorPosition() + urs.getEventLength());
                if (this.styledText.getSelectionCount() == this.styledText.getCharCount()) {
                    this.bFullSelection = true;
                }
            }
            this.redoStack.add(0, rro);
        }
    }

    private void redo() {
        if (this.redoStack.size() > 0) {
            UndoRedoStack urs = this.redoStack.remove(0);
            if (this.undoStack.size() == 25) {
                this.undoStack.remove(this.undoStack.size() - 1);
            }
            UndoRedoStack rro = new UndoRedoStack(urs.getCursorPosition(), urs.getReplacedText(), this.styledText.getText(), urs.getEventLength(), urs.getType());
            this.bFullSelection = false;
            this.styledText.setText(urs.getReplacedText());
            if (urs.getType() == 1) {
                this.styledText.setCaretOffset(urs.getCursorPosition());
            } else if (urs.getType() == 0) {
                this.styledText.setCaretOffset(urs.getCursorPosition() + urs.getEventLength());
                this.styledText.setSelection(urs.getCursorPosition(), urs.getCursorPosition() + urs.getEventLength());
                if (this.styledText.getSelectionCount() == this.styledText.getCharCount()) {
                    this.bFullSelection = true;
                }
            }
            this.undoStack.add(0, rro);
        }
    }

    public StyledText getStyledText() {
        return this.styledText;
    }
}

