/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;

public class StyledTextCompReplace
extends Dialog {
    private static Class<?> PKG = StyledTextCompReplace.class;
    private Shell sShell = null;
    private Text searchText;
    private Text replaceText;
    private StyledText text;
    private Button btnNext;
    private Button btnCancel;
    private Button btnReplace;
    private Button btnReplaceAll;
    private Button btnIgnoreCase;

    public StyledTextCompReplace(Shell parent, StyledText text) {
        super(parent);
        this.text = text;
    }

    public void open() {
        Shell parent = this.getParent();
        this.sShell = new Shell(parent, 1116256);
        this.sShell.setImage(GUIResource.getInstance().getImageSpoon());
        this.sShell.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.Replace", (String[])new String[0]));
        this.sShell.setSize(new Point(351, 178));
        FormLayout formLayout = new FormLayout();
        this.sShell.setLayout((Layout)formLayout);
        this.searchText = new Text((Composite)this.sShell, 2052);
        FormData frmData = new FormData();
        frmData.left = new FormAttachment(0, 70);
        frmData.top = new FormAttachment(12, 0);
        frmData.width = 168;
        this.searchText.setLayoutData((Object)frmData);
        this.replaceText = new Text((Composite)this.sShell, 2052);
        frmData = new FormData();
        frmData.left = new FormAttachment(0, 70);
        frmData.top = new FormAttachment((Control)this.searchText, 8);
        frmData.width = 168;
        this.replaceText.setLayoutData((Object)frmData);
        Label lblFind = new Label((Composite)this.sShell, 16384);
        lblFind.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.Find", (String[])new String[0]));
        frmData = new FormData();
        frmData.right = new FormAttachment((Control)this.searchText, -8);
        frmData.top = new FormAttachment(12, 0);
        lblFind.setLayoutData((Object)frmData);
        Label lblReplace = new Label((Composite)this.sShell, 16384);
        lblReplace.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.Replace", (String[])new String[0]));
        frmData = new FormData();
        frmData.right = new FormAttachment((Control)this.replaceText, -8);
        frmData.top = new FormAttachment((Control)this.replaceText, -15);
        lblReplace.setLayoutData((Object)frmData);
        this.btnNext = new Button((Composite)this.sShell, 8);
        this.btnNext.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.FindNext", (String[])new String[0]));
        this.btnNext.setEnabled(false);
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment(9, 0);
        this.btnNext.setLayoutData((Object)frmData);
        this.btnReplace = new Button((Composite)this.sShell, 8);
        this.btnReplace.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.Replace", (String[])new String[0]));
        this.btnReplace.setEnabled(false);
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment((Control)this.btnNext, 6);
        this.btnReplace.setLayoutData((Object)frmData);
        this.btnReplaceAll = new Button((Composite)this.sShell, 8);
        this.btnReplaceAll.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.ReplaceAll", (String[])new String[0]));
        this.btnReplaceAll.setEnabled(false);
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment((Control)this.btnReplace, 6);
        this.btnReplaceAll.setLayoutData((Object)frmData);
        this.btnCancel = new Button((Composite)this.sShell, 8);
        this.btnCancel.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.Close", (String[])new String[0]));
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment((Control)this.btnReplaceAll, 6);
        this.btnCancel.setLayoutData((Object)frmData);
        this.btnIgnoreCase = new Button((Composite)this.sShell, 32);
        this.btnIgnoreCase.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.CompReplace.CaseSensitive", (String[])new String[0]));
        frmData = new FormData();
        frmData.left = new FormAttachment(5, 0);
        frmData.top = new FormAttachment(72, 0);
        this.btnIgnoreCase.setLayoutData((Object)frmData);
        this.btnNext.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!StyledTextCompReplace.this.findText()) {
                    MessageBox messageBox = new MessageBox(StyledTextCompReplace.this.sShell, 34);
                    messageBox.setText(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.CompReplace.FindItem", (String[])new String[0]));
                    messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.CompReplace.ItemNotFound", (String[])new String[]{StyledTextCompReplace.this.searchText.getText()}));
                    messageBox.open();
                }
            }
        });
        this.btnReplace.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (StyledTextCompReplace.this.text.getSelectionCount() < 1) {
                    if (!StyledTextCompReplace.this.findText()) {
                        MessageBox messageBox = new MessageBox(StyledTextCompReplace.this.sShell, 34);
                        messageBox.setText(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.CompReplace.FindItem", (String[])new String[0]));
                        messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.CompReplace.ItemNotFound", (String[])new String[]{StyledTextCompReplace.this.searchText.getText()}));
                        messageBox.open();
                    }
                } else {
                    StyledTextCompReplace.this.replaceText();
                }
            }
        });
        this.btnReplaceAll.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextCompReplace.this.text.setCaretOffset(-1);
                int counter = 0;
                while (StyledTextCompReplace.this.findText()) {
                    StyledTextCompReplace.this.replaceText();
                    ++counter;
                }
            }
        });
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextCompReplace.this.sShell.dispose();
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StyledTextCompReplace.this.searchText.getText() != null && StyledTextCompReplace.this.searchText.getText().length() > 0) {
                    StyledTextCompReplace.this.btnNext.setEnabled(true);
                } else {
                    StyledTextCompReplace.this.btnNext.setEnabled(false);
                    StyledTextCompReplace.this.btnReplace.setEnabled(false);
                    StyledTextCompReplace.this.btnReplaceAll.setEnabled(false);
                }
            }
        });
        this.replaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StyledTextCompReplace.this.replaceText.getText() != null && StyledTextCompReplace.this.replaceText.getText().length() > 0 && StyledTextCompReplace.this.btnNext.isEnabled()) {
                    StyledTextCompReplace.this.btnReplace.setEnabled(true);
                    StyledTextCompReplace.this.btnReplaceAll.setEnabled(true);
                } else {
                    StyledTextCompReplace.this.btnReplace.setEnabled(false);
                    StyledTextCompReplace.this.btnReplaceAll.setEnabled(false);
                }
            }
        });
        if (this.text.getSelectionText() != null) {
            this.searchText.setText(this.text.getSelectionText());
            this.replaceText.setFocus();
        }
        this.setSearchText();
        this.sShell.open();
        Display display = parent.getDisplay();
        while (!this.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private boolean findText() {
        String searchString = this.searchText.getText();
        String textString = this.text.getText();
        int offset = this.text.getCaretOffset();
        int start = -1;
        if (!this.btnIgnoreCase.getSelection()) {
            searchString = searchString.toLowerCase();
            textString = textString.toLowerCase();
        }
        if ((start = textString.indexOf(searchString, offset)) > -1) {
            this.text.setSelection(start, start + searchString.length());
            return true;
        }
        return false;
    }

    private void setSearchText() {
        if (this.text != null && !Const.isEmpty((String)this.text.getSelectionText())) {
            this.searchText.setText(this.text.getSelectionText());
        }
        this.searchText.setFocus();
    }

    private void replaceText() {
        int start = this.text.getSelectionRange().x;
        this.text.replaceTextRange(start, this.text.getSelectionCount(), this.replaceText.getText());
        this.text.setSelection(start, start + this.replaceText.getText().length());
    }
}

