/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.pentaho.di.core.gui.TextFileInputFieldInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDraw
extends Canvas {
    private Display display;
    private Color bg;
    private Color black;
    private Color red;
    private Color blue;
    private Color lgray;
    private Point offset;
    private ScrollBar hori;
    private ScrollBar vert;
    private Image dummy_image;
    private GC dummy_gc;
    private int maxlen;
    private int fontheight;
    private int fontwidth;
    private Image cache_image;
    private int prev_fromx;
    private int prev_tox;
    private int prev_fromy;
    private int prev_toy;
    private Vector<TextFileInputFieldInterface> fields;
    private List<String> rows;
    private static final int LEFT = 50;
    private static final int TOP = 30;
    private static final int MARGIN = 10;
    private int potential_click;
    private WizardPage wPage;
    private String prevfieldname;

    public TableDraw(Composite parent, PropsUI props, WizardPage wPage, Vector<TextFileInputFieldInterface> fields) {
        super(parent, 262912);
        this.wPage = wPage;
        this.fields = fields;
        this.prevfieldname = "";
        this.potential_click = -1;
        this.cache_image = null;
        this.prev_fromx = -1;
        this.prev_tox = -1;
        this.prev_fromy = -1;
        this.prev_toy = -1;
        this.display = parent.getDisplay();
        this.bg = GUIResource.getInstance().getColorBackground();
        this.fontheight = props.getGridFont().getHeight();
        this.black = GUIResource.getInstance().getColorBlack();
        this.red = GUIResource.getInstance().getColorRed();
        this.blue = GUIResource.getInstance().getColorBlue();
        this.lgray = GUIResource.getInstance().getColorLightGray();
        this.hori = this.getHorizontalBar();
        this.vert = this.getVerticalBar();
        this.dummy_image = new Image((Device)this.display, 1, 1);
        this.dummy_gc = new GC((Drawable)this.dummy_image);
        String teststring = "ABCDEF";
        this.fontwidth = Math.round(this.dummy_gc.textExtent((String)teststring).x / teststring.length());
        this.setBackground(this.bg);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableDraw.this.paintControl(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                TableDraw.this.dummy_gc.dispose();
                TableDraw.this.dummy_image.dispose();
                if (TableDraw.this.cache_image != null) {
                    TableDraw.this.cache_image.dispose();
                }
            }
        });
        this.hori.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDraw.this.redraw();
            }
        });
        this.vert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDraw.this.redraw();
            }
        });
        this.hori.setThumb(100);
        this.vert.setThumb(100);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point offset = TableDraw.this.getOffset();
                int posx = (int)Math.round((double)(e.x - 50 - 10 - offset.x) / (double)TableDraw.this.fontwidth);
                if (posx > 0) {
                    TableDraw.this.potential_click = posx;
                    TableDraw.this.redraw();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (TableDraw.this.potential_click > 0) {
                    TableDraw.this.setMarker(TableDraw.this.potential_click);
                    TableDraw.this.potential_click = -1;
                    TableDraw.this.redraw();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TextFileInputFieldInterface field;
                int posx = (int)Math.round((double)(e.x - 50 - 10 - ((TableDraw)TableDraw.this).offset.x) / (double)TableDraw.this.fontwidth);
                if (TableDraw.this.potential_click >= 0 && posx > 0) {
                    TableDraw.this.potential_click = posx;
                    TableDraw.this.redraw();
                }
                if ((field = TableDraw.this.getFieldOnPosition(posx)) != null && !field.getName().equalsIgnoreCase(TableDraw.this.prevfieldname)) {
                    TableDraw.this.setToolTipText(field.getName() + " : length=" + field.getLength());
                    TableDraw.this.prevfieldname = field.getName();
                }
            }
        });
    }

    private TextFileInputFieldInterface getFieldOnPosition(int x) {
        for (int i = 0; i < this.fields.size(); ++i) {
            TextFileInputFieldInterface field = this.fields.get(i);
            int pos = field.getPosition();
            int len = field.getLength();
            if (pos > x || pos + len <= x) continue;
            return field;
        }
        return null;
    }

    private void setMarker(int x) {
        TextFileInputFieldInterface field;
        int idx = -1;
        int highest_smaller = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            field = this.fields.get(i);
            int pos = field.getPosition();
            int len = field.getLength();
            if (pos == this.potential_click) {
                idx = i;
            }
            if (highest_smaller >= 0 || pos + len < x) continue;
            highest_smaller = i;
        }
        if (idx < 0) {
            if (highest_smaller >= 0) {
                TextFileInputFieldInterface prevfield = this.fields.get(highest_smaller);
                int newlength = prevfield.getLength() - (x - prevfield.getPosition());
                TextFileInputFieldInterface field2 = prevfield.createNewInstance(this.getNewFieldname(), x, newlength);
                this.fields.add(highest_smaller + 1, field2);
                prevfield.setLength(x - prevfield.getPosition());
            }
        } else if (highest_smaller >= 0) {
            TextFileInputFieldInterface prevfield = this.fields.get(highest_smaller);
            field = this.fields.get(idx);
            prevfield.setLength(prevfield.getLength() + field.getLength());
            this.fields.remove(idx);
        }
        this.wPage.setPageComplete(this.wPage.canFlipToNextPage());
    }

    private String getNewFieldname() {
        int nr = 1;
        String name = "Field" + nr;
        while (this.fieldExists(name)) {
            name = "Field" + ++nr;
        }
        return name;
    }

    private boolean fieldExists(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            TextFileInputFieldInterface field = this.fields.get(i);
            if (!name.equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        return false;
    }

    public void setRows(List<String> rows) {
        this.rows = rows;
        this.maxlen = this.getMaxLength();
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc;
        this.offset = this.getOffset();
        if (this.offset == null) {
            return;
        }
        Point area = this.getArea();
        Point max = this.getMaximum();
        Point thumb = this.getThumb(area, max);
        this.hori.setThumb(thumb.x);
        this.vert.setThumb(thumb.y);
        int fromy = -this.offset.y / (this.fontheight + 2);
        int toy = fromy + area.y / (this.fontheight + 2);
        int fromx = -this.offset.x / this.fontwidth;
        int tox = fromx + area.x / this.fontwidth;
        Image image = new Image((Device)this.display, area.x, area.y);
        if (fromx != this.prev_fromx || fromy != this.prev_fromy || tox != this.prev_tox || toy != this.prev_toy) {
            int numsize;
            String number;
            int i;
            if (this.cache_image != null) {
                this.cache_image.dispose();
                this.cache_image = null;
            }
            this.cache_image = new Image((Device)this.display, area.x, area.y);
            gc = new GC((Drawable)this.cache_image);
            int linepos = 25;
            gc.setBackground(this.bg);
            gc.fillRectangle(50, 30, area.x, area.y);
            gc.setForeground(this.black);
            for (i = fromy; i < this.rows.size() && i < toy; ++i) {
                String str = this.rows.get(i);
                for (int p = fromx; p < str.length() && p < tox; ++p) {
                    gc.drawText("" + str.charAt(p), 60 + p * this.fontwidth + this.offset.x, 30 + i * (this.fontheight + 2) + this.offset.y, true);
                }
                if (str.length() >= tox) continue;
                gc.setForeground(this.red);
                gc.setBackground(this.red);
                int x_oval = 60 + str.length() * this.fontwidth + this.offset.x;
                int y_oval = 30 + i * (this.fontheight + 2) + this.offset.y;
                gc.drawOval(x_oval, y_oval, this.fontwidth, this.fontheight);
                gc.fillOval(x_oval, y_oval, this.fontwidth, this.fontheight);
                gc.setForeground(this.black);
                gc.setBackground(this.bg);
            }
            gc.setBackground(this.lgray);
            gc.fillRectangle(60, 0, area.x, linepos + 1);
            gc.setBackground(this.bg);
            gc.drawLine(60, linepos, area.x, linepos);
            for (i = fromx; i < this.maxlen + 10 && i < tox + 10; ++i) {
                number = "" + i;
                numsize = number.length() * this.fontwidth;
                if (i > 0 && i % 10 == 0) {
                    gc.drawText("" + i, 60 + i * this.fontwidth - numsize / 2 + this.offset.x, linepos - 10 - this.fontheight, true);
                }
                if (i > 0 && i % 5 == 0) {
                    gc.drawLine(60 + i * this.fontwidth + this.offset.x, linepos, 60 + i * this.fontwidth + this.offset.x, linepos - 5);
                    continue;
                }
                gc.drawLine(60 + i * this.fontwidth + this.offset.x, linepos, 60 + i * this.fontwidth + this.offset.x, linepos - 3);
            }
            gc.setBackground(this.lgray);
            gc.fillRectangle(0, 30, 50, area.y);
            gc.drawLine(50, 30, 50, area.y);
            for (i = fromy; i < this.rows.size() && i < toy; ++i) {
                number = "" + (i + 1);
                numsize = number.length() * this.fontwidth;
                gc.drawText(number, 45 - numsize, 30 + i * (this.fontheight + 2) + this.offset.y, true);
                gc.drawLine(50, 30 + (i + 1) * (this.fontheight + 2) + this.offset.y, 45, 30 + (i + 1) * (this.fontheight + 2) + this.offset.y);
            }
            gc.dispose();
        }
        gc = new GC((Drawable)image);
        gc.drawImage(this.cache_image, 0, 0);
        gc.setForeground(this.red);
        gc.setBackground(this.red);
        for (int i = 0; i < this.fields.size(); ++i) {
            int x = this.fields.get(i).getPosition();
            if (x < fromx || x > tox) continue;
            this.drawMarker(gc, x, area.y);
        }
        if (this.potential_click >= 0) {
            gc.setForeground(this.blue);
            gc.setBackground(this.blue);
            this.drawMarker(gc, this.potential_click, area.y);
        }
        e.gc.drawImage(image, 0, 0);
        gc.dispose();
        image.dispose();
    }

    private void drawMarker(GC gc, int x, int maxy) {
        int[] triangle = new int[]{60 + x * this.fontwidth + this.offset.x, 26, 60 + x * this.fontwidth + this.offset.x + 3, 31, 60 + x * this.fontwidth + this.offset.x - 3, 31};
        gc.fillPolygon(triangle);
        gc.drawPolygon(triangle);
        gc.drawLine(60 + x * this.fontwidth + this.offset.x, 31, 60 + x * this.fontwidth + this.offset.x, maxy);
    }

    private Point getOffset() {
        Point area = this.getArea();
        Point max = this.getMaximum();
        Point thumb = this.getThumb(area, max);
        Point offset = this.getOffset(thumb, area);
        return offset;
    }

    private Point getThumb(Point area, Point max) {
        Point thumb = new Point(0, 0);
        thumb.x = max.x <= area.x ? 100 : Math.round(100 * area.x / max.x);
        thumb.y = max.y <= area.y ? 100 : Math.round(100 * area.y / max.y);
        return thumb;
    }

    private Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round(-sel.x * area.x / thumb.x);
        p.y = Math.round(-sel.y * area.y / thumb.y);
        return p;
    }

    private Point getMaximum() {
        int maxx = 0;
        int maxy = (this.rows.size() + 10) * (this.fontheight + 2);
        for (int i = 0; i < this.rows.size(); ++i) {
            String str = this.rows.get(i);
            int len = (str.length() + 10) * this.fontwidth;
            if (maxx >= len) continue;
            maxx = len;
        }
        return new Point(maxx, maxy);
    }

    private int getMaxLength() {
        int maxx = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            String str = this.rows.get(i);
            int len = str.length();
            if (maxx >= len) continue;
            maxx = len;
        }
        return maxx;
    }

    private Point getArea() {
        Rectangle rect = this.getClientArea();
        Point area = new Point(rect.width, rect.height);
        return area;
    }

    public Vector<TextFileInputFieldInterface> getFields() {
        return this.fields;
    }

    public void setFields(Vector<TextFileInputFieldInterface> fields) {
        this.fields = fields;
    }

    public void clearFields() {
        this.fields = new Vector();
    }
}

