/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget.warning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.CheckBoxVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.core.widget.warning.SupportsWarningInterface;
import org.pentaho.di.ui.core.widget.warning.WarningInterface;
import org.pentaho.di.ui.core.widget.warning.WarningMessageInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextVarWarning
extends Composite
implements SupportsWarningInterface {
    private static Class<?> PKG = CheckBoxVar.class;
    private ControlDecoration warningControlDecoration;
    private TextVar wText;
    private List<WarningInterface> warningInterfaces = new ArrayList<WarningInterface>();

    public TextVarWarning(VariableSpace space, Composite composite, int flags) {
        super(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wText = new TextVar(space, this, flags);
        this.warningControlDecoration = new ControlDecoration((Control)this.wText, 0x1020000);
        Image warningImage = GUIResource.getInstance().getImageWarning();
        this.warningControlDecoration.setImage(warningImage);
        this.warningControlDecoration.setDescriptionText(BaseMessages.getString(PKG, (String)"TextVar.tooltip.FieldIsInUse", (String[])new String[0]));
        this.warningControlDecoration.hide();
        this.wText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                boolean foundOne = false;
                for (WarningInterface warningInterface : TextVarWarning.this.warningInterfaces) {
                    WarningMessageInterface warningSituation = warningInterface.getWarningSituation(TextVarWarning.this.wText.getText(), (Control)TextVarWarning.this.wText, this);
                    if (!warningSituation.isWarning()) continue;
                    foundOne = true;
                    TextVarWarning.this.warningControlDecoration.show();
                    TextVarWarning.this.warningControlDecoration.setDescriptionText(warningSituation.getWarningMessage());
                    break;
                }
                if (!foundOne) {
                    TextVarWarning.this.warningControlDecoration.hide();
                }
            }
        });
        FormData fdText = new FormData();
        fdText.top = new FormAttachment(0, 0);
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, -warningImage.getBounds().width);
        this.wText.setLayoutData(fdText);
    }

    public String getText() {
        return this.wText.getText();
    }

    public void setText(String text) {
        this.wText.setText(text);
    }

    public TextVar getTextWidget() {
        return this.wText;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wText.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionAdapter lsDef) {
        this.wText.addSelectionListener(lsDef);
    }

    public void addKeyListener(KeyListener lsKey) {
        this.wText.addKeyListener(lsKey);
    }

    public void addFocusListener(FocusListener lsFocus) {
        this.wText.addFocusListener(lsFocus);
    }

    public void setEchoChar(char c) {
        this.wText.setEchoChar(c);
    }

    public void setEnabled(boolean flag) {
        this.wText.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wText.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wText.addTraverseListener(tl);
    }

    public void setEditable(boolean editable) {
        this.wText.setEditable(editable);
    }

    public void setSelection(int i) {
        this.wText.setSelection(i);
    }

    public void selectAll() {
        this.wText.selectAll();
    }

    public void showSelection() {
        this.wText.showSelection();
    }

    @Override
    public void addWarningInterface(WarningInterface warningInterface) {
        this.warningInterfaces.add(warningInterface);
    }

    public void removeWarningInterface(WarningInterface warningInterface) {
        this.warningInterfaces.remove(warningInterface);
    }

    public List<WarningInterface> getWarningInterfaces() {
        return this.warningInterfaces;
    }
}

