/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.MessagesStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleStore {
    private String locale;
    private List<String> messagesPackages;
    private Map<String, MessagesStore> localeMap;
    private String mainLocale;
    private Map<String, List<KeyOccurrence>> packageOccurrences;
    private LogChannelInterface log;

    public LocaleStore(LogChannelInterface log, String locale, List<String> messagesPackages, String mainLocale, Map<String, List<KeyOccurrence>> packageOccurrences) {
        this.log = log;
        this.locale = locale;
        this.messagesPackages = messagesPackages;
        this.mainLocale = mainLocale;
        this.localeMap = new Hashtable<String, MessagesStore>();
        this.packageOccurrences = packageOccurrences;
    }

    public void read(List<String> directories) throws KettleException {
        for (String messagePackage : this.messagesPackages) {
            MessagesStore messagesStore = new MessagesStore(this.locale, messagePackage, this.packageOccurrences);
            try {
                messagesStore.read(directories);
                this.localeMap.put(messagePackage, messagesStore);
            }
            catch (Exception e) {
                if (this.locale.equals(this.mainLocale)) {
                    throw new KettleException((Throwable)e);
                }
                this.log.logDetailed("No translations found for locale '" + this.locale + "' in package '" + messagePackage + "'");
            }
        }
    }

    public List<String> getMessagesPackages() {
        return this.messagesPackages;
    }

    public void setMessagesPackages(List<String> messagesPackages) {
        this.messagesPackages = messagesPackages;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getMainLocale() {
        return this.mainLocale;
    }

    public void setMainLocale(String mainLocale) {
        this.mainLocale = mainLocale;
    }

    public Map<String, MessagesStore> getLocaleMap() {
        return this.localeMap;
    }

    public void setLocaleMap(Map<String, MessagesStore> localeMap) {
        this.localeMap = localeMap;
    }

    public Map<String, List<KeyOccurrence>> getPackagesOccurrences() {
        return this.packageOccurrences;
    }

    public void setPackagesOccurrences(Map<String, List<KeyOccurrence>> packagesOccurrences) {
        this.packageOccurrences = packagesOccurrences;
    }
}

