/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.SourceCrawlerPackageException;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLElement;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesSourceCrawler {
    private String[] scanPhrases;
    private List<String> sourceDirectories;
    private List<KeyOccurrence> occurrences;
    private Map<String, List<KeyOccurrence>> packageOccurrences;
    private List<String> filesToAvoid;
    private String singleMessagesFile;
    private List<SourceCrawlerXMLFolder> xmlFolders;
    private Pattern packagePattern;
    private Pattern importPattern;
    private Pattern importMessagesPattern;
    private Pattern stringPkgPattern;
    private Pattern classPkgPattern;
    private LogChannelInterface log;

    public MessagesSourceCrawler(LogChannelInterface log, List<String> sourceDirectories, String singleMessagesFile, List<SourceCrawlerXMLFolder> xmlFolders) {
        this.log = log;
        this.sourceDirectories = sourceDirectories;
        this.singleMessagesFile = singleMessagesFile;
        this.occurrences = new ArrayList<KeyOccurrence>();
        this.filesToAvoid = new ArrayList<String>();
        this.xmlFolders = xmlFolders;
        this.packageOccurrences = new Hashtable<String, List<KeyOccurrence>>();
        this.packagePattern = Pattern.compile("^\\s*package .*;[ \t]*$");
        this.importPattern = Pattern.compile("^\\s*import [a-z\\._0-9]*\\.[A-Z].*;[ \t]*$");
        this.importMessagesPattern = Pattern.compile("^\\s*import [a-z\\._0-9]*\\.Messages;[ \t]*$");
        this.stringPkgPattern = Pattern.compile("^.*private static String PKG.*=.*$");
        this.classPkgPattern = Pattern.compile("^.*private static Class.*\\sPKG\\s*=.*$");
    }

    public List<String> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(List<String> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    public List<KeyOccurrence> getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(List<KeyOccurrence> occurrences) {
        this.occurrences = occurrences;
    }

    public List<String> getFilesToAvoid() {
        return this.filesToAvoid;
    }

    public void setFilesToAvoid(List<String> filesToAvoid) {
        this.filesToAvoid = filesToAvoid;
    }

    public void addKeyOccurrence(KeyOccurrence occ) {
        int index = Collections.binarySearch(this.occurrences, occ);
        if (index < 0) {
            this.occurrences.add(-index - 1, occ);
            List<KeyOccurrence> list = this.packageOccurrences.get(occ.getMessagesPackage());
            if (list == null) {
                list = new ArrayList<KeyOccurrence>();
                this.packageOccurrences.put(occ.getMessagesPackage(), list);
            }
            list.add(occ);
        } else {
            KeyOccurrence keyOccurrence = this.occurrences.get(index);
            keyOccurrence.incrementOccurrences();
        }
    }

    public void crawl() throws Exception {
        String[] dirs = new String[this.sourceDirectories.size()];
        String[] masks = new String[this.sourceDirectories.size()];
        String[] req = new String[this.sourceDirectories.size()];
        boolean[] subdirs = new boolean[this.sourceDirectories.size()];
        for (int i = 0; i < masks.length; ++i) {
            dirs[i] = this.sourceDirectories.get(i);
            masks[i] = ".*\\.java$";
            req[i] = "N";
            subdirs[i] = true;
        }
        FileInputList fileInputList = FileInputList.createFileList((VariableSpace)new Variables(), (String[])dirs, (String[])masks, (String[])req, (boolean[])subdirs);
        for (FileObject fileObject : new ArrayList(fileInputList.getFiles())) {
            for (String filename : this.filesToAvoid) {
                if (!fileObject.getName().getBaseName().equals(filename)) continue;
                fileInputList.getFiles().remove(fileObject);
            }
        }
        for (FileObject fileObject : fileInputList.getFiles()) {
            this.lookForOccurrencesInFile(fileObject);
        }
        for (SourceCrawlerXMLFolder xmlFolder : this.xmlFolders) {
            String[] xmlDirs = new String[]{xmlFolder.getFolder()};
            String[] xmlMasks = new String[]{xmlFolder.getWildcard()};
            String[] xmlReq = new String[]{"N"};
            boolean[] xmlSubdirs = new boolean[]{true};
            FileInputList xulFileInputList = FileInputList.createFileList((VariableSpace)new Variables(), (String[])xmlDirs, (String[])xmlMasks, (String[])xmlReq, (boolean[])xmlSubdirs);
            for (FileObject fileObject : xulFileInputList.getFiles()) {
                try {
                    Document doc = XMLHandler.loadXMLFile((FileObject)fileObject);
                    for (SourceCrawlerXMLElement xmlElement : xmlFolder.getElements()) {
                        this.addLabelOccurrences(fileObject, doc.getElementsByTagName(xmlElement.getSearchElement()), xmlFolder.getKeyPrefix(), xmlElement.getKeyTag(), xmlElement.getKeyAttribute(), xmlFolder.getDefaultPackage(), xmlFolder.getPackageExceptions());
                    }
                }
                catch (KettleXMLException e) {
                    this.log.logError("Unable to open XUL / XML document: " + fileObject);
                }
            }
        }
    }

    private void addLabelOccurrences(FileObject fileObject, NodeList nodeList, String keyPrefix, String tag, String attribute, String defaultPackage, List<SourceCrawlerPackageException> packageExcpeptions) throws Exception {
        if (nodeList == null) {
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String labelString = null;
            if (!Const.isEmpty((String)attribute)) {
                labelString = XMLHandler.getTagAttribute((Node)node, (String)attribute);
            } else if (!Const.isEmpty((String)tag)) {
                labelString = XMLHandler.getTagValue((Node)node, (String)tag);
            }
            keyPrefix = "$";
            if (labelString == null || !labelString.startsWith(keyPrefix)) continue;
            String key = labelString.substring(1);
            key = labelString.substring(2, labelString.length() - 1).trim();
            String messagesPackage = defaultPackage;
            for (SourceCrawlerPackageException packageException : packageExcpeptions) {
                if (!key.startsWith(packageException.getStartsWith())) continue;
                messagesPackage = packageException.getPackageName();
            }
            StringWriter bodyXML = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(bodyXML));
            String xml = bodyXML.getBuffer().toString();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, messagesPackage, -1, -1, key, "?", xml);
            if (this.occurrences.contains(keyOccurrence)) continue;
            this.occurrences.add(keyOccurrence);
        }
    }

    public void lookForOccurrencesInFile(FileObject fileObject) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(KettleVFS.getInputStream((FileObject)fileObject)));
        String messagesPackage = null;
        int row = 0;
        String classPackage = null;
        Hashtable<String, String> importedClasses = new Hashtable<String, String>();
        String line = reader.readLine();
        while (line != null) {
            int beginIndex;
            String expression;
            int lastDotIndex;
            int endIndex;
            boolean extraLine;
            ++row;
            String line2 = line;
            do {
                extraLine = false;
                for (String scanPhrase : this.scanPhrases) {
                    if (!line2.endsWith(scanPhrase)) continue;
                    extraLine = true;
                    break;
                }
                if (!extraLine) continue;
                line2 = reader.readLine();
                line = line + line2;
            } while (extraLine);
            if (this.packagePattern.matcher(line).matches()) {
                int beginIndex2 = line.indexOf("org.pentaho.");
                endIndex = line.indexOf(59);
                if (beginIndex2 >= 0 && endIndex >= 0) {
                    classPackage = messagesPackage = line.substring(beginIndex2, endIndex);
                }
            }
            if (this.importPattern.matcher(line).matches() && (lastDotIndex = (expression = line.substring(beginIndex = line.indexOf("import") + "import".length() + 1, endIndex = line.indexOf(";", beginIndex))).lastIndexOf(46)) > 0) {
                String packageName = expression.substring(0, lastDotIndex);
                String className = expression.substring(lastDotIndex + 1);
                if (!"*".equals(className)) {
                    importedClasses.put(className, packageName);
                }
            }
            if (this.importMessagesPattern.matcher(line).matches()) {
                beginIndex = line.indexOf("org.pentaho.");
                endIndex = line.indexOf(".Messages;");
                messagesPackage = line.substring(beginIndex, endIndex);
            }
            if (this.stringPkgPattern.matcher(line).matches()) {
                beginIndex = line.indexOf(34) + 1;
                endIndex = line.indexOf(34, beginIndex);
                messagesPackage = line.substring(beginIndex, endIndex);
            }
            if (classPackage != null && this.classPkgPattern.matcher(line).matches()) {
                int toIndex;
                int fromIndex = line.indexOf(61) + 1;
                expression = Const.trim((String)line.substring(fromIndex, toIndex = line.indexOf(".class", fromIndex)));
                if (expression.contains(".")) {
                    lastDotIndex = expression.lastIndexOf(46);
                    messagesPackage = expression.substring(0, lastDotIndex);
                } else {
                    String packageName = (String)importedClasses.get(expression);
                    messagesPackage = packageName == null ? classPackage : packageName;
                }
            }
            for (String scanPhrase : this.scanPhrases) {
                int index = line.indexOf(scanPhrase);
                while (index >= 0) {
                    if (index == 0 || index > 0 & !Character.isJavaIdentifierPart(line.charAt(index - 1))) {
                        this.addLineOccurrence(fileObject, messagesPackage, line, row, index, scanPhrase);
                    }
                    index = line.indexOf(scanPhrase, index + 1);
                }
            }
            line = reader.readLine();
        }
        reader.close();
    }

    private void addLineOccurrence(FileObject fileObject, String messagesPackage, String line, int row, int index, String scanPhrase) {
        String key;
        int column = index + scanPhrase.length();
        String arguments = "";
        int startKeyIndex = line.indexOf(34, column) + 1;
        int endKeyIndex = line.indexOf(34, startKeyIndex);
        if (endKeyIndex >= 0) {
            int bracketIndex;
            key = line.substring(startKeyIndex, endKeyIndex);
            int nrOpen = 1;
            for (bracketIndex = endKeyIndex; bracketIndex < line.length() && nrOpen != 0; ++bracketIndex) {
                char c = line.charAt(bracketIndex);
                if (c == '(') {
                    ++nrOpen;
                }
                if (c != ')') continue;
                --nrOpen;
            }
            arguments = bracketIndex + 1 < line.length() ? line.substring(endKeyIndex + 1, bracketIndex) : line.substring(endKeyIndex + 1);
        } else {
            key = line.substring(startKeyIndex);
        }
        if (key.contains("\t") || key.contains(" ")) {
            System.out.println("Suspect key found: [" + key + "] in file [" + fileObject + "]");
        }
        if (key.startsWith("System.")) {
            String i18nPackage = BaseMessages.class.getPackage().getName();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, i18nPackage, row, column, key, arguments, line);
            KeyOccurrence lookup = this.getKeyOccurrence(key, i18nPackage);
            if (lookup == null) {
                this.addKeyOccurrence(keyOccurrence);
            } else {
                lookup.setSourceLine(lookup.getSourceLine() + Const.CR + keyOccurrence.getSourceLine());
                lookup.incrementOccurrences();
            }
        } else {
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, messagesPackage, row, column, key, arguments, line);
            this.addKeyOccurrence(keyOccurrence);
        }
    }

    public List<String> getMessagesPackagesList() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (KeyOccurrence keyOccurrence : this.occurrences) {
            table.put(keyOccurrence.getMessagesPackage(), keyOccurrence.getMessagesPackage());
        }
        ArrayList<String> list = new ArrayList<String>(table.keySet());
        Collections.sort(list);
        return list;
    }

    public List<KeyOccurrence> getOccurrencesForPackage(String messagesPackage) {
        ArrayList<KeyOccurrence> list = new ArrayList<KeyOccurrence>();
        for (KeyOccurrence keyOccurrence : this.occurrences) {
            if (!keyOccurrence.getMessagesPackage().equals(messagesPackage)) continue;
            list.add(keyOccurrence);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        directories.add("src-core");
        directories.add("src");
        directories.add("src-ui");
        ArrayList<String> filesToAvoid = new ArrayList<String>();
        filesToAvoid.add("MessagesSourceCrawler.java");
        filesToAvoid.add("KeyOccurence.java");
        filesToAvoid.add("TransLator.java");
        filesToAvoid.add("MenuHelper.java");
        filesToAvoid.add("Messages.java");
        filesToAvoid.add("XulMessages.java");
        filesToAvoid.add("AnnotatedStepsConfigManager.java");
        filesToAvoid.add("AnnotatedJobConfigManager.java");
        filesToAvoid.add("JobEntryValidatorUtils.java");
        filesToAvoid.add("Const.java");
        filesToAvoid.add("XulHelper.java");
        ArrayList<SourceCrawlerXMLFolder> xmlFolders = new ArrayList<SourceCrawlerXMLFolder>();
        SourceCrawlerXMLFolder xmlFolder = new SourceCrawlerXMLFolder("ui", ".*\\.xul$", "%");
        xmlFolder.getElements().add(new SourceCrawlerXMLElement("menu", null, "label"));
        xmlFolder.getElements().add(new SourceCrawlerXMLElement("menuitem", null, "label"));
        xmlFolder.getElements().add(new SourceCrawlerXMLElement("toolbar", null, "label"));
        xmlFolder.getElements().add(new SourceCrawlerXMLElement("toolbarbutton", null, "label"));
        xmlFolders.add(xmlFolder);
        MessagesSourceCrawler crawler = new MessagesSourceCrawler((LogChannelInterface)new LogChannel((Object)"Source crawler"), directories, null, xmlFolders);
        crawler.setFilesToAvoid(filesToAvoid);
        crawler.crawl();
        int mis = 0;
        LanguageChoice.getInstance().setDefaultLocale(Locale.US);
        for (KeyOccurrence occ : crawler.getOccurrences()) {
            String translation = BaseMessages.getString((String)occ.getMessagesPackage(), (String)occ.getKey());
            if (!translation.startsWith("!")) continue;
            System.out.println(++mis + "\t" + occ.getKey() + "\t" + occ.getRow() + "\t" + occ.getMessagesPackage() + "\t" + occ.getFileObject().getName().getBaseName() + "\t" + occ.getFileObject().getParent());
        }
        System.out.println("-------------------------------------------------");
        System.out.println("Found " + crawler.getOccurrences().size());
        System.out.println("-------------------------------------------------");
        List<String> packageNames = crawler.getMessagesPackagesList();
        System.out.println("Packages found : " + packageNames.size());
    }

    public KeyOccurrence getKeyOccurrence(String key, String selectedMessagesPackage) {
        for (KeyOccurrence keyOccurrence : this.occurrences) {
            if (!keyOccurrence.getKey().equals(key) || !keyOccurrence.getMessagesPackage().equals(selectedMessagesPackage)) continue;
            return keyOccurrence;
        }
        return null;
    }

    public String getSingleMessagesFile() {
        return this.singleMessagesFile;
    }

    public void setSingleMessagesFile(String singleMessagesFile) {
        this.singleMessagesFile = singleMessagesFile;
    }

    public String[] getScanPhrases() {
        return this.scanPhrases;
    }

    public void setScanPhrases(String[] scanPhrases) {
        this.scanPhrases = scanPhrases;
    }

    public Map<String, List<KeyOccurrence>> getPackageOccurrences() {
        return this.packageOccurrences;
    }

    public void setPackageOccurrences(Map<String, List<KeyOccurrence>> packageOccurrences) {
        this.packageOccurrences = packageOccurrences;
    }
}

