/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.LocaleStore;
import org.pentaho.di.ui.i18n.MessagesStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationsStore {
    private List<String> localeList;
    private List<String> messagesPackages;
    private Map<String, LocaleStore> translationsMap;
    private String mainLocale;
    private Map<String, List<KeyOccurrence>> packageOccurrences;
    private LogChannelInterface log;

    public TranslationsStore(LogChannelInterface log, List<String> localeList, List<String> messagesPackages, String mainLocale, Map<String, List<KeyOccurrence>> packageOccurrences) {
        this.log = log;
        this.localeList = localeList;
        this.messagesPackages = messagesPackages;
        this.mainLocale = mainLocale;
        this.packageOccurrences = packageOccurrences;
        this.translationsMap = new Hashtable<String, LocaleStore>();
    }

    public void read(List<String> directories) throws KettleException {
        for (String locale : this.localeList) {
            LocaleStore localeStore = new LocaleStore(this.log, locale, this.messagesPackages, this.mainLocale, this.packageOccurrences);
            localeStore.read(directories);
            this.translationsMap.put(locale, localeStore);
        }
    }

    public List<String> getLocaleList() {
        return this.localeList;
    }

    public void setLocaleList(List<String> localeList) {
        this.localeList = localeList;
    }

    public List<String> getMessagesPackages() {
        return this.messagesPackages;
    }

    public void setMessagesPackages(List<String> messagesPackages) {
        this.messagesPackages = messagesPackages;
    }

    public Map<String, LocaleStore> getTranslationsMap() {
        return this.translationsMap;
    }

    public void setTranslationsMap(Map<String, LocaleStore> translationsMap) {
        this.translationsMap = translationsMap;
    }

    public String getMainLocale() {
        return this.mainLocale;
    }

    public void setMainLocale(String mainLocale) {
        this.mainLocale = mainLocale;
    }

    public String lookupKeyValue(String locale, String messagesPackage, String key) {
        MessagesStore messagesStore;
        LocaleStore localeStore = this.translationsMap.get(locale);
        if (localeStore != null && (messagesStore = localeStore.getLocaleMap().get(messagesPackage)) != null) {
            return messagesStore.getMessagesMap().get(key);
        }
        return null;
    }

    public void removeValue(String locale, String messagesPackage, String key) {
        MessagesStore messagesStore;
        LocaleStore localeStore = this.translationsMap.get(locale);
        if (localeStore != null && (messagesStore = localeStore.getLocaleMap().get(messagesPackage)) != null) {
            messagesStore.getMessagesMap().remove(key);
            messagesStore.setChanged();
        }
    }

    public void storeValue(String locale, String messagesPackage, String key, String value) {
        MessagesStore messagesStore;
        LocaleStore localeStore = this.translationsMap.get(locale);
        if (localeStore == null) {
            localeStore = new LocaleStore(this.log, locale, this.messagesPackages, this.mainLocale, this.packageOccurrences);
            this.translationsMap.put(locale, localeStore);
        }
        if ((messagesStore = localeStore.getLocaleMap().get(messagesPackage)) == null) {
            messagesStore = new MessagesStore(locale, messagesPackage, this.packageOccurrences);
            localeStore.getLocaleMap().put(messagesPackage, messagesStore);
        }
        messagesStore.getMessagesMap().put(key, value);
        messagesStore.setChanged();
    }

    public List<MessagesStore> getChangedMessagesStores() {
        ArrayList<MessagesStore> list = new ArrayList<MessagesStore>();
        for (LocaleStore localeStore : this.translationsMap.values()) {
            for (MessagesStore messagesStore : localeStore.getLocaleMap().values()) {
                if (!messagesStore.hasChanged()) continue;
                list.add(messagesStore);
            }
        }
        return list;
    }

    public List<MessagesStore> getMessagesStores(String searchLocale, String messagesPackage) {
        ArrayList<MessagesStore> list = new ArrayList<MessagesStore>();
        for (LocaleStore localeStore : this.translationsMap.values()) {
            for (MessagesStore messagesStore : localeStore.getLocaleMap().values()) {
                if (!messagesStore.getLocale().equals(searchLocale) || messagesPackage != null && !messagesStore.getMessagesPackage().equals(messagesPackage)) continue;
                list.add(messagesStore);
            }
        }
        return list;
    }

    public MessagesStore findMainLocaleMessagesStore(String messagesPackage) {
        LocaleStore localeStore = this.translationsMap.get(this.mainLocale);
        return localeStore.getLocaleMap().get(messagesPackage);
    }

    public Map<String, List<KeyOccurrence>> getPackageOccurrences() {
        return this.packageOccurrences;
    }

    public void setPackageOccurrences(Map<String, List<KeyOccurrence>> packageOccurrences) {
        this.packageOccurrences = packageOccurrences;
    }
}

