/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.imp;

import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.imp.rule.ImportRuleCompositeInterface;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.w3c.dom.Node;

public class ImportRulesDialog
extends Dialog
implements XulEventHandler {
    private static Class<?> PKG = ImportRulesDialog.class;
    private static final String XUL_FILE_TOOLBAR = "ui/import-rules-toolbar.xul";
    private Shell parentShell;
    private Display display;
    private Shell shell;
    private PropsUI props;
    private XulToolbar toolbar;
    private boolean ok;
    private ImportRules importRules;
    private Button wOK;
    private Button wExport;
    private Button wImport;
    private Button wCancel;
    private Table table;
    private List<ImportRuleCompositeInterface> compositesList;
    private ImportRules originalRules;

    public ImportRulesDialog(Shell parentShell, ImportRules importRules) {
        super(parentShell);
        this.parentShell = parentShell;
        this.originalRules = importRules;
        this.importRules = importRules.clone();
        this.props = PropsUI.getInstance();
        this.display = parentShell.getDisplay();
    }

    public boolean open() {
        this.shell = new Shell(this.parentShell, 3312);
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ImportRulesDialog.Shell.Title", (String[])new String[0]));
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportRulesDialog.this.ok();
            }
        });
        this.wImport = new Button((Composite)this.shell, 8);
        this.wImport.setText(BaseMessages.getString(PKG, (String)"ImportRulesDialog.Button.Import", (String[])new String[0]));
        this.wImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportRulesDialog.this.importRules();
            }
        });
        this.wExport = new Button((Composite)this.shell, 8);
        this.wExport.setText(BaseMessages.getString(PKG, (String)"ImportRulesDialog.Button.Export", (String[])new String[0]));
        this.wExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportRulesDialog.this.exportRules();
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportRulesDialog.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wImport, this.wExport, this.wCancel}, 4, null);
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        this.props.setLook(toolbarControl);
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fdToolbar = new FormData();
        fdToolbar.left = new FormAttachment(0, 0);
        fdToolbar.top = new FormAttachment(0, 0);
        fdToolbar.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fdToolbar);
        toolbarControl.setParent((Composite)this.shell);
        this.table = new Table((Composite)this.shell, 2850);
        this.props.setLook((Control)this.table);
        this.table.setHeaderVisible(true);
        TableColumn enabledColumn = new TableColumn(this.table, 0);
        enabledColumn.setText("On?");
        enabledColumn.setWidth(50);
        TableColumn descriptionColumn = new TableColumn(this.table, 0);
        descriptionColumn.setText("Rule description");
        descriptionColumn.setWidth(400);
        TableColumn compositeColumn = new TableColumn(this.table, 0);
        compositeColumn.setText("Settings");
        compositeColumn.setWidth(500);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment(toolbarControl, 4);
        fdTable.left = new FormAttachment(0, 0);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.bottom = new FormAttachment((Control)this.wOK, -8);
        this.table.setLayoutData((Object)fdTable);
        this.getCompositesData();
        this.table.layout(true, true);
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.ok;
    }

    private void addToolBar() {
        try {
            SwtXulLoader loader = new SwtXulLoader();
            loader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TOOLBAR, (Object)bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("import-rules-toolbar");
            ToolBar swtToolbar = (ToolBar)this.toolbar.getManagedObject();
            swtToolbar.layout(true, true);
        }
        catch (Throwable t) {
            LogChannel.GENERAL.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ImportRulesDialog.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ImportRulesDialog.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TOOLBAR}), new Exception(t));
        }
    }

    public void addRule() {
        PluginInterface plugin;
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(ImportRulePluginType.class);
        for (ImportRuleInterface rule : this.importRules.getRules()) {
            if (!rule.isUnique()) continue;
            int removeIndex = -1;
            for (int i = 0; i < plugins.size(); ++i) {
                plugin = (PluginInterface)plugins.get(i);
                if (Const.indexOfString((String)rule.getId(), (String[])plugin.getIds()) < 0) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex < 0) continue;
            plugins.remove(removeIndex);
        }
        if (plugins.size() > 0) {
            String[] names = new String[plugins.size()];
            for (int i = 0; i < plugins.size(); ++i) {
                names[i] = ((PluginInterface)plugins.get(i)).getName() + " : " + ((PluginInterface)plugins.get(i)).getDescription();
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, names, "Select a rule", "Select a new rule to add to the list:");
            String name = esd.open();
            if (name != null) {
                try {
                    int index = Const.indexOfString((String)name, (String[])names);
                    plugin = (PluginInterface)plugins.get(index);
                    ImportRuleInterface rule = (ImportRuleInterface)registry.loadClass(plugin);
                    rule.setEnabled(true);
                    rule.setId(plugin.getIds()[0]);
                    ImportRules newRules = new ImportRules();
                    this.getInfo(newRules);
                    newRules.getRules().add(rule);
                    this.importRules = newRules;
                    this.getCompositesData();
                }
                catch (Exception e) {
                    new ErrorDialog(this.shell, "Error", "Error loading rule class", e);
                }
            }
        }
    }

    public void removeRule() {
        MessageBox box = new MessageBox(this.shell, 65736);
        box.setText("Warning");
        box.setMessage("Are you sure you want to remove the selected rules from the list?");
        int answer = box.open();
        if (answer != 64) {
            return;
        }
        int[] indices = this.table.getSelectionIndices();
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.importRules.getRules().remove(indices[i]);
        }
        this.getCompositesData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportRules() {
        FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
        dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.XMLFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
        if (dialog.open() != null) {
            String filename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(filename);
                fileWriter.write(XMLHandler.getXMLHeader());
                fileWriter.write(this.importRules.getXML());
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "There was an error while exporting to file '" + filename + "'", e);
            }
            finally {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    new ErrorDialog(this.shell, "Error", "There was an error closing file '" + filename + "'", e);
                }
            }
        }
    }

    protected void importRules() {
        if (!this.importRules.getRules().isEmpty()) {
            MessageBox box = new MessageBox(this.shell, 65736);
            box.setText("Warning");
            box.setMessage("Are you sure you want to load a new set of rules, replacing the current list?");
            int answer = box.open();
            if (answer != 64) {
                return;
            }
        }
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
        dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.XMLFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
        if (dialog.open() != null) {
            String filename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
            ImportRules newRules = new ImportRules();
            try {
                newRules.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((String)filename), (String)"rules"));
                this.importRules = newRules;
                this.getCompositesData();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "There was an error during the import of the import rules file, verify the XML format.", e);
            }
        }
    }

    protected void dispose() {
        this.shell.dispose();
    }

    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    protected void ok() {
        this.ok = true;
        this.getInfo(this.originalRules);
        this.dispose();
    }

    protected void getInfo(ImportRules ir) {
        ir.getRules().clear();
        for (int i = 0; i < this.importRules.getRules().size(); ++i) {
            ImportRuleInterface rule = (ImportRuleInterface)this.importRules.getRules().get(i);
            ImportRuleCompositeInterface importRuleComposite = this.compositesList.get(i);
            TableItem tableItem = this.table.getItem(i);
            importRuleComposite.getCompositeData(rule);
            rule.setEnabled(tableItem.getChecked());
            ir.getRules().add(rule);
        }
    }

    protected void getCompositesData() {
        for (TableItem item : this.table.getItems()) {
            item.dispose();
        }
        this.table.clearAll();
        this.compositesList = new ArrayList<ImportRuleCompositeInterface>();
        for (ImportRuleInterface rule : this.importRules.getRules()) {
            try {
                TableItem item = new TableItem(this.table, 0);
                item.setChecked(rule.isEnabled());
                PluginRegistry registry = PluginRegistry.getInstance();
                PluginInterface plugin = registry.getPlugin(ImportRulePluginType.class, (Object)rule);
                item.setText(1, Const.NVL((String)plugin.getName(), (String)rule.getClass().getName()));
                ImportRuleCompositeInterface importRuleComposite = this.getImportRuleComposite(rule);
                this.compositesList.add(importRuleComposite);
                final Composite composite = importRuleComposite.getComposite((Composite)this.table, rule);
                composite.layout(true, true);
                TableEditor editor = new TableEditor(this.table);
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                editor.setEditor((Control)composite, item, 2);
                importRuleComposite.setCompositeData(rule);
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        composite.dispose();
                    }
                });
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error displaying rule options for rule: " + rule.toString(), e);
                this.compositesList.add(null);
            }
        }
    }

    public ImportRuleCompositeInterface getImportRuleComposite(ImportRuleInterface rule) throws KettleException {
        String compositeClassName = rule.getCompositeClassName();
        Class[] paramClasses = new Class[]{};
        Object[] paramArgs = new Object[]{};
        try {
            Class<?> compositeClass = rule.getClass().getClassLoader().loadClass(compositeClassName);
            Constructor<?> compositeConstructor = compositeClass.getConstructor(paramClasses);
            return (ImportRuleCompositeInterface)compositeConstructor.newInstance(paramArgs);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        Display display = new Display();
        KettleEnvironment.init();
        PropsUI.init(display, 1);
        Shell shell = new Shell(display);
        ImportRules importRules = new ImportRules();
        importRules.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((String)"bin/import-rules.xml"), (String)"rules"));
        ImportRulesDialog dialog = new ImportRulesDialog(shell, importRules);
        if (dialog.open()) {
            for (ImportRuleInterface rule : importRules.getRules()) {
                System.out.println(" - " + rule.toString());
            }
        }
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "importRules";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }
}

