/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.dialog;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobExecutionConfigurationDialog
extends Dialog {
    private static Class<?> PKG = JobExecutionConfigurationDialog.class;
    private Display display;
    private Shell parent;
    private Shell shell;
    private PropsUI props;
    private boolean retval;
    private Button wOK;
    private Button wCancel;
    private Group gLocal;
    private JobExecutionConfiguration configuration;
    private JobMeta jobMeta;
    private Button wExecLocal;
    private Button wExecRemote;
    private CCombo wRemoteHost;
    private Label wlRemoteHost;
    private Button wPassExport;
    private TableView wArguments;
    private Label wlArguments;
    private TableView wParams;
    private Label wlParams;
    private Label wlVariables;
    private TableView wVariables;
    private Group gDetails;
    private Label wlLogLevel;
    private CCombo wLogLevel;
    private Button wSafeMode;
    private Button wClearLog;
    private Label wlReplayDate;
    private Text wReplayDate;
    private CCombo wStartCopy;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public JobExecutionConfigurationDialog(Shell parent, JobExecutionConfiguration configuration, JobMeta jobMeta) {
        super(parent);
        String[] paramNames;
        this.parent = parent;
        this.configuration = configuration;
        this.jobMeta = jobMeta;
        Map params = configuration.getParams();
        params.clear();
        for (String name : paramNames = jobMeta.listParameters()) {
            params.put(name, "");
        }
        this.props = PropsUI.getInstance();
    }

    public boolean open() {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageJobGraph());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Shell.Title", (String[])new String[0]));
        int margin = 4;
        int tabsize = 5 * margin;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Button.Launch", (String[])new String[0]));
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.ok();
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
        this.gLocal = new Group((Composite)this.shell, 16);
        this.gLocal.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LocalGroup.Label", (String[])new String[0]));
        FormLayout localLayout = new FormLayout();
        localLayout.marginWidth = 5;
        localLayout.marginHeight = 5;
        this.gLocal.setLayout((Layout)localLayout);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0, 0);
        fdLocal.left = new FormAttachment(0, 0);
        fdLocal.right = new FormAttachment(100, 0);
        this.gLocal.setBackground(this.shell.getBackground());
        this.gLocal.setLayoutData((Object)fdLocal);
        this.wExecLocal = new Button((Composite)this.gLocal, 16);
        this.wExecLocal.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ExecLocal.Label", (String[])new String[0]));
        this.wExecLocal.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ExecLocal.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExecLocal);
        FormData fdExecLocal = new FormData();
        fdExecLocal.left = new FormAttachment(0, 0);
        fdExecLocal.right = new FormAttachment(33, 0);
        this.wExecLocal.setLayoutData((Object)fdExecLocal);
        this.wExecLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.enableFields();
            }
        });
        this.wExecRemote = new Button((Composite)this.gLocal, 16);
        this.wExecRemote.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ExecRemote.Label", (String[])new String[0]));
        this.wExecRemote.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ExecRemote.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExecRemote);
        FormData fdExecRemote = new FormData();
        fdExecRemote.left = new FormAttachment(33, margin);
        fdExecRemote.right = new FormAttachment(66, 0);
        this.wExecRemote.setLayoutData((Object)fdExecRemote);
        this.wExecRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.enableFields();
            }
        });
        this.wlRemoteHost = new Label((Composite)this.gLocal, 16384);
        this.props.setLook((Control)this.wlRemoteHost);
        this.wlRemoteHost.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.RemoteHost.Label", (String[])new String[0]));
        this.wlRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.RemoteHost.Tooltip", (String[])new String[0]));
        FormData fdlRemoteHost = new FormData();
        fdlRemoteHost.left = new FormAttachment(33, tabsize);
        fdlRemoteHost.top = new FormAttachment((Control)this.wExecRemote, margin * 2);
        this.wlRemoteHost.setLayoutData((Object)fdlRemoteHost);
        this.wRemoteHost = new CCombo((Composite)this.gLocal, 2056);
        this.wRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.RemoteHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRemoteHost);
        FormData fdRemoteHost = new FormData();
        fdRemoteHost.left = new FormAttachment((Control)this.wlRemoteHost, margin);
        fdRemoteHost.right = new FormAttachment(66, 0);
        fdRemoteHost.top = new FormAttachment((Control)this.wExecRemote, margin * 2);
        this.wRemoteHost.setLayoutData((Object)fdRemoteHost);
        for (int i = 0; i < this.jobMeta.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)this.jobMeta.getSlaveServers().get(i);
            this.wRemoteHost.add(slaveServer.toString());
        }
        this.wPassExport = new Button((Composite)this.gLocal, 32);
        this.wPassExport.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.PassExport.Label", (String[])new String[0]));
        this.wPassExport.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.PassExport.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassExport);
        FormData fdPassExport = new FormData();
        fdPassExport.left = new FormAttachment(33, margin);
        fdPassExport.top = new FormAttachment((Control)this.wRemoteHost, margin);
        this.wPassExport.setLayoutData((Object)fdPassExport);
        this.gDetails = new Group((Composite)this.shell, 16);
        this.gDetails.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.DetailsGroup.Label", (String[])new String[0]));
        FormLayout detailsLayout = new FormLayout();
        detailsLayout.marginWidth = 5;
        detailsLayout.marginHeight = 5;
        this.gDetails.setLayout((Layout)detailsLayout);
        FormData fdDetails = new FormData();
        fdDetails.left = new FormAttachment(0, 0);
        fdDetails.top = new FormAttachment((Control)this.gLocal, margin * 2);
        fdDetails.right = new FormAttachment(100, 0);
        this.gDetails.setBackground(this.shell.getBackground());
        this.gDetails.setLayoutData((Object)fdDetails);
        this.wSafeMode = new Button((Composite)this.gDetails, 32);
        this.wSafeMode.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.SafeMode.Label", (String[])new String[0]));
        this.wSafeMode.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.SafeMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSafeMode);
        FormData fdSafeMode = new FormData();
        fdSafeMode.left = new FormAttachment(50, margin);
        fdSafeMode.right = new FormAttachment(100, 0);
        fdSafeMode.top = new FormAttachment(0, 0);
        this.wSafeMode.setLayoutData((Object)fdSafeMode);
        this.wSafeMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.enableFields();
            }
        });
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.left = new FormAttachment(50, margin);
        fdClearLog.right = new FormAttachment(100, 0);
        fdClearLog.top = new FormAttachment((Control)this.wSafeMode, margin);
        this.wClearLog.setLayoutData((Object)fdClearLog);
        this.wClearLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobExecutionConfigurationDialog.this.enableFields();
            }
        });
        this.wlLogLevel = new Label((Composite)this.gDetails, 16384);
        this.props.setLook((Control)this.wlLogLevel);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.left = new FormAttachment(0, 0);
        fdlLogLevel.right = new FormAttachment(50, 0);
        fdlLogLevel.top = new FormAttachment((Control)this.wClearLog, margin);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.left = new FormAttachment(50, margin);
        fdLogLevel.right = new FormAttachment(100, 0);
        fdLogLevel.top = new FormAttachment((Control)this.wClearLog, margin);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        this.wlReplayDate = new Label((Composite)this.gDetails, 16384);
        this.props.setLook((Control)this.wlReplayDate);
        this.wlReplayDate.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ReplayDate.Label", (String[])new String[0]));
        this.wlReplayDate.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ReplayDate.Tooltip", (String[])new String[0]));
        FormData fdlReplayDate = new FormData();
        fdlReplayDate.left = new FormAttachment(0, 0);
        fdlReplayDate.right = new FormAttachment(50, 0);
        fdlReplayDate.top = new FormAttachment((Control)this.wLogLevel, margin);
        this.wlReplayDate.setLayoutData((Object)fdlReplayDate);
        this.wReplayDate = new Text((Composite)this.gDetails, 18436);
        this.props.setLook((Control)this.wReplayDate);
        this.wReplayDate.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ReplayDate.Tooltip", (String[])new String[0]));
        FormData fdReplayDate = new FormData();
        fdReplayDate.left = new FormAttachment(50, margin);
        fdReplayDate.right = new FormAttachment(100, 0);
        fdReplayDate.top = new FormAttachment((Control)this.wLogLevel, margin);
        this.wReplayDate.setLayoutData((Object)fdReplayDate);
        Label wlStartCopy = new Label((Composite)this.gDetails, 16384);
        this.props.setLook((Control)wlStartCopy);
        wlStartCopy.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Label", (String[])new String[0]));
        wlStartCopy.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        FormData fdlStartCopy = new FormData();
        fdlStartCopy.left = new FormAttachment(0, 0);
        fdlStartCopy.right = new FormAttachment(50, 0);
        fdlStartCopy.top = new FormAttachment((Control)this.wReplayDate, margin);
        wlStartCopy.setLayoutData((Object)fdlStartCopy);
        this.wStartCopy = new CCombo((Composite)this.gDetails, 2056);
        this.wStartCopy.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wStartCopy);
        FormData fdStartCopy = new FormData();
        fdStartCopy.left = new FormAttachment(50, margin);
        fdStartCopy.right = new FormAttachment(100, 0);
        fdStartCopy.top = new FormAttachment((Control)this.wReplayDate, margin);
        this.wStartCopy.setLayoutData((Object)fdStartCopy);
        String[] names = new String[this.jobMeta.getJobCopies().size()];
        for (int i = 0; i < names.length; ++i) {
            JobEntryCopy copy = (JobEntryCopy)this.jobMeta.getJobCopies().get(i);
            names[i] = this.getJobEntryCopyName(copy);
        }
        this.wStartCopy.setItems(names);
        this.wlVariables = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlVariables);
        this.wlVariables.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Variables.Label", (String[])new String[0]));
        this.wlVariables.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Variables.Tooltip", (String[])new String[0]));
        FormData fdlVariables = new FormData();
        fdlVariables.left = new FormAttachment(50, margin);
        fdlVariables.right = new FormAttachment(100, 0);
        fdlVariables.top = new FormAttachment((Control)this.gDetails, margin * 2);
        this.wlVariables.setLayoutData((Object)fdlVariables);
        ColumnInfo[] cVariables = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.VariablesColumn.Argument", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.VariablesColumn.Value", (String[])new String[0]), 1, false, false)};
        int nrVariables = this.configuration.getVariables() != null ? this.configuration.getVariables().size() : 0;
        this.wVariables = new TableView((VariableSpace)this.jobMeta, (Composite)this.shell, 67586, cVariables, nrVariables, false, null, this.props);
        FormData fdVariables = new FormData();
        fdVariables.left = new FormAttachment(50, margin);
        fdVariables.right = new FormAttachment(100, 0);
        fdVariables.top = new FormAttachment((Control)this.wlVariables, margin);
        fdVariables.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        this.wVariables.setLayoutData(fdVariables);
        this.wlParams = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlParams);
        this.wlParams.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Params.Label", (String[])new String[0]));
        this.wlParams.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Params.Tooltip", (String[])new String[0]));
        FormData fdlParams = new FormData();
        fdlParams.left = new FormAttachment(0, 0);
        fdlParams.right = new FormAttachment(50, -margin);
        fdlParams.top = new FormAttachment((Control)this.gDetails, margin * 2);
        this.wlParams.setLayoutData((Object)fdlParams);
        ColumnInfo[] cParams = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ParamsColumn.Argument", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ParamsColumn.Value", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ParamsColumn.Default", (String[])new String[0]), 1, false, true)};
        String[] namedParams = this.jobMeta.listParameters();
        int nrParams = namedParams.length;
        this.wParams = new TableView((VariableSpace)this.jobMeta, (Composite)this.shell, 67586, cParams, nrParams, true, null, this.props);
        FormData fdParams = new FormData();
        fdParams.left = new FormAttachment(0, 0);
        fdParams.right = new FormAttachment(50, -margin);
        fdParams.top = new FormAttachment((Control)this.wlParams, margin);
        fdParams.bottom = new FormAttachment((Control)this.wlParams, 150);
        this.wParams.setLayoutData(fdParams);
        this.wlArguments = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlArguments);
        this.wlArguments.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Arguments.Label", (String[])new String[0]));
        this.wlArguments.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.Arguments.Tooltip", (String[])new String[0]));
        FormData fdlArguments = new FormData();
        fdlArguments.left = new FormAttachment(0, 0);
        fdlArguments.right = new FormAttachment(50, -margin);
        fdlArguments.top = new FormAttachment((Control)this.wParams, 2 * margin);
        this.wlArguments.setLayoutData((Object)fdlArguments);
        ColumnInfo[] cArguments = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ArgumentsColumn.Argument", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ArgumentsColumn.Value", (String[])new String[0]), 1, false, false)};
        int nrArguments = this.configuration.getArguments() != null ? this.configuration.getArguments().size() : 10;
        this.wArguments = new TableView((VariableSpace)this.jobMeta, (Composite)this.shell, 67586, cArguments, nrArguments, false, null, this.props);
        FormData fdArguments = new FormData();
        fdArguments.left = new FormAttachment(0, 0);
        fdArguments.right = new FormAttachment(50, -margin);
        fdArguments.top = new FormAttachment((Control)this.wlArguments, margin);
        fdArguments.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        this.wArguments.setLayoutData(fdArguments);
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.wOK.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.retval;
    }

    private String getJobEntryCopyName(JobEntryCopy copy) {
        return copy.getName() + (copy.getNr() > 0 ? Integer.valueOf(copy.getNr()) : "");
    }

    private void getParamsData() {
        this.wParams.clearAll(false);
        ArrayList paramNames = new ArrayList(this.configuration.getParams().keySet());
        Collections.sort(paramNames);
        for (int i = 0; i < paramNames.size(); ++i) {
            String defaultValue;
            String paramName = (String)paramNames.get(i);
            String paramValue = (String)this.configuration.getParams().get(paramName);
            try {
                defaultValue = this.jobMeta.getParameterDefault(paramName);
            }
            catch (UnknownParamException e) {
                defaultValue = "";
            }
            TableItem tableItem = new TableItem(this.wParams.table, 0);
            tableItem.setText(1, paramName);
            tableItem.setText(2, Const.NVL((String)paramValue, (String)""));
            tableItem.setText(3, Const.NVL((String)defaultValue, (String)""));
        }
        this.wParams.removeEmptyRows();
        this.wParams.setRowNums();
        this.wParams.optWidth(true);
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariables().keySet());
        Collections.sort(variableNames);
        ArrayList paramNames = new ArrayList(this.configuration.getParams().keySet());
        for (int i = 0; i < variableNames.size(); ++i) {
            String variableName = (String)variableNames.get(i);
            String variableValue = (String)this.configuration.getVariables().get(variableName);
            if (paramNames.contains(variableName)) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    private void getArgumentsData() {
        this.wArguments.clearAll(false);
        ArrayList argumentNames = new ArrayList(this.configuration.getArguments().keySet());
        Collections.sort(argumentNames);
        for (int i = 0; i < 10; ++i) {
            String argumentName = new DecimalFormat("00").format(i + 1);
            String argumentValue = (String)this.configuration.getArguments().get(argumentName);
            TableItem tableItem = new TableItem(this.wArguments.table, 0);
            tableItem.setText(1, Const.NVL((String)argumentName, (String)""));
            tableItem.setText(2, Const.NVL((String)argumentValue, (String)""));
        }
        this.wArguments.removeEmptyRows();
        this.wArguments.setRowNums();
        this.wArguments.optWidth(true);
    }

    private void cancel() {
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void ok() {
        if (Const.isOSX()) {
            this.wParams.applyOSXChanges();
            this.wVariables.applyOSXChanges();
            this.wArguments.applyOSXChanges();
        }
        this.getInfo();
        this.retval = true;
        this.dispose();
    }

    public void getData() {
        JobEntryCopy copy;
        this.wExecLocal.setSelection(this.configuration.isExecutingLocally());
        this.wExecRemote.setSelection(this.configuration.isExecutingRemotely());
        this.wSafeMode.setSelection(this.configuration.isSafeModeEnabled());
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        this.wRemoteHost.setText(this.configuration.getRemoteServer() == null ? "" : this.configuration.getRemoteServer().toString());
        this.wPassExport.setSelection(this.configuration.isPassingExport());
        this.wLogLevel.select(DefaultLogLevel.getLogLevel().getLevel());
        if (this.configuration.getReplayDate() != null) {
            this.wReplayDate.setText(this.simpleDateFormat.format(this.configuration.getReplayDate()));
        }
        String startCopy = "";
        if (!Const.isEmpty((String)this.configuration.getStartCopyName()) && (copy = this.jobMeta.findJobEntry(this.configuration.getStartCopyName(), this.configuration.getStartCopyNr(), false)) != null) {
            startCopy = this.getJobEntryCopyName(copy);
        }
        this.wStartCopy.setText(startCopy);
        this.getParamsData();
        this.getArgumentsData();
        this.getVariablesData();
        this.enableFields();
    }

    public void getInfo() {
        try {
            this.configuration.setExecutingLocally(this.wExecLocal.getSelection());
            this.configuration.setExecutingRemotely(this.wExecRemote.getSelection());
            if (this.wExecRemote.getSelection()) {
                String serverName = this.wRemoteHost.getText();
                this.configuration.setRemoteServer(this.jobMeta.findSlaveServer(serverName));
            }
            this.configuration.setPassingExport(this.wPassExport.getSelection());
            if (!Const.isEmpty((String)this.wReplayDate.getText())) {
                this.configuration.setReplayDate(this.simpleDateFormat.parse(this.wReplayDate.getText()));
            } else {
                this.configuration.setReplayDate(null);
            }
            this.configuration.setSafeModeEnabled(this.wSafeMode.getSelection());
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            String startCopyName = null;
            int startCopyNr = 0;
            if (!Const.isEmpty((String)this.wStartCopy.getText()) && this.wStartCopy.getSelectionIndex() >= 0) {
                JobEntryCopy copy = (JobEntryCopy)this.jobMeta.getJobCopies().get(this.wStartCopy.getSelectionIndex());
                startCopyName = copy.getName();
                startCopyNr = copy.getNr();
            }
            this.configuration.setStartCopyName(startCopyName);
            this.configuration.setStartCopyNr(startCopyNr);
            this.getInfoParameters();
            this.getInfoVariables();
            this.getInfoArguments();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error in settings", "There is an error in the dialog settings", e);
        }
    }

    private void getInfoParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wParams.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wParams.getNonEmpty(i);
            String paramName = tableItem.getText(1);
            String paramValue = tableItem.getText(2);
            String defaultValue = tableItem.getText(3);
            if (Const.isEmpty((String)paramValue)) {
                paramValue = Const.NVL((String)defaultValue, (String)"");
            }
            map.put(paramName, paramValue);
        }
        this.configuration.setParams(map);
    }

    private void getInfoVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wVariables.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wVariables.getNonEmpty(i);
            String varName = tableItem.getText(1);
            String varValue = tableItem.getText(2);
            if (Const.isEmpty((String)varName)) continue;
            map.put(varName, varValue);
        }
        this.configuration.setVariables(map);
    }

    private void getInfoArguments() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyArguments = this.wArguments.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyArguments; ++i) {
            TableItem tableItem = this.wArguments.getNonEmpty(i);
            String varName = tableItem.getText(1);
            String varValue = tableItem.getText(2);
            if (Const.isEmpty((String)varName)) continue;
            map.put(varName, varValue);
        }
        this.configuration.setArguments(map);
    }

    private void enableFields() {
        boolean enableRemote = this.wExecRemote.getSelection();
        this.wRemoteHost.setEnabled(enableRemote);
        this.wlRemoteHost.setEnabled(enableRemote);
        this.wPassExport.setEnabled(enableRemote);
    }

    public JobExecutionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JobExecutionConfiguration configuration) {
        this.configuration = configuration;
    }
}

