/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.delay;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.delay.JobEntryDelay;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryDelayDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryDelay.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private CCombo wScaleTime;
    private FormData fdScaleTime;
    private LabelTextVar wMaximumTimeout;
    private FormData fdMaximumTimeout;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryDelay jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;

    public JobEntryDelayDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryDelay)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEntryDelay.Title", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryDelayDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntryDelay.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobEntryDelay.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, -margin);
        this.fdlName.right = new FormAttachment(middle, 0);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, margin);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wMaximumTimeout = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"JobEntryDelay.MaximumTimeout.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryDelay.MaximumTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wMaximumTimeout);
        this.wMaximumTimeout.addModifyListener(lsMod);
        this.fdMaximumTimeout = new FormData();
        this.fdMaximumTimeout.left = new FormAttachment(0, -margin);
        this.fdMaximumTimeout.top = new FormAttachment((Control)this.wName, margin);
        this.fdMaximumTimeout.right = new FormAttachment(100, 0);
        this.wMaximumTimeout.setLayoutData(this.fdMaximumTimeout);
        this.wMaximumTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryDelayDialog.this.wMaximumTimeout.setToolTipText(JobEntryDelayDialog.this.jobMeta.environmentSubstitute(JobEntryDelayDialog.this.wMaximumTimeout.getText()));
            }
        });
        this.wScaleTime = new CCombo((Composite)this.shell, 2060);
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"JobEntryDelay.SScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"JobEntryDelay.MnScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.add(BaseMessages.getString(PKG, (String)"JobEntryDelay.HrScaleTime.Label", (String[])new String[0]));
        this.wScaleTime.select(0);
        this.props.setLook((Control)this.wScaleTime);
        this.fdScaleTime = new FormData();
        this.fdScaleTime.left = new FormAttachment(middle, 0);
        this.fdScaleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        this.fdScaleTime.right = new FormAttachment(100, 0);
        this.wScaleTime.setLayoutData((Object)this.fdScaleTime);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wScaleTime);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryDelayDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryDelayDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryDelayDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wMaximumTimeout.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryDelayDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wName.selectAll();
        if (this.jobEntry.getMaximumTimeout() != null) {
            this.wMaximumTimeout.setText(this.jobEntry.getMaximumTimeout());
        }
        this.wScaleTime.select(this.jobEntry.scaleTime);
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setMaximumTimeout(this.wMaximumTimeout.getText());
        this.jobEntry.scaleTime = this.wScaleTime.getSelectionIndex();
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

