/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.eval;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.eval.JobEntryEval;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryEvalDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryEval.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlScript;
    private StyledTextComp wScript;
    private FormData fdlScript;
    private FormData fdScript;
    private Label wlPosition;
    private FormData fdlPosition;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryEval jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;

    public JobEntryEvalDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryEval)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEval.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryEvalDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEval.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wlName = new Label((Composite)this.shell, 0);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobEval.Jobname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"JobEval.LineNr.Label", (String[])new String[]{"0"}));
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wlScript = new Label((Composite)this.shell, 0);
        this.wlScript.setText(BaseMessages.getString(PKG, (String)"JobEval.Script.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlScript);
        this.fdlScript = new FormData();
        this.fdlScript.left = new FormAttachment(0, 0);
        this.fdlScript.top = new FormAttachment((Control)this.wName, margin);
        this.wlScript.setLayoutData((Object)this.fdlScript);
        this.wScript = new StyledTextComp((VariableSpace)this.jobEntry, (Composite)this.shell, 19202, "");
        this.wScript.setText(BaseMessages.getString(PKG, (String)"JobEval.Script.Default", (String[])new String[0]));
        this.props.setLook((Control)this.wScript, 1);
        this.wScript.addModifyListener(lsMod);
        this.fdScript = new FormData();
        this.fdScript.left = new FormAttachment(0, 0);
        this.fdScript.top = new FormAttachment((Control)this.wlScript, margin);
        this.fdScript.right = new FormAttachment(100, -10);
        this.fdScript.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wScript.setLayoutData(this.fdScript);
        this.wScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JobEntryEvalDialog.this.setPosition();
            }
        });
        this.wScript.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }
        });
        this.wScript.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }
        });
        this.wScript.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                JobEntryEvalDialog.this.setPosition();
            }
        });
        this.wScript.addModifyListener(lsMod);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryEvalDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryEvalDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryEvalDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryEvalDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell, 250, 250, false);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobEvalDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void setPosition() {
        String scr = this.wScript.getText();
        int linenr = this.wScript.getLineAtOffset(this.wScript.getCaretOffset()) + 1;
        int posnr = this.wScript.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"JobEval.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wName.selectAll();
        if (this.jobEntry.getScript() != null) {
            this.wScript.setText(this.jobEntry.getScript());
        }
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setScript(this.wScript.getText());
        this.dispose();
    }
}

