/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.sql;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sql.JobEntrySQL;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class JobEntrySQLDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySQL.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobSQL.Filetype.Sql", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSQL.Filetype.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSQL.Filetype.All", (String[])new String[0])};
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private CCombo wConnection;
    private Label wlUseSubs;
    private Button wUseSubs;
    private Button wSQLFromFile;
    private Label wlSQLFromFile;
    private FormData fdlUseSubs;
    private FormData fdUseSubs;
    private FormData fdlSQLFromFile;
    private FormData fdSQLFromFile;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlPosition;
    private FormData fdlPosition;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntrySQL jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Label wlUseOneStatement;
    private Button wSendOneStatement;
    private FormData fdlUseOneStatement;
    private FormData fdUseOneStatement;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;

    public JobEntrySQLDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySQL)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobSQL.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySQLDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobSQL.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobSQL.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, 0);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, middle, margin);
        if (this.jobEntry.getDatabase() == null && this.jobMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSQLFromFile = new Label((Composite)this.shell, 131072);
        this.wlSQLFromFile.setText(BaseMessages.getString(PKG, (String)"JobSQL.SQLFromFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQLFromFile);
        this.fdlSQLFromFile = new FormData();
        this.fdlSQLFromFile.left = new FormAttachment(0, 0);
        this.fdlSQLFromFile.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdlSQLFromFile.right = new FormAttachment(middle, -margin);
        this.wlSQLFromFile.setLayoutData((Object)this.fdlSQLFromFile);
        this.wSQLFromFile = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSQLFromFile);
        this.wSQLFromFile.setToolTipText(BaseMessages.getString(PKG, (String)"JobSQL.SQLFromFile.Tooltip", (String[])new String[0]));
        this.fdSQLFromFile = new FormData();
        this.fdSQLFromFile.left = new FormAttachment(middle, 0);
        this.fdSQLFromFile.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdSQLFromFile.right = new FormAttachment(100, 0);
        this.wSQLFromFile.setLayoutData((Object)this.fdSQLFromFile);
        this.wSQLFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySQLDialog.this.activeSQLFromFile();
                JobEntrySQLDialog.this.jobEntry.setChanged();
            }
        });
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"JobSQL.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wSQLFromFile, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wSQLFromFile, margin);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.setToolTipText(BaseMessages.getString(PKG, (String)"JobSQL.Filename.Tooltip", (String[])new String[0]));
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment((Control)this.wSQLFromFile, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySQLDialog.this.wFilename.setToolTipText(JobEntrySQLDialog.this.jobMeta.environmentSubstitute(JobEntrySQLDialog.this.wFilename.getText()));
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JobEntrySQLDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.sql", "*.txt", "*"});
                if (JobEntrySQLDialog.this.wFilename.getText() != null) {
                    dialog.setFileName(JobEntrySQLDialog.this.jobMeta.environmentSubstitute(JobEntrySQLDialog.this.wFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES);
                if (dialog.open() != null) {
                    JobEntrySQLDialog.this.wFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wlUseOneStatement = new Label((Composite)this.shell, 131072);
        this.wlUseOneStatement.setText(BaseMessages.getString(PKG, (String)"JobSQL.SendOneStatement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseOneStatement);
        this.fdlUseOneStatement = new FormData();
        this.fdlUseOneStatement.left = new FormAttachment(0, 0);
        this.fdlUseOneStatement.top = new FormAttachment((Control)this.wbFilename, margin);
        this.fdlUseOneStatement.right = new FormAttachment(middle, -margin);
        this.wlUseOneStatement.setLayoutData((Object)this.fdlUseOneStatement);
        this.wSendOneStatement = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSendOneStatement);
        this.wSendOneStatement.setToolTipText(BaseMessages.getString(PKG, (String)"JobSQL.SendOneStatement.Tooltip", (String[])new String[0]));
        this.fdUseOneStatement = new FormData();
        this.fdUseOneStatement.left = new FormAttachment(middle, 0);
        this.fdUseOneStatement.top = new FormAttachment((Control)this.wbFilename, margin);
        this.fdUseOneStatement.right = new FormAttachment(100, 0);
        this.wSendOneStatement.setLayoutData((Object)this.fdUseOneStatement);
        this.wSendOneStatement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySQLDialog.this.jobEntry.setChanged();
            }
        });
        this.wlUseSubs = new Label((Composite)this.shell, 131072);
        this.wlUseSubs.setText(BaseMessages.getString(PKG, (String)"JobSQL.UseVariableSubst.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseSubs);
        this.fdlUseSubs = new FormData();
        this.fdlUseSubs.left = new FormAttachment(0, 0);
        this.fdlUseSubs.top = new FormAttachment((Control)this.wSendOneStatement, margin);
        this.fdlUseSubs.right = new FormAttachment(middle, -margin);
        this.wlUseSubs.setLayoutData((Object)this.fdlUseSubs);
        this.wUseSubs = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wUseSubs);
        this.wUseSubs.setToolTipText(BaseMessages.getString(PKG, (String)"JobSQL.UseVariableSubst.Tooltip", (String[])new String[0]));
        this.fdUseSubs = new FormData();
        this.fdUseSubs.left = new FormAttachment(middle, 0);
        this.fdUseSubs.top = new FormAttachment((Control)this.wSendOneStatement, margin);
        this.fdUseSubs.right = new FormAttachment(100, 0);
        this.wUseSubs.setLayoutData((Object)this.fdUseSubs);
        this.wUseSubs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySQLDialog.this.jobEntry.setUseVariableSubstitution(!JobEntrySQLDialog.this.jobEntry.getUseVariableSubstitution());
                JobEntrySQLDialog.this.jobEntry.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"JobSQL.LineNr.Label", (String[])new String[]{"0"}));
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wlSQL = new Label((Composite)this.shell, 0);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"JobSQL.Script.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wUseSubs, margin);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wSQL = new StyledTextComp((VariableSpace)this.jobEntry, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.wSQL.addModifyListener(lsMod);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wlSQL, margin);
        this.fdSQL.right = new FormAttachment(100, -10);
        this.fdSQL.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSQL.setLayoutData(this.fdSQL);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySQLDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySQLDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntrySQLDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySQLDialog.this.cancel();
            }
        });
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JobEntrySQLDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                JobEntrySQLDialog.this.setPosition();
            }
        });
        this.wSQL.addModifyListener(lsMod);
        this.wSQL.addLineStyleListener(new SQLValuesHighlight());
        this.getData();
        this.activeSQLFromFile();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSQLDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"JobSQL.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        DatabaseMeta dbinfo;
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        if (this.jobEntry.getSQL() != null) {
            this.wSQL.setText(this.jobEntry.getSQL());
        }
        if ((dbinfo = this.jobEntry.getDatabase()) != null && dbinfo.getName() != null) {
            this.wConnection.setText(dbinfo.getName());
        } else {
            this.wConnection.setText("");
        }
        this.wUseSubs.setSelection(this.jobEntry.getUseVariableSubstitution());
        this.wSQLFromFile.setSelection(this.jobEntry.getSQLFromFile());
        this.wSendOneStatement.setSelection(this.jobEntry.isSendOneStatement());
        if (this.jobEntry.getSQLFilename() != null) {
            this.wFilename.setText(this.jobEntry.getSQLFilename());
        }
        this.wName.selectAll();
    }

    private void activeSQLFromFile() {
        this.wlFilename.setEnabled(this.wSQLFromFile.getSelection());
        this.wFilename.setEnabled(this.wSQLFromFile.getSelection());
        this.wbFilename.setEnabled(this.wSQLFromFile.getSelection());
        this.wSQL.setEnabled(!this.wSQLFromFile.getSelection());
        this.wlSQL.setEnabled(!this.wSQLFromFile.getSelection());
        this.wlPosition.setEnabled(!this.wSQLFromFile.getSelection());
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setSQL(this.wSQL.getText());
        this.jobEntry.setUseVariableSubstitution(this.wUseSubs.getSelection());
        this.jobEntry.setSQLFromFile(this.wSQLFromFile.getSelection());
        this.jobEntry.setSQLFilename(this.wFilename.getText());
        this.jobEntry.setSendOneStatement(this.wSendOneStatement.getSelection());
        this.jobEntry.setDatabase(this.jobMeta.findDatabase(this.wConnection.getText()));
        this.dispose();
    }
}

