/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entry;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;

public class JobEntryDialog
extends Dialog {
    private static Class<?> PKG = StepInterface.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Job entry dialog", LoggingObjectType.JOBENTRYDIALOG, null);
    protected JobEntryInterface jobEntryInt;
    protected Repository rep;
    protected JobMeta jobMeta;
    protected Shell shell;
    protected PropsUI props = PropsUI.getInstance();
    protected Shell parent;
    protected DatabaseDialog databaseDialog;

    public JobEntryDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) {
        super(parent, 0);
        this.jobEntryInt = jobEntry;
        this.rep = rep;
        this.jobMeta = jobMeta;
        this.shell = parent;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin) {
        return this.addConnectionLine(parent, previous, middle, margin, new Label(parent, 131072), new Button(parent, 8), new Button(parent, 8));
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin, Label wlConnection, Button wbnConnection, Button wbeConnection) {
        final CCombo wConnection = new CCombo(parent, 2056);
        this.props.setLook((Control)wConnection);
        this.addDatabases(wConnection);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.Connection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnection);
        FormData fdlConnection = new FormData();
        fdlConnection.left = new FormAttachment(0, 0);
        fdlConnection.right = new FormAttachment(middle, -margin);
        fdlConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wlConnection.setLayoutData((Object)fdlConnection);
        wbnConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.NewConnectionButton.Label", (String[])new String[0]));
        wbnConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                databaseMeta.shareVariablesWith((VariableSpace)JobEntryDialog.this.jobMeta);
                JobEntryDialog.this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                if (JobEntryDialog.this.getDatabaseDialog().open() != null) {
                    JobEntryDialog.this.jobMeta.addDatabase(JobEntryDialog.this.getDatabaseDialog().getDatabaseMeta());
                    wConnection.removeAll();
                    JobEntryDialog.this.addDatabases(wConnection);
                    JobEntryDialog.this.selectDatabase(wConnection, JobEntryDialog.this.getDatabaseDialog().getDatabaseMeta().getName());
                }
            }
        });
        FormData fdbConnection = new FormData();
        fdbConnection.right = new FormAttachment(100, 0);
        fdbConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbnConnection.setLayoutData((Object)fdbConnection);
        wbeConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.EditConnectionButton.Label", (String[])new String[0]));
        wbeConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = JobEntryDialog.this.jobMeta.findDatabase(wConnection.getText());
                if (databaseMeta != null) {
                    databaseMeta.shareVariablesWith((VariableSpace)JobEntryDialog.this.jobMeta);
                    JobEntryDialog.this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                    if (JobEntryDialog.this.getDatabaseDialog().open() != null) {
                        wConnection.removeAll();
                        JobEntryDialog.this.addDatabases(wConnection);
                        JobEntryDialog.this.selectDatabase(wConnection, databaseMeta.getName());
                    }
                }
            }
        });
        FormData fdeConnection = new FormData();
        fdeConnection.right = new FormAttachment((Control)wbnConnection, -margin);
        fdeConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbeConnection.setLayoutData((Object)fdeConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(middle, 0);
        fdConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment((Control)wbeConnection, -margin);
        wConnection.setLayoutData((Object)fdConnection);
        return wConnection;
    }

    public void addDatabases(CCombo wConnection) {
        for (int i = 0; i < this.jobMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.jobMeta.getDatabase(i);
            wConnection.add(ci.getName());
        }
    }

    public void selectDatabase(CCombo wConnection, String name) {
        int idx = wConnection.indexOf(name);
        if (idx >= 0) {
            wConnection.select(idx);
        }
    }
}

