/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.controllers;

import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repository.ILoginCallback;
import org.pentaho.di.ui.repository.RepositoriesHelper;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.repository.model.RepositoriesModel;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.WaitBoxRunnable;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.components.XulWaitBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class RepositoriesController
extends AbstractXulEventHandler {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private ResourceBundle messages;
    private BindingFactory bf;
    private XulDialog loginDialog;
    private XulTextbox username;
    private XulTextbox userPassword;
    private XulListbox availableRepositories;
    private XulButton repositoryEditButton;
    private XulButton repositoryRemoveButton;
    private XulCheckbox showAtStartup;
    private RepositoriesModel loginModel = new RepositoriesModel();
    private XulButton okButton;
    private XulButton cancelButton;
    private XulMessageBox messageBox;
    protected XulConfirmBox confirmBox;
    private RepositoriesHelper helper;
    private String preferredRepositoryName;
    private ILoginCallback callback;
    private Shell shell;

    public void init() throws ControllerInitializationException {
        try {
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
            this.confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
        }
        catch (Exception e) {
            throw new ControllerInitializationException(e);
        }
        if (this.bf != null) {
            this.createBindings();
        }
    }

    private void createBindings() {
        this.loginDialog = (XulDialog)this.document.getElementById("repository-login-dialog");
        this.repositoryEditButton = (XulButton)this.document.getElementById("repository-edit");
        this.repositoryRemoveButton = (XulButton)this.document.getElementById("repository-remove");
        this.username = (XulTextbox)this.document.getElementById("user-name");
        this.userPassword = (XulTextbox)this.document.getElementById("user-password");
        this.availableRepositories = (XulListbox)this.document.getElementById("available-repository-list");
        this.showAtStartup = (XulCheckbox)this.document.getElementById("show-login-dialog-at-startup");
        this.okButton = (XulButton)this.document.getElementById("repository-login-dialog_accept");
        this.cancelButton = (XulButton)this.document.getElementById("repository-login-dialog_cancel");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.loginModel, "username", (Object)this.username, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.loginModel, "password", (Object)this.userPassword, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.loginModel, "availableRepositories", (Object)this.availableRepositories, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.loginModel, "selectedRepository", (Object)this.availableRepositories, "selectedItem", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.loginModel, "showDialogAtStartup", (Object)this.showAtStartup, "checked", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.loginModel, "valid", (Object)this.okButton, "!disabled", new BindingConvertor[0]);
        BindingConvertor<RepositoryMeta, Boolean> buttonConverter = new BindingConvertor<RepositoryMeta, Boolean>(){

            public Boolean sourceToTarget(RepositoryMeta value) {
                return value == null;
            }

            public RepositoryMeta targetToSource(Boolean value) {
                return null;
            }
        };
        BindingConvertor<RepositoryMeta, Boolean> userpassConverter = new BindingConvertor<RepositoryMeta, Boolean>(){

            public Boolean sourceToTarget(RepositoryMeta value) {
                return value == null || !value.getRepositoryCapabilities().supportsUsers();
            }

            public RepositoryMeta targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.createBinding((Object)this.loginModel, "selectedRepository", (Object)this.username, "disabled", new BindingConvertor[]{userpassConverter});
        this.bf.createBinding((Object)this.loginModel, "selectedRepository", (Object)this.userPassword, "disabled", new BindingConvertor[]{userpassConverter});
        this.bf.createBinding((Object)this.loginModel, "selectedRepository", (Object)this.repositoryEditButton, "disabled", new BindingConvertor[]{buttonConverter});
        this.bf.createBinding((Object)this.loginModel, "selectedRepository", (Object)this.repositoryRemoveButton, "disabled", new BindingConvertor[]{buttonConverter});
        Shell loginShell = (Shell)this.loginDialog.getRootObject();
        this.helper = new RepositoriesHelper(this.loginModel, this.document, loginShell);
        this.helper.setPreferredRepositoryName(this.preferredRepositoryName);
        this.helper.getMetaData();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public String getName() {
        return "repositoryLoginController";
    }

    public void show() {
        int idx;
        if (this.loginModel.getUsername() != null) {
            this.userPassword.setFocus();
        } else {
            this.username.setFocus();
        }
        if (this.availableRepositories.getRows() < 4) {
            this.availableRepositories.setRows(4);
        }
        if ((idx = this.loginModel.getRepositoryIndex(this.loginModel.getSelectedRepository())) >= 0) {
            this.availableRepositories.setSelectedIndex(idx);
        }
        this.loginDialog.show();
    }

    public void login() {
        if (!this.loginModel.isValid()) {
            return;
        }
        try {
            XulWaitBox box = (XulWaitBox)this.document.createElement("waitbox");
            box.setIndeterminate(true);
            box.setCanCancel(false);
            box.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Wait.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Wait.Message", (String[])new String[0]));
            Shell loginShell = (Shell)this.loginDialog.getRootObject();
            final Display display = loginShell.getDisplay();
            box.setDialogParent((Object)loginShell);
            box.setRunnable(new WaitBoxRunnable(box){

                public void run() {
                    try {
                        RepositoriesController.this.helper.loginToRepository();
                        this.waitBox.stop();
                        display.syncExec(new Runnable(){

                            public void run() {
                                RepositoriesController.this.loginDialog.hide();
                                RepositoriesController.this.okButton.setDisabled(false);
                                RepositoriesController.this.cancelButton.setDisabled(false);
                                if (RepositoriesController.this.helper.getConnectedRepository().getConnectMessage() != null) {
                                    RepositoriesController.this.getMessageBox().setTitle(BaseMessages.getString((Class)PKG, (String)"ConnectMessageTitle", (String[])new String[0]));
                                    RepositoriesController.this.getMessageBox().setMessage(RepositoriesController.this.helper.getConnectedRepository().getConnectMessage());
                                    RepositoriesController.this.getMessageBox().open();
                                }
                                RepositoriesController.this.getCallback().onSuccess(RepositoriesController.this.helper.getConnectedRepository());
                            }
                        });
                    }
                    catch (Throwable th) {
                        this.waitBox.stop();
                        try {
                            display.syncExec(new Runnable(){

                                public void run() {
                                    RepositoriesController.this.getCallback().onError(th);
                                    RepositoriesController.this.okButton.setDisabled(false);
                                    RepositoriesController.this.cancelButton.setDisabled(false);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void cancel() {
                }
            });
            this.okButton.setDisabled(true);
            this.cancelButton.setDisabled(true);
            box.start();
        }
        catch (XulException e1) {
            this.getCallback().onError(e1);
        }
    }

    public void newRepository() {
        this.helper.newRepository();
    }

    public void editRepository() {
        this.helper.editRepository();
    }

    public void deleteRepository() {
        this.helper.deleteRepository();
    }

    public void closeRepositoryLoginDialog() {
        this.loginDialog.hide();
        this.getCallback().onCancel();
    }

    public void updateShowDialogAtStartup() {
        this.helper.updateShowDialogOnStartup(this.showAtStartup.isChecked());
    }

    public XulMessageBox getMessageBox() {
        return this.messageBox;
    }

    public void setMessageBox(XulMessageBox messageBox) {
        this.messageBox = messageBox;
    }

    public void setMessages(ResourceBundle messages) {
        this.messages = messages;
    }

    public ResourceBundle getMessages() {
        return this.messages;
    }

    public String getPreferredRepositoryName() {
        return this.preferredRepositoryName;
    }

    public void setPreferredRepositoryName(String preferredRepositoryName) {
        this.preferredRepositoryName = preferredRepositoryName;
    }

    public void setCallback(ILoginCallback callback) {
        this.callback = callback;
    }

    public ILoginCallback getCallback() {
        return this.callback;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }
}

