/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;

public class RepositoryExportProgressDialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private Shell shell;
    private Repository rep;
    private RepositoryDirectoryInterface dir;
    private String filename;
    private ImportRules importRules;
    private LogChannelInterface log;

    public RepositoryExportProgressDialog(Shell shell, Repository rep, RepositoryDirectoryInterface dir, String filename) {
        this(shell, rep, dir, filename, new ImportRules());
    }

    public RepositoryExportProgressDialog(Shell shell, Repository rep, RepositoryDirectoryInterface dir, String filename, ImportRules importRules) {
        this.shell = shell;
        this.rep = rep;
        this.dir = dir;
        this.filename = filename;
        this.importRules = importRules;
        this.log = rep.getLog();
    }

    public boolean open() {
        boolean retval = true;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IRepositoryExporter exporter = RepositoryExportProgressDialog.this.rep.getExporter();
                    exporter.setImportRulesToValidate(RepositoryExportProgressDialog.this.importRules);
                    exporter.exportAllObjects((ProgressMonitorListener)new ProgressMonitorAdapter(monitor), RepositoryExportProgressDialog.this.filename, RepositoryExportProgressDialog.this.dir, "all");
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"RepositoryExportDialog.Error.CreateUpdate", (String[])new String[]{Const.getStackTracker((Throwable)e)}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.log.logError(RepositoryExportProgressDialog.class.toString(), new Object[]{"Error creating repository: " + e.toString()});
            this.log.logError(Const.getStackTracker((Throwable)e));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Message", (String[])new String[0]), e);
            retval = false;
        }
        catch (InterruptedException e) {
            this.log.logError(RepositoryExportProgressDialog.class.toString(), new Object[]{"Error creating repository: " + e.toString()});
            this.log.logError(Const.getStackTracker((Throwable)e));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExportDialog.ErrorExport.Message", (String[])new String[0]), e);
            retval = false;
        }
        return retval;
    }
}

