/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeRepositoryProgressDialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private Shell shell;
    private KettleDatabaseRepository rep;
    private boolean upgrade;
    private List<String> generatedStatements;
    private boolean dryRun;
    private LogChannelInterface log;

    public UpgradeRepositoryProgressDialog(Shell shell, KettleDatabaseRepository rep, boolean upgrade) {
        this.shell = shell;
        this.rep = rep;
        this.upgrade = upgrade;
        this.generatedStatements = new ArrayList<String>();
        this.dryRun = false;
        this.log = rep.getLog();
    }

    public boolean open() {
        boolean retval = true;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                MessageBox box = new MessageBox(UpgradeRepositoryProgressDialog.this.shell, 192);
                box.setMessage(BaseMessages.getString((Class)PKG, (String)"UpgradeRepositoryDialog.DryRunQuestion.Message", (String[])new String[0]));
                box.setText(BaseMessages.getString((Class)PKG, (String)"UpgradeRepositoryDialog.DryRunQuestion.Title", (String[])new String[0]));
                int answer = box.open();
                try {
                    if (answer == 64) {
                        UpgradeRepositoryProgressDialog.this.dryRun = true;
                        UpgradeRepositoryProgressDialog.this.rep.createRepositorySchema((ProgressMonitorListener)new ProgressMonitorAdapter(monitor), UpgradeRepositoryProgressDialog.this.upgrade, UpgradeRepositoryProgressDialog.this.generatedStatements, true);
                    } else {
                        UpgradeRepositoryProgressDialog.this.rep.createRepositorySchema((ProgressMonitorListener)new ProgressMonitorAdapter(monitor), UpgradeRepositoryProgressDialog.this.upgrade, UpgradeRepositoryProgressDialog.this.generatedStatements, false);
                    }
                }
                catch (KettleException e) {
                    UpgradeRepositoryProgressDialog.this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)e)});
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"UpgradeRepositoryDialog.Error.CreateUpdate", (String[])new String[]{e.getMessage()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            this.log.logError(UpgradeRepositoryProgressDialog.class.toString(), new Object[]{"Error creating/updating repository: " + e.toString()});
            this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)e)});
            this.showErrorDialog(e);
            retval = false;
        }
        catch (InterruptedException e) {
            this.log.logError(UpgradeRepositoryProgressDialog.class.toString(), new Object[]{"Error creating/updating repository: " + e.toString()});
            this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)e)});
            this.showErrorDialog(e);
            retval = false;
        }
        return retval;
    }

    private void showErrorDialog(Exception e) {
        String sMessage;
        String sTitle;
        if (this.upgrade) {
            sTitle = BaseMessages.getString(PKG, (String)"UpgradeRepositoryDialog.ErrorUpgrade.Title", (String[])new String[0]);
            sMessage = BaseMessages.getString(PKG, (String)"UpgradeRepositoryDialog.ErrorUpgrade.Message", (String[])new String[0]);
        } else {
            sTitle = BaseMessages.getString(PKG, (String)"UpgradeRepositoryDialog.ErrorCreate.Title", (String[])new String[0]);
            sMessage = BaseMessages.getString(PKG, (String)"UpgradeRepositoryDialog.ErrorCreate.Message", (String[])new String[0]);
        }
        new ErrorDialog(this.shell, sTitle, sMessage, e);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getGeneratedStatements() {
        return this.generatedStatements;
    }
}

