/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.filerep;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class KettleFileRepositoryDialog
implements RepositoryDialogInterface {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private RepositoryDialogInterface.MODE mode;
    private Label wlBaseDir;
    private Button wbBaseDir;
    private Text wBaseDir;
    private FormData fdlBaseDir;
    private FormData fdBaseDir;
    private FormData fdbBaseDir;
    private Label wlReadOnly;
    private Button wReadOnly;
    private FormData fdlReadOnly;
    private FormData fdReadOnly;
    private Label wlHidesHiddenFiles;
    private Button wHidesHiddenFiles;
    private FormData fdlHidesHiddenFiles;
    private FormData fdHidesHiddenFiles;
    private Label wlId;
    private Text wId;
    private FormData fdlId;
    private FormData fdId;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Display display;
    private Shell shell;
    private PropsUI props;
    private KettleFileRepositoryMeta input;
    private RepositoriesMeta masterRepositoriesMeta;
    private String masterRepositoryName;

    public KettleFileRepositoryDialog(Shell parent, int style, RepositoryMeta repositoryMeta, RepositoriesMeta repositoriesMeta) {
        this.display = parent.getDisplay();
        this.props = PropsUI.getInstance();
        this.input = (KettleFileRepositoryMeta)repositoryMeta;
        this.masterRepositoriesMeta = repositoriesMeta.clone();
        this.masterRepositoryName = repositoryMeta.getName();
        this.shell = new Shell(parent, style | 0x860 | 0x10 | 0x400 | 0x80);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.Main.Title", (String[])new String[0]));
    }

    public KettleFileRepositoryMeta open(RepositoryDialogInterface.MODE mode) {
        this.mode = mode;
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.Main.Title2", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wbBaseDir = new Button((Composite)this.shell, 8);
        this.wbBaseDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbBaseDir = new FormData();
        this.fdbBaseDir.right = new FormAttachment(100, 0);
        this.fdbBaseDir.top = new FormAttachment(0, margin);
        this.wbBaseDir.setLayoutData((Object)this.fdbBaseDir);
        this.wBaseDir = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBaseDir);
        this.fdBaseDir = new FormData();
        this.fdBaseDir.left = new FormAttachment(middle, 0);
        this.fdBaseDir.top = new FormAttachment((Control)this.wbBaseDir, 0, 0x1000000);
        this.fdBaseDir.right = new FormAttachment((Control)this.wbBaseDir, -margin);
        this.wBaseDir.setLayoutData((Object)this.fdBaseDir);
        this.wlBaseDir = new Label((Composite)this.shell, 131072);
        this.wlBaseDir.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Label.BaseDirectory", (String[])new String[0]));
        this.props.setLook((Control)this.wlBaseDir);
        this.fdlBaseDir = new FormData();
        this.fdlBaseDir.left = new FormAttachment(0, 0);
        this.fdlBaseDir.right = new FormAttachment(middle, -margin);
        this.fdlBaseDir.top = new FormAttachment((Control)this.wbBaseDir, 0, 0x1000000);
        this.wlBaseDir.setLayoutData((Object)this.fdlBaseDir);
        this.wlReadOnly = new Label((Composite)this.shell, 131072);
        this.wlReadOnly.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Label.ReadOnly", (String[])new String[0]));
        this.props.setLook((Control)this.wlReadOnly);
        this.fdlReadOnly = new FormData();
        this.fdlReadOnly.left = new FormAttachment(0, 0);
        this.fdlReadOnly.top = new FormAttachment((Control)this.wBaseDir, margin);
        this.fdlReadOnly.right = new FormAttachment(middle, -margin);
        this.wlReadOnly.setLayoutData((Object)this.fdlReadOnly);
        this.wReadOnly = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wReadOnly);
        this.fdReadOnly = new FormData();
        this.fdReadOnly.left = new FormAttachment(middle, 0);
        this.fdReadOnly.top = new FormAttachment((Control)this.wBaseDir, margin);
        this.fdReadOnly.right = new FormAttachment(100, 0);
        this.wReadOnly.setLayoutData((Object)this.fdReadOnly);
        this.wlHidesHiddenFiles = new Label((Composite)this.shell, 131072);
        this.wlHidesHiddenFiles.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Label.HidesHiddenFiles", (String[])new String[0]));
        this.props.setLook((Control)this.wlHidesHiddenFiles);
        this.fdlHidesHiddenFiles = new FormData();
        this.fdlHidesHiddenFiles.left = new FormAttachment(0, 0);
        this.fdlHidesHiddenFiles.top = new FormAttachment((Control)this.wReadOnly, margin);
        this.fdlHidesHiddenFiles.right = new FormAttachment(middle, -margin);
        this.wlHidesHiddenFiles.setLayoutData((Object)this.fdlHidesHiddenFiles);
        this.wHidesHiddenFiles = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHidesHiddenFiles);
        this.fdHidesHiddenFiles = new FormData();
        this.fdHidesHiddenFiles.left = new FormAttachment(middle, 0);
        this.fdHidesHiddenFiles.top = new FormAttachment((Control)this.wReadOnly, margin);
        this.fdHidesHiddenFiles.right = new FormAttachment(100, 0);
        this.wHidesHiddenFiles.setLayoutData((Object)this.fdHidesHiddenFiles);
        this.wbBaseDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dialog = new DirectoryDialog(KettleFileRepositoryDialog.this.shell, 0);
                dialog.setText("Select root directory");
                dialog.setMessage("Select the repository root directory");
                String folder = dialog.open();
                if (folder != null) {
                    KettleFileRepositoryDialog.this.wBaseDir.setText(folder);
                }
            }
        });
        this.wlId = new Label((Composite)this.shell, 131072);
        this.wlId.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Label.DisplayId", (String[])new String[0]));
        this.props.setLook((Control)this.wlId);
        this.fdlId = new FormData();
        this.fdlId.left = new FormAttachment(0, 0);
        this.fdlId.top = new FormAttachment((Control)this.wHidesHiddenFiles, margin * 2);
        this.fdlId.right = new FormAttachment(middle, -margin);
        this.wlId.setLayoutData((Object)this.fdlId);
        this.wId = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wId);
        this.fdId = new FormData();
        this.fdId.left = new FormAttachment(middle, 0);
        this.fdId.top = new FormAttachment((Control)this.wHidesHiddenFiles, margin * 2);
        this.fdId.right = new FormAttachment(100, 0);
        this.wId.setLayoutData((Object)this.fdId);
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Label.Name", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment((Control)this.wId, margin);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment((Control)this.wId, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                KettleFileRepositoryDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                KettleFileRepositoryDialog.this.cancel();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wName);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                KettleFileRepositoryDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.input;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wId.setText(Const.NVL((String)this.input.getName(), (String)""));
        this.wName.setText(Const.NVL((String)this.input.getDescription(), (String)""));
        this.wBaseDir.setText(Const.NVL((String)this.input.getBaseDirectory(), (String)""));
        this.wReadOnly.setSelection(this.input.isReadOnly());
        this.wHidesHiddenFiles.setSelection(this.input.isHidingHiddenFiles());
    }

    private void cancel() {
        this.input = null;
        this.dispose();
    }

    private void getInfo(KettleFileRepositoryMeta info) {
        info.setName(this.wId.getText());
        info.setDescription(this.wName.getText());
        info.setBaseDirectory(this.wBaseDir.getText());
        info.setReadOnly(this.wReadOnly.getSelection());
        info.setHidingHiddenFiles(this.wHidesHiddenFiles.getSelection());
    }

    private void ok() {
        this.getInfo(this.input);
        if (this.input.getBaseDirectory() != null && this.input.getBaseDirectory().length() > 0) {
            if (this.input.getName() != null && this.input.getName().length() > 0) {
                if (this.input.getDescription() != null && this.input.getDescription().length() > 0) {
                    if (this.mode == RepositoryDialogInterface.MODE.ADD) {
                        if (this.masterRepositoriesMeta.searchRepository(this.input.getName()) == null) {
                            this.dispose();
                        } else {
                            this.displayRepositoryAlreadyExistMessage(this.input.getName());
                        }
                    } else if (this.masterRepositoryName.equals(this.input.getName())) {
                        this.dispose();
                    } else if (this.masterRepositoriesMeta.searchRepository(this.input.getName()) == null) {
                        this.dispose();
                    } else {
                        this.displayRepositoryAlreadyExistMessage(this.input.getName());
                    }
                } else {
                    MessageBox box = new MessageBox(this.shell, 33);
                    box.setMessage(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoName.Message", (String[])new String[0]));
                    box.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoName.Title", (String[])new String[0]));
                    box.open();
                }
            } else {
                MessageBox box = new MessageBox(this.shell, 33);
                box.setMessage(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoId.Message", (String[])new String[0]));
                box.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoId.Title", (String[])new String[0]));
                box.open();
            }
        } else {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setMessage(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoBaseDir.Message", (String[])new String[0]));
            box.setText(BaseMessages.getString(PKG, (String)"KettleFileRepositoryDialog.Dialog.ErrorNoBaseDir.Title", (String[])new String[0]));
            box.open();
        }
    }

    private void displayRepositoryAlreadyExistMessage(String name) {
        MessageBox box = new MessageBox(this.shell, 33);
        box.setMessage(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.ErrorIdExist.Message", (String[])new String[]{name}));
        box.setText(BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Error.Title", (String[])new String[0]));
        box.open();
    }
}

