/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.ui.xul.XulEventSourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoriesModel
extends XulEventSourceAdapter {
    private String username;
    private String password;
    private boolean showDialogAtStartup;
    private List<RepositoryMeta> availableRepositories = new ArrayList<RepositoryMeta>();
    private RepositoryMeta selectedRepository;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        String previousValue = this.username;
        this.username = username;
        this.firePropertyChange("username", previousValue, username);
        this.checkIfModelValid();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String previousValue = this.password;
        this.password = password;
        this.firePropertyChange("password", previousValue, password);
    }

    public boolean isShowDialogAtStartup() {
        return this.showDialogAtStartup;
    }

    public void setShowDialogAtStartup(boolean showDialogAtStartup) {
        boolean previousValue = this.showDialogAtStartup;
        this.showDialogAtStartup = showDialogAtStartup;
        this.firePropertyChange("showDialogAtStartup", previousValue, showDialogAtStartup);
    }

    public List<RepositoryMeta> getAvailableRepositories() {
        return this.availableRepositories;
    }

    public void setAvailableRepositories(List<RepositoryMeta> repositoryList) {
        ArrayList<RepositoryMeta> previousValue = new ArrayList<RepositoryMeta>();
        previousValue.addAll(this.availableRepositories);
        this.availableRepositories = repositoryList;
        this.firePropertyChange("availableRepositories", previousValue, repositoryList);
    }

    public void addToAvailableRepositories(RepositoryMeta meta) {
        ArrayList<RepositoryMeta> previousValue = new ArrayList<RepositoryMeta>();
        previousValue.addAll(this.availableRepositories);
        this.availableRepositories.add(meta);
        this.firePropertyChange("availableRepositories", previousValue, this.availableRepositories);
    }

    public void removeFromAvailableRepositories(RepositoryMeta meta) {
        ArrayList<RepositoryMeta> previousValue = new ArrayList<RepositoryMeta>();
        previousValue.addAll(this.availableRepositories);
        this.availableRepositories.remove(meta);
        this.firePropertyChange("availableRepositories", previousValue, this.availableRepositories);
    }

    public void clear() {
        this.setUsername(null);
        this.setPassword(null);
        this.setShowDialogAtStartup(true);
        this.setAvailableRepositories(null);
    }

    public void setSelectedRepositoryUsingName(String repositoryName) {
        this.setSelectedRepository(this.getRepository(repositoryName));
    }

    public void setSelectedRepository(RepositoryMeta selectedRepository) {
        RepositoryMeta previousValue = this.selectedRepository;
        this.selectedRepository = selectedRepository;
        this.firePropertyChange("selectedRepository", previousValue, selectedRepository);
        this.checkIfModelValid();
    }

    public RepositoryMeta getSelectedRepository() {
        return this.selectedRepository;
    }

    public RepositoryMeta getRepository(String repositoryName) {
        if (this.availableRepositories != null && this.availableRepositories.size() > 0) {
            for (RepositoryMeta meta : this.availableRepositories) {
                if (meta == null || !meta.getName().equals(repositoryName)) continue;
                return meta;
            }
        }
        return null;
    }

    public int getRepositoryIndex(RepositoryMeta repositoryMeta) {
        int index = 0;
        if (repositoryMeta != null && this.availableRepositories != null && this.availableRepositories.size() > 0) {
            for (RepositoryMeta meta : this.availableRepositories) {
                if (meta != null && meta.getName().equals(repositoryMeta.getName())) break;
                ++index;
            }
        } else {
            index = -1;
        }
        return index;
    }

    public RepositoryMeta getRepository(int index) {
        return this.availableRepositories.get(index);
    }

    public void checkIfModelValid() {
        this.firePropertyChange("valid", null, this.isValid());
    }

    public boolean isValid() {
        return this.username != null && this.username.length() > 0 && this.selectedRepository != null;
    }
}

