/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.repository.repositoryexplorer.UISupportRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.IRepositoryExplorerUISupport;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class RepositoryExplorer {
    private static Log log = LogFactory.getLog(RepositoryExplorer.class);
    private static final Class<?> CLZ = RepositoryExplorer.class;
    private MainController mainController = new MainController();
    private XulDomContainer container;
    private ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)CLZ, (String)key, (String[])new String[0]);
        }
    };

    public RepositoryExplorer(Shell shell, Repository rep, RepositoryExplorerCallback callback, VariableSpace variableSpace) throws XulException {
        SwtXulLoader swtXulLoader = new SwtXulLoader();
        swtXulLoader.setOuterContext((Object)shell);
        swtXulLoader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
        swtXulLoader.registerClassLoader((Object)this.getClass().getClassLoader());
        this.container = swtXulLoader.loadXul("org/pentaho/di/ui/repository/repositoryexplorer/xul/explorer-layout.xul", (Object)this.resourceBundle);
        SpoonPluginManager.getInstance().applyPluginsForContainer("repository-explorer", this.container);
        SwtXulRunner runner = new SwtXulRunner();
        runner.addContainer(this.container);
        this.mainController.setRepository(rep);
        this.mainController.setCallback(callback);
        this.container.addEventHandler((XulEventHandler)this.mainController);
        ArrayList<IRepositoryExplorerUISupport> uiSupportList = new ArrayList<IRepositoryExplorerUISupport>();
        try {
            for (Class sevice : rep.getServiceInterfaces()) {
                IRepositoryExplorerUISupport uiSupport = UISupportRegistery.getInstance().createUISupport(sevice);
                if (uiSupport == null) continue;
                uiSupportList.add(uiSupport);
                uiSupport.apply(this.container);
            }
        }
        catch (Exception e) {
            log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
        }
        for (IRepositoryExplorerUISupport uiSupport : uiSupportList) {
            try {
                uiSupport.initControllers(rep);
            }
            catch (ControllerInitializationException e) {
                log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
                new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
            }
        }
        try {
            runner.initialize();
        }
        catch (XulException e) {
            log.error((Object)this.resourceBundle.getString("RepositoryExplorer.ErrorStartingXulApplication"), (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), (Exception)((Object)e));
        }
    }

    public void show() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-explorer-dialog");
        dialog.show();
    }

    public void dispose() {
        SwtDialog dialog = (SwtDialog)this.container.getDocumentRoot().getElementById("repository-explorer-dialog");
        dialog.dispose();
    }
}

