/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoerCollection;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.FileOverwriteDialogController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.IBrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjects;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.util.XulDialogCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseController
extends AbstractXulEventHandler
implements IUISupportController,
IBrowseController {
    private static Class<?> PKG = RepositoryExplorer.class;
    protected UIRepositoryDirectory repoDir;
    protected XulTree folderTree;
    protected XulTree fileTable;
    protected UIRepositoryDirectory repositoryDirectory;
    protected ContextChangeVetoerCollection contextChangeVetoers;
    protected BindingFactory bf;
    protected Binding directoryBinding;
    protected Binding selectedItemsBinding;
    protected List<UIRepositoryDirectory> selectedFolderItems;
    protected List<UIRepositoryObject> selectedFileItems;
    protected List<UIRepositoryDirectory> repositoryDirectories;
    protected Repository repository;
    List<UIRepositoryObject> repositoryObjects;
    List<UIRepositoryObject> repositoryItems;
    private MainController mainController;
    protected XulMessageBox messageBox;
    protected XulConfirmBox confirmBox;
    protected Map<ObjectId, UIRepositoryDirectory> dirMap;
    private PropertyChangeListener fileChildrenListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent arg0) {
            try {
                BrowseController.this.firePropertyChange("selectedRepoDirChildren", null, (Object)BrowseController.this.getSelectedRepoDirChildren());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private String newName = null;

    private void fireRepositoryDirectoryChange() {
        this.firePropertyChange("repositoryDirectory", null, (Object)this.repositoryDirectory);
    }

    private void fireFoldersAndItemsChange(List<UIRepositoryDirectory> previousValue, UIRepositoryObjects previousRepoObjects) {
        this.firePropertyChange("repositoryDirectories", previousValue, this.getRepositoryDirectories());
        this.firePropertyChange("selectedRepoDirChildren", (Object)previousRepoObjects, (Object)this.getSelectedRepoDirChildren());
    }

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        try {
            this.repository = repository;
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
            try {
                this.repositoryDirectory = UIObjectRegistry.getInstance().constructUIRepositoryDirectory(repository.loadRepositoryDirectoryTree(), null, repository);
            }
            catch (UIObjectCreationException uoe) {
                this.repositoryDirectory = new UIRepositoryDirectory(repository.loadRepositoryDirectoryTree(), null, repository);
            }
            this.dirMap = new HashMap<ObjectId, UIRepositoryDirectory>();
            this.populateDirMap(this.repositoryDirectory);
            this.bf = new SwtBindingFactory();
            this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
            this.createBindings();
        }
        catch (Exception e) {
            throw new ControllerInitializationException(e);
        }
    }

    protected void createBindings() {
        this.folderTree = (XulTree)this.document.getElementById("folder-tree");
        this.fileTable = (XulTree)this.document.getElementById("file-table");
        if (!this.repositoryDirectory.isVisible()) {
            this.folderTree.setHiddenrootnode(true);
        } else {
            this.folderTree.setHiddenrootnode(false);
        }
        BindingConvertor checkIfMultipleItemsAreSelected = new BindingConvertor<List<?>, Boolean>(){

            public Boolean sourceToTarget(List<?> value) {
                return value != null && value.size() == 1 && value.get(0) != null;
            }

            public List<?> targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.fileTable, "selectedItems", "file-context-rename", "!disabled", new BindingConvertor[]{checkIfMultipleItemsAreSelected});
        this.bf.createBinding((Object)this.fileTable, "selectedItems", (Object)this, "selectedFileItems", new BindingConvertor[0]);
        PropertyChangeListener childrenListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BrowseController.this.fireRepositoryDirectoryChange();
            }
        };
        this.repositoryDirectory.addPropertyChangeListener("children", childrenListener);
        this.directoryBinding = this.createDirectoryBinding();
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.folderTree, "selectedItems", (Object)this, "selectedFolderItems", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.selectedItemsBinding = this.bf.createBinding((Object)this, "selectedRepoDirChildren", (Object)this.fileTable, "elements", new BindingConvertor[0]);
        this.doCreateBindings();
        try {
            this.directoryBinding.fireSourceChanged();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String[] homePath;
            RepositoryDirectoryInterface homeDir = this.repository.getUserHomeDirectory();
            int currentDir = 0;
            String[] stringArray = homePath = homeDir == null ? null : homeDir.getPathArray();
            if (homePath != null) {
                UIRepositoryDirectory tempRoot = this.repositoryDirectory;
                if (homePath.length > 0 && tempRoot.getName().equalsIgnoreCase(homePath[currentDir])) {
                    if (homePath.length == 1) {
                        this.setSelectedFolderItems(Arrays.asList(tempRoot));
                    }
                    ++currentDir;
                }
                while (currentDir < homePath.length) {
                    Iterator<UIRepositoryObject> i$ = tempRoot.iterator();
                    while (i$.hasNext()) {
                        UIRepositoryObject uiObj = i$.next();
                        if (!(uiObj instanceof UIRepositoryDirectory) || !uiObj.getName().equalsIgnoreCase(homePath[currentDir])) continue;
                        tempRoot = (UIRepositoryDirectory)uiObj;
                        break;
                    }
                    ++currentDir;
                }
                if (homePath.length == currentDir) {
                    this.setSelectedFolderItems(Arrays.asList(tempRoot));
                    this.folderTree.setSelectedItems(this.selectedFolderItems);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doCreateBindings() {
    }

    protected Binding createDirectoryBinding() {
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        return this.bf.createBinding((Object)this, "repositoryDirectory", (Object)this.folderTree, "elements", new BindingConvertor[0]);
    }

    @Override
    public String getName() {
        return "browseController";
    }

    public UIRepositoryDirectory getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    protected void populateDirMap(UIRepositoryDirectory repDir) {
        this.dirMap.put(repDir.getObjectId(), repDir);
        Iterator<UIRepositoryObject> i$ = repDir.iterator();
        while (i$.hasNext()) {
            UIRepositoryObject obj = i$.next();
            if (!(obj instanceof UIRepositoryDirectory)) continue;
            this.populateDirMap((UIRepositoryDirectory)obj);
        }
    }

    public void expandAllFolders() {
        this.folderTree.expandAll();
    }

    public void collapseAllFolders() {
        this.folderTree.collapseAll();
    }

    public void openContent() {
        Collection content = this.fileTable.getSelectedItems();
        this.openContent(content.toArray());
    }

    public void openContent(Object[] items) {
        if (items != null && items.length > 0) {
            for (Object o : items) {
                if (o instanceof UIRepositoryDirectory) {
                    ((UIRepositoryDirectory)((Object)o)).toggleExpanded();
                    ArrayList<Object> selectedFolder = new ArrayList<Object>();
                    selectedFolder.add(o);
                    this.folderTree.setSelectedItems(selectedFolder);
                    continue;
                }
                if (this.mainController != null && this.mainController.getCallback() != null && o instanceof UIRepositoryContent && !this.mainController.getCallback().open((UIRepositoryContent)((Object)o), null)) continue;
            }
        }
    }

    public void renameContent() throws Exception {
        try {
            Collection content = this.fileTable.getSelectedItems();
            UIRepositoryObject contentToRename = (UIRepositoryObject)((Object)content.iterator().next());
            this.renameRepositoryObject(contentToRename);
            if (contentToRename instanceof UIRepositoryDirectory) {
                this.directoryBinding.fireSourceChanged();
            }
            this.selectedItemsBinding.fireSourceChanged();
        }
        catch (Throwable th) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)th.getLocalizedMessage(), (String[])new String[0]));
            this.messageBox.open();
        }
    }

    public void deleteContent() throws Exception {
        try {
            for (Object object : this.fileTable.getSelectedItems()) {
                UIRepositoryObject repoObject;
                if (!(object instanceof UIRepositoryObject) || (repoObject = (UIRepositoryObject)((Object)object)) == null) continue;
                if (repoObject instanceof UIRepositoryDirectory && (((UIRepositoryDirectory)repoObject).getChildren().size() > 0 || ((UIRepositoryDirectory)repoObject).getRepositoryObjects().size() > 0)) {
                    this.confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
                    this.confirmBox.setTitle(BaseMessages.getString(PKG, (String)"BrowseController.DeleteNonEmptyFolderWarningTitle", (String[])new String[0]));
                    this.confirmBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.DeleteNonEmptyFolderWarningMessage", (String[])new String[0]));
                    this.confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
                    this.confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

                        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                            if (returnCode == XulDialogCallback.Status.ACCEPT) {
                                try {
                                    BrowseController.this.deleteContent(repoObject);
                                }
                                catch (Exception e) {
                                    BrowseController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                                    BrowseController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                                    BrowseController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
                                    BrowseController.this.messageBox.open();
                                }
                            }
                        }

                        public void onError(XulComponent sender, Throwable t) {
                            throw new RuntimeException(t);
                        }
                    });
                    this.confirmBox.open();
                    break;
                }
                this.deleteContent(repoObject);
            }
        }
        catch (KettleException ke) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)ke.getLocalizedMessage(), (String[])new String[0]));
            this.messageBox.open();
        }
    }

    protected void deleteContent(UIRepositoryObject repoObject) throws Exception {
        repoObject.delete();
        if (repoObject instanceof UIRepositoryDirectory) {
            this.directoryBinding.fireSourceChanged();
            if (this.repoDir != null) {
                this.repoDir.refresh();
            }
        }
        this.selectedItemsBinding.fireSourceChanged();
    }

    public void createFolder() throws Exception {
        try {
            Collection directories = this.folderTree.getSelectedItems();
            if (directories == null || directories.size() == 0) {
                return;
            }
            UIRepositoryDirectory selectedFolder = (UIRepositoryDirectory)((Object)directories.iterator().next());
            XulPromptBox prompt = this.promptForName(null);
            prompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

                public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                    BrowseController.this.newName = value;
                }

                public void onError(XulComponent component, Throwable err) {
                    throw new RuntimeException(err);
                }
            });
            prompt.open();
            if (this.newName != null) {
                if (selectedFolder == null) {
                    selectedFolder = this.repositoryDirectory;
                }
                UIRepositoryDirectory newDir = selectedFolder.createFolder(this.newName);
                this.dirMap.put(newDir.getObjectId(), newDir);
                this.directoryBinding.fireSourceChanged();
                this.selectedItemsBinding.fireSourceChanged();
                this.folderTree.setSelectedItems(Collections.singletonList(selectedFolder));
            }
            this.newName = null;
        }
        catch (Exception e) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
            this.messageBox.open();
        }
    }

    public void exportFolder() throws Exception {
        for (Object object : this.folderTree.getSelectedItems()) {
            if (!(object instanceof UIRepositoryDirectory)) continue;
            this.repoDir = (UIRepositoryDirectory)((Object)object);
            if (!Spoon.getInstance().exportRepositoryDirectory(this.repoDir.getDirectory())) continue;
            return;
        }
    }

    public void deleteFolder() throws Exception {
        UIRepositoryDirectory newSelectedItem = null;
        try {
            for (Object object : this.folderTree.getSelectedItems()) {
                if (!(object instanceof UIRepositoryDirectory)) continue;
                this.repoDir = (UIRepositoryDirectory)((Object)object);
                if (this.repoDir == null) continue;
                newSelectedItem = this.repoDir.getParent();
                if (this.repoDir.getChildren().size() > 0 || this.repoDir.getRepositoryObjects().size() > 0) {
                    this.confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
                    this.confirmBox.setTitle(BaseMessages.getString(PKG, (String)"BrowseController.DeleteNonEmptyFolderWarningTitle", (String[])new String[0]));
                    this.confirmBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.DeleteNonEmptyFolderWarningMessage", (String[])new String[0]));
                    this.confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
                    this.confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

                        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                            if (returnCode == XulDialogCallback.Status.ACCEPT) {
                                try {
                                    BrowseController.this.deleteFolder(BrowseController.this.repoDir);
                                }
                                catch (Exception e) {
                                    BrowseController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                                    BrowseController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                                    BrowseController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
                                    BrowseController.this.messageBox.open();
                                }
                            }
                        }

                        public void onError(XulComponent sender, Throwable t) {
                            throw new RuntimeException(t);
                        }
                    });
                    this.confirmBox.open();
                    break;
                }
                this.deleteFolder(this.repoDir);
            }
        }
        catch (KettleException ke) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)ke.getLocalizedMessage(), (String[])new String[0]));
            this.messageBox.open();
        }
        if (newSelectedItem != null) {
            this.folderTree.setSelectedItems(Arrays.asList(newSelectedItem));
        }
    }

    protected void deleteFolder(UIRepositoryDirectory repoDir) throws Exception {
        repoDir.delete();
        this.directoryBinding.fireSourceChanged();
        this.selectedItemsBinding.fireSourceChanged();
        repoDir.refresh();
    }

    public void renameFolder() throws Exception {
        try {
            Collection directory = this.folderTree.getSelectedItems();
            UIRepositoryDirectory toRename = (UIRepositoryDirectory)((Object)directory.iterator().next());
            this.renameRepositoryObject(toRename);
            this.directoryBinding.fireSourceChanged();
            this.selectedItemsBinding.fireSourceChanged();
        }
        catch (Throwable th) {
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)th.getLocalizedMessage(), (String[])new String[0]));
            this.messageBox.open();
        }
    }

    protected void renameRepositoryObject(final UIRepositoryObject object) throws XulException {
        XulPromptBox prompt = this.promptForName(object);
        prompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (status == XulDialogCallback.Status.ACCEPT) {
                    try {
                        object.setName(value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onError(XulComponent component, Throwable err) {
                throw new RuntimeException(err);
            }
        });
        prompt.open();
    }

    protected XulPromptBox promptForName(UIRepositoryObject object) throws XulException {
        XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
        String currentName = object == null ? BaseMessages.getString(PKG, (String)"BrowserController.NewFolder", (String[])new String[0]) : object.getName();
        prompt.setTitle(BaseMessages.getString(PKG, (String)"BrowserController.Name", (String[])new String[0]).concat(currentName));
        prompt.setButtons((Object[])new DialogConstant[]{DialogConstant.OK, DialogConstant.CANCEL});
        prompt.setMessage(BaseMessages.getString(PKG, (String)"BrowserController.NameLabel", (String[])new String[0]).concat(currentName));
        prompt.setValue(currentName);
        return prompt;
    }

    public void onDragFromGlobalTree(DropEvent event) {
        event.setAccepted(true);
    }

    public void onDragFromLocalTable(DropEvent event) {
        event.setAccepted(true);
    }

    public void onDrop(DropEvent event) {
        boolean result = false;
        try {
            ArrayList dirList = new ArrayList();
            ArrayList<UIRepositoryObject> moveList = new ArrayList<UIRepositoryObject>();
            UIRepositoryDirectory targetDirectory = null;
            if (event.getDropParent() != null && event.getDropParent() instanceof UIRepositoryDirectory) {
                targetDirectory = (UIRepositoryDirectory)((Object)event.getDropParent());
                if (event.getDataTransfer().getData().size() > 0) {
                    for (Object o : event.getDataTransfer().getData()) {
                        if (!(o instanceof UIRepositoryObject)) continue;
                        moveList.add((UIRepositoryObject)((Object)o));
                        if (o instanceof UIRepositoryDirectory) {
                            dirList.add(o);
                        }
                        result = true;
                    }
                }
            }
            if (result) {
                ArrayList<UIRepositoryObject> collisionObjects = new ArrayList<UIRepositoryObject>();
                for (UIRepositoryObject newChild : moveList) {
                    Iterator i$ = targetDirectory.getRepositoryObjects().iterator();
                    while (i$.hasNext()) {
                        UIRepositoryObject currChild = (UIRepositoryObject)((Object)i$.next());
                        if (currChild instanceof UIRepositoryDirectory && newChild instanceof UIRepositoryDirectory && currChild.getName().equalsIgnoreCase(newChild.getName())) {
                            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.UnableToMove.DirectoryAlreadyExists", (String[])new String[]{currChild.getPath()}));
                            this.messageBox.open();
                            result = false;
                            break;
                        }
                        if (currChild instanceof UIRepositoryDirectory || !currChild.getType().equalsIgnoreCase(newChild.getType()) || !currChild.getName().equalsIgnoreCase(newChild.getName())) continue;
                        collisionObjects.add(currChild);
                    }
                    if (result) continue;
                    break;
                }
                if (result && collisionObjects.size() > 0) {
                    FileOverwriteDialogController fileOverwriteDialog = FileOverwriteDialogController.getInstance(this.getXulDomContainer().getOuterContext() instanceof Shell ? (Shell)this.getXulDomContainer().getOuterContext() : null, collisionObjects);
                    fileOverwriteDialog.show();
                    if (fileOverwriteDialog.isOverwriteFiles()) {
                        for (UIRepositoryObject o : collisionObjects) {
                            o.delete();
                        }
                    } else {
                        result = false;
                    }
                }
                if (result) {
                    this.moveFiles(moveList, targetDirectory);
                    event.getDataTransfer().setData(dirList);
                }
            }
        }
        catch (Exception e) {
            result = false;
            event.setAccepted(false);
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.UnableToMove", (String[])new String[]{e.getLocalizedMessage()}));
            this.messageBox.open();
        }
        event.setAccepted(result);
    }

    protected void moveFiles(List<UIRepositoryObject> objects, UIRepositoryDirectory targetDirectory) throws Exception {
        for (UIRepositoryObject o : objects) {
            o.move(targetDirectory);
        }
    }

    public void onDoubleClick(Object[] selectedItems) {
        this.openContent(selectedItems);
    }

    public List<UIRepositoryDirectory> getSelectedFolderItems() {
        return this.selectedFolderItems;
    }

    public void setSelectedFolderItems(List<UIRepositoryDirectory> selectedFolderItems) {
        if (!this.compareFolderList(selectedFolderItems, this.selectedFolderItems)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedFolderItems = selectedFolderItems;
                this.setRepositoryDirectories(selectedFolderItems);
            } else if (this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.folderTree.setSelectedItems(this.selectedFolderItems);
                this.fileTable.setSelectedItems(this.selectedFileItems);
            }
        } else {
            this.setRepositoryDirectories(selectedFolderItems);
        }
    }

    public List<UIRepositoryObject> getSelectedFileItems() {
        return this.selectedFileItems;
    }

    public void setSelectedFileItems(List<UIRepositoryObject> selectedFileItems) {
        if (!this.compareFileList(selectedFileItems, this.selectedFileItems)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedFileItems = selectedFileItems;
                this.setRepositoryObjects(selectedFileItems);
                this.setRepositoryItems(selectedFileItems);
            } else if (this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.fileTable.setSelectedItems(this.selectedFileItems);
            }
        } else {
            this.setRepositoryItems(selectedFileItems);
        }
    }

    public Binding getSelectedItemsBinding() {
        return this.selectedItemsBinding;
    }

    public void setSelectedItemsBinding(Binding selectedItemsBinding) {
        this.selectedItemsBinding = selectedItemsBinding;
    }

    public void setRepositoryObjects(List<UIRepositoryObject> selectedFileItems) {
        this.repositoryObjects = selectedFileItems;
        this.firePropertyChange("repositoryObjects", null, selectedFileItems);
    }

    public List<UIRepositoryObject> getRepositoryObjects() {
        return this.repositoryObjects;
    }

    public void setRepositoryItems(List<UIRepositoryObject> selectedItems) {
        this.repositoryItems = selectedItems;
        this.firePropertyChange("repositoryItems", null, this.repositoryItems);
    }

    public List<UIRepositoryObject> getRepositoryItems() {
        return this.repositoryItems;
    }

    public List<UIRepositoryDirectory> getRepositoryDirectories() {
        if (this.repositoryDirectories != null && this.repositoryDirectories.size() == 0) {
            return null;
        }
        return this.repositoryDirectories;
    }

    public void setRepositoryDirectories(List<UIRepositoryDirectory> selectedFolderItems) {
        ArrayList<UIRepositoryDirectory> previousVal = null;
        UIRepositoryObjects previousRepoObjects = null;
        try {
            if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                previousVal = new ArrayList<UIRepositoryDirectory>();
                previousVal.addAll(this.repositoryDirectories);
                previousRepoObjects = this.getSelectedRepoDirChildren();
            }
            if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                this.repositoryDirectories.get(0).getRepositoryObjects().removePropertyChangeListener(this.fileChildrenListener);
            }
            this.repositoryDirectories = selectedFolderItems;
            if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                this.repositoryDirectories.get(0).getRepositoryObjects().addPropertyChangeListener("children", this.fileChildrenListener);
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
        this.fireFoldersAndItemsChange(previousVal, previousRepoObjects);
    }

    public UIRepositoryObjects getSelectedRepoDirChildren() {
        UIRepositoryObjects repoObjects = null;
        if (this.selectedFolderItems != null && this.selectedFolderItems.size() > 0) {
            try {
                repoObjects = this.repositoryDirectories.get(0).getRepositoryObjects();
            }
            catch (KettleException e) {
                throw new RuntimeException(e);
            }
        }
        return repoObjects;
    }

    @Override
    public void addContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers == null) {
            this.contextChangeVetoers = new ContextChangeVetoerCollection();
        }
        this.contextChangeVetoers.add(listener);
    }

    @Override
    public void removeContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers != null) {
            this.contextChangeVetoers.remove(listener);
        }
    }

    private boolean contains(ContextChangeVetoer.TYPE type, List<ContextChangeVetoer.TYPE> typeList) {
        for (ContextChangeVetoer.TYPE t : typeList) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    List<ContextChangeVetoer.TYPE> pollContextChangeVetoResults() {
        if (this.contextChangeVetoers != null) {
            return this.contextChangeVetoers.fireContextChange();
        }
        ArrayList<ContextChangeVetoer.TYPE> returnValue = new ArrayList<ContextChangeVetoer.TYPE>();
        returnValue.add(ContextChangeVetoer.TYPE.NO_OP);
        return returnValue;
    }

    boolean compareFolderList(List<UIRepositoryDirectory> rd1, List<UIRepositoryDirectory> rd2) {
        if (rd1 != null && rd2 != null) {
            if (rd1.size() != rd2.size()) {
                return false;
            }
            for (int i = 0; i < rd1.size(); ++i) {
                if (rd1.get(i) == null || rd2.get(i) == null || rd1.get(i).getName().equals(rd2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    boolean compareFileList(List<UIRepositoryObject> ro1, List<UIRepositoryObject> ro2) {
        if (ro1 != null && ro2 != null) {
            if (ro1.size() != ro2.size()) {
                return false;
            }
            for (int i = 0; i < ro1.size(); ++i) {
                if (ro1.get(i) == null || ro2.get(i) == null || ro1.get(i).getName().equals(ro2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

