/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.cluster.dialog.ClusterSchemaDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UICluster;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIClusters;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClustersController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    protected BindingFactory bf = null;
    private Shell shell = null;
    private XulTree clustersTable = null;
    private UIClusters clusterList = new UIClusters();

    @Override
    public String getName() {
        return "clustersController";
    }

    public void createBindings() {
        this.refreshClusters();
        try {
            this.clustersTable = (XulTree)this.document.getElementById("clusters-table");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.clusterList, "children", (Object)this.clustersTable, "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.clustersTable, "selectedItems", (Object)this, "enableButtons", new BindingConvertor[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean doLazyInit() {
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
        this.bf = new SwtBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.enableButtons(true, false, false);
        if (this.bf != null) {
            this.createBindings();
        }
        return true;
    }

    public void editCluster() {
        String clusterSchemaName = "";
        try {
            Collection clusters = this.clustersTable.getSelectedItems();
            if (clusters != null && !clusters.isEmpty()) {
                ClusterSchema clusterSchema = ((UICluster)((Object)clusters.toArray()[0])).getClusterSchema();
                clusterSchemaName = clusterSchema.getName();
                ObjectId clusterId = this.repository.getClusterID(clusterSchema.getName());
                if (clusterId == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.DoesNotExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    ClusterSchemaDialog csd = new ClusterSchemaDialog(this.shell, clusterSchema, this.repository.getSlaveServers());
                    if (csd.open()) {
                        if (clusterSchema.getName() != null && !clusterSchema.getName().equals("")) {
                            this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"ClusterController.Message.UpdatingCluster", (String[])new String[]{clusterSchema.getName()}));
                            this.repository.save((RepositoryElementInterface)clusterSchema, "Modification by user", null);
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.InvalidName.Message", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.Title", (String[])new String[0]));
                            mb.open();
                        }
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.Title", (String[])new String[0]));
                mb.open();
            }
            this.refreshClusters();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.UnexpectedError.Message", (String[])new String[0]) + clusterSchemaName + "]", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster() {
        try {
            ClusterSchema cluster = new ClusterSchema();
            ClusterSchemaDialog clusterDialog = new ClusterSchemaDialog(this.shell, cluster, this.repository.getSlaveServers());
            if (clusterDialog.open()) {
                ObjectId idCluster = this.repository.getClusterID(cluster.getName());
                if (idCluster == null) {
                    if (cluster.getName() != null && !cluster.getName().equals("")) {
                        this.repository.insertLogEntry(BaseMessages.getString(RepositoryExplorer.class, (String)"ClusterController.Message.CreatingNewCluster", (String[])new String[]{cluster.getName()}));
                        this.repository.save((RepositoryElementInterface)cluster, "Creation of initial version", null);
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.InvalidName.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.Title", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            this.refreshClusters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCluster() {
        String clusterSchemaName = "";
        try {
            Collection clusters = this.clustersTable.getSelectedItems();
            if (clusters != null && !clusters.isEmpty()) {
                for (UICluster obj : clusters) {
                    if (obj == null || !(obj instanceof UICluster)) continue;
                    UICluster cluster = obj;
                    ClusterSchema clusterSchema = cluster.getClusterSchema();
                    clusterSchemaName = clusterSchema.getName();
                    ObjectId clusterId = this.repository.getClusterID(clusterSchema.getName());
                    if (clusterId == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.DoesNotExists.Message", (String[])new String[]{clusterSchema.getName()}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    this.repository.deleteClusterSchema(clusterId);
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.UnexpectedError.Message", (String[])new String[0]) + clusterSchemaName + "]", (Exception)((Object)e));
        }
        finally {
            this.refreshClusters();
        }
    }

    public void refreshClusters() {
        if (this.repository != null) {
            final ArrayList tmpList = new ArrayList();
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        ObjectId[] clusterIdList;
                        for (ObjectId clusterId : clusterIdList = ClustersController.this.repository.getClusterIDs(false)) {
                            ClusterSchema cluster = ClustersController.this.repository.loadClusterSchema(clusterId, ClustersController.this.repository.getSlaveServers(), null);
                            tmpList.add(new UICluster(cluster));
                        }
                    }
                    catch (KettleException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.doWithBusyIndicator(r);
            this.clusterList.setChildren(tmpList);
        }
    }

    public void setEnableButtons(List<UICluster> clusters) {
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (clusters != null && clusters.size() > 0) {
            enableRemove = true;
            if (clusters.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("clusters-new");
        XulButton bEdit = (XulButton)this.document.getElementById("clusters-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("clusters-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

