/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnection;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnections;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionsController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorer.class;
    private XulTree connectionsTable = null;
    protected BindingFactory bf = null;
    private boolean isRepReadOnly = true;
    private Binding bindButtonNew = null;
    private Binding bindButtonEdit = null;
    private Binding bindButtonRemove = null;
    private Shell shell = null;
    private UIDatabaseConnections dbConnectionList = new UIDatabaseConnections();
    private DatabaseDialog databaseDialog;

    @Override
    public String getName() {
        return "connectionsController";
    }

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        this.repository = repository;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    private void createBindings() {
        this.refreshConnectionList();
        this.connectionsTable = (XulTree)this.document.getElementById("connections-table");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        try {
            this.bf.createBinding((Object)this.dbConnectionList, "children", (Object)this.connectionsTable, "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bindButtonNew = this.bf.createBinding((Object)this, "repReadOnly", "connections-new", "disabled", new BindingConvertor[0]);
            this.bindButtonNew.fireSourceChanged();
            this.bindButtonEdit = this.bf.createBinding((Object)this, "repReadOnly", "connections-edit", "disabled", new BindingConvertor[0]);
            this.bindButtonEdit.fireSourceChanged();
            this.bindButtonRemove = this.bf.createBinding((Object)this, "repReadOnly", "connections-remove", "disabled", new BindingConvertor[0]);
            this.bindButtonRemove.fireSourceChanged();
            if (this.repository != null) {
                this.bf.createBinding((Object)this.connectionsTable, "selectedItems", (Object)this, "enableButtons", new BindingConvertor[0]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected boolean doLazyInit() {
        this.setRepReadOnly(this.repository.getRepositoryMeta().getRepositoryCapabilities().isReadOnly());
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
        this.bf = new DefaultBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        if (this.bf != null) {
            this.createBindings();
        }
        this.enableButtons(true, false, false);
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepReadOnly(boolean isRepReadOnly) {
        try {
            if (this.isRepReadOnly != isRepReadOnly) {
                this.isRepReadOnly = isRepReadOnly;
                if (this.initialized) {
                    this.bindButtonNew.fireSourceChanged();
                    this.bindButtonEdit.fireSourceChanged();
                    this.bindButtonRemove.fireSourceChanged();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRepReadOnly() {
        return this.isRepReadOnly;
    }

    private void refreshConnectionList() {
        final ArrayList tmpList = new ArrayList();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    ObjectId[] dbIdList;
                    for (ObjectId dbId : dbIdList = ConnectionsController.this.repository.getDatabaseIDs(false)) {
                        DatabaseMeta dbMeta = ConnectionsController.this.repository.loadDatabaseMeta(dbId, null);
                        tmpList.add(new UIDatabaseConnection(dbMeta));
                    }
                }
                catch (KettleException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.doWithBusyIndicator(r);
        this.dbConnectionList.setChildren(tmpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnection() {
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            databaseMeta.initializeVariablesFrom(null);
            this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
            String dbName = this.getDatabaseDialog().open();
            if (dbName != null && !dbName.equals("")) {
                ObjectId idDatabase = this.repository.getDatabaseID(dbName);
                if (idDatabase == null) {
                    this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"ConnectionsController.Message.CreatingDatabase", (String[])new String[]{this.getDatabaseDialog().getDatabaseMeta().getName()}));
                    this.repository.save((RepositoryElementInterface)this.getDatabaseDialog().getDatabaseMeta(), "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            this.refreshConnectionList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editConnection() {
        try {
            Collection connections = this.connectionsTable.getSelectedItems();
            if (connections != null && !connections.isEmpty()) {
                DatabaseMeta databaseMeta = ((UIDatabaseConnection)((Object)connections.toArray()[0])).getDatabaseMeta();
                ObjectId idDatabase = this.repository.getDatabaseID(databaseMeta.getName());
                if (idDatabase == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.DoesNotExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.DoesNotExists.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                    String dbName = this.getDatabaseDialog().open();
                    if (dbName != null && !dbName.equals("")) {
                        this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"ConnectionsController.Message.UpdatingDatabase", (String[])new String[]{databaseMeta.getName()}));
                        this.repository.save((RepositoryElementInterface)databaseMeta, "Modification by user", null);
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            this.refreshConnectionList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection() {
        try {
            Collection connections = this.connectionsTable.getSelectedItems();
            if (connections != null && !connections.isEmpty()) {
                for (UIDatabaseConnection obj : connections) {
                    if (obj == null || !(obj instanceof UIDatabaseConnection)) continue;
                    UIDatabaseConnection connection = obj;
                    DatabaseMeta databaseMeta = connection.getDatabaseMeta();
                    ObjectId idDatabase = this.repository.getDatabaseID(databaseMeta.getName());
                    if (idDatabase == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.DoesNotExists.Message", (String[])new String[]{databaseMeta.getName()}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    this.repository.deleteDatabaseMeta(databaseMeta.getName());
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            this.refreshConnectionList();
        }
    }

    public void setEnableButtons(List<UIDatabaseConnection> connections) {
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (connections != null && connections.size() > 0) {
            enableRemove = true;
            if (connections.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("connections-new");
        XulButton bEdit = (XulButton)this.document.getElementById("connections-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("connections-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

