/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import java.lang.reflect.Constructor;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIJob;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UITransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIObjectRegistry {
    public static final Class<?> DEFAULT_UIREPOSITORYUSER_CLASS = UIRepositoryUser.class;
    public static final Class<?> DEFAULT_UIJOB_CLASS = UIJob.class;
    public static final Class<?> DEFAULT_UITRANS_CLASS = UITransformation.class;
    public static final Class<?> DEFAULT_UIDIR_CLASS = UIRepositoryDirectory.class;
    private static UIObjectRegistry instance;
    private Class<?> repositoryUserClass = DEFAULT_UIREPOSITORYUSER_CLASS;
    private Class<?> jobClass = DEFAULT_UIJOB_CLASS;
    private Class<?> transClass = DEFAULT_UITRANS_CLASS;
    private Class<?> dirClass = DEFAULT_UIDIR_CLASS;

    private UIObjectRegistry() {
    }

    public static UIObjectRegistry getInstance() {
        if (instance == null) {
            instance = new UIObjectRegistry();
        }
        return instance;
    }

    public void registerUIRepositoryUserClass(Class<?> repositoryUserClass) {
        this.repositoryUserClass = repositoryUserClass;
    }

    public Class<?> getRegisteredUIRepositoryUserClass() {
        return this.repositoryUserClass;
    }

    public void registerUIJobClass(Class<?> jobClass) {
        this.jobClass = jobClass;
    }

    public Class<?> getRegisteredUIJobClass() {
        return this.jobClass;
    }

    public void registerUITransformationClass(Class<?> transClass) {
        this.transClass = transClass;
    }

    public Class<?> getRegisteredUITransformationClass() {
        return this.transClass;
    }

    public void registerUIRepositoryDirectoryClass(Class<?> dirClass) {
        this.dirClass = dirClass;
    }

    public Class<?> getRegisteredUIRepositoryDirectoryClass() {
        return this.dirClass;
    }

    public IUIUser constructUIRepositoryUser(IUser user) throws UIObjectCreationException {
        try {
            Constructor<?> constructor = this.repositoryUserClass.getConstructor(IUser.class);
            if (constructor != null) {
                return (IUIUser)constructor.newInstance(user);
            }
            throw new UIObjectCreationException("Unable to get the constructor for " + this.repositoryUserClass);
        }
        catch (Exception e) {
            throw new UIObjectCreationException("Unable to instantiate object for " + this.repositoryUserClass);
        }
    }

    public UIJob constructUIJob(RepositoryElementMetaInterface rc, UIRepositoryDirectory parent, Repository rep) throws UIObjectCreationException {
        try {
            Constructor<?> constructor = this.jobClass.getConstructor(RepositoryElementMetaInterface.class, UIRepositoryDirectory.class, Repository.class);
            if (constructor != null) {
                return (UIJob)((Object)constructor.newInstance(new Object[]{rc, parent, rep}));
            }
            throw new UIObjectCreationException("Unable to get the constructor for " + this.jobClass);
        }
        catch (Exception e) {
            throw new UIObjectCreationException("Unable to instantiate object for " + this.jobClass);
        }
    }

    public UITransformation constructUITransformation(RepositoryElementMetaInterface rc, UIRepositoryDirectory parent, Repository rep) throws UIObjectCreationException {
        try {
            Constructor<?> constructor = this.transClass.getConstructor(RepositoryElementMetaInterface.class, UIRepositoryDirectory.class, Repository.class);
            if (constructor != null) {
                return (UITransformation)((Object)constructor.newInstance(new Object[]{rc, parent, rep}));
            }
            throw new UIObjectCreationException("Unable to get the constructor for " + this.transClass);
        }
        catch (Exception e) {
            throw new UIObjectCreationException("Unable to instantiate object for " + this.transClass);
        }
    }

    public UIRepositoryDirectory constructUIRepositoryDirectory(RepositoryDirectoryInterface rd, UIRepositoryDirectory uiParent, Repository rep) throws UIObjectCreationException {
        try {
            Constructor<?> constructor = this.dirClass.getConstructor(RepositoryDirectoryInterface.class, UIRepositoryDirectory.class, Repository.class);
            if (constructor != null) {
                return (UIRepositoryDirectory)((Object)constructor.newInstance(new Object[]{rd, uiParent, rep}));
            }
            throw new UIObjectCreationException("Unable to get the constructor for " + this.dirClass);
        }
        catch (Exception e) {
            throw new UIObjectCreationException("Unable to instantiate object for " + this.dirClass);
        }
    }
}

