/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.ui.xul.XulEventSourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISecurity
extends XulEventSourceAdapter {
    private ObjectRecipient.Type selectedDeck;
    protected IUIUser selectedUser;
    private int selectedUserIndex;
    protected List<IUIUser> userList = new ArrayList<IUIUser>();

    public UISecurity() {
    }

    public UISecurity(RepositorySecurityManager rsm) throws Exception {
        this();
        if (rsm != null && rsm.getUsers() != null) {
            for (IUser user : rsm.getUsers()) {
                this.userList.add(UIObjectRegistry.getInstance().constructUIRepositoryUser(user));
            }
            this.firePropertyChange("userList", null, this.userList);
        }
    }

    public ObjectRecipient.Type getSelectedDeck() {
        return this.selectedDeck;
    }

    public void setSelectedDeck(ObjectRecipient.Type selectedDeck) {
        this.selectedDeck = selectedDeck;
        this.firePropertyChange("selectedDeck", null, selectedDeck);
    }

    public int getSelectedUserIndex() {
        return this.selectedUserIndex;
    }

    public void setSelectedUserIndex(int selectedUserIndex) {
        this.selectedUserIndex = selectedUserIndex;
        this.firePropertyChange("selectedUserIndex", null, selectedUserIndex);
    }

    public IUIUser getSelectedUser() {
        return this.selectedUser;
    }

    public void setSelectedUser(IUIUser selectedUser) {
        this.selectedUser = selectedUser;
        this.firePropertyChange("selectedUser", null, selectedUser);
        this.setSelectedUserIndex(this.getIndexOfUser(selectedUser));
    }

    public List<IUIUser> getUserList() {
        return this.userList;
    }

    public void setUserList(List<IUIUser> userList) {
        this.userList.clear();
        this.userList.addAll(userList);
        this.firePropertyChange("userList", null, userList);
    }

    public void updateUser(IUIUser userToUpdate) {
        IUIUser user = this.getUser(userToUpdate.getName());
        user.setDescription(userToUpdate.getDescription());
        this.firePropertyChange("userList", null, this.userList);
        this.setSelectedUser(user);
    }

    public void addUser(IUIUser userToAdd) {
        this.userList.add(userToAdd);
        this.firePropertyChange("userList", null, this.userList);
        this.setSelectedUser(userToAdd);
    }

    public void removeUser(String name) {
        this.removeUser(this.getUser(name));
    }

    public void removeUser(IUIUser userToRemove) {
        int index = this.getIndexOfUser(userToRemove);
        this.userList.remove(userToRemove);
        this.firePropertyChange("userList", null, this.userList);
        if (index - 1 >= 0) {
            this.setSelectedUser(this.getUserAtIndex(index - 1));
        }
    }

    protected IUIUser getUser(String name) {
        for (IUIUser user : this.userList) {
            if (!user.getName().equals(name)) continue;
            return user;
        }
        return null;
    }

    private IUIUser getUserAtIndex(int index) {
        return this.userList.get(index);
    }

    private int getIndexOfUser(IUIUser ru) {
        for (int i = 0; i < this.userList.size(); ++i) {
            IUIUser user = this.userList.get(i);
            if (!ru.getName().equals(user.getName())) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ADD,
        EDIT,
        EDIT_MEMBER;

    }
}

