/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.Locale;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.w3c.dom.Node;

public class JobFileListener
implements FileListener {
    private static Class<?> PKG = Spoon.class;

    public boolean open(Node jobNode, String fname, boolean importfile) {
        Spoon spoon = Spoon.getInstance();
        try {
            JobMeta jobMeta = new JobMeta();
            jobMeta.loadXML(jobNode, spoon.getRepository(), (OverwritePrompter)spoon);
            jobMeta.setRepositoryDirectory(spoon.getDefaultSaveLocation((RepositoryElementInterface)jobMeta));
            spoon.setJobMetaVariables(jobMeta);
            spoon.getProperties().addLastFile("Job", fname, null, false, null);
            spoon.addMenuLast();
            if (!importfile) {
                jobMeta.clearChanged();
            }
            jobMeta.setFilename(fname);
            spoon.delegates.jobs.addJobGraph(jobMeta);
            spoon.refreshTree();
            SpoonPerspectiveManager.getInstance().activatePerspective(MainSpoonPerspective.class);
            return true;
        }
        catch (KettleException e) {
            Spoon.getInstance().hideSplash();
            new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + fname, (Exception)((Object)e));
            return false;
        }
    }

    public boolean save(EngineMetaInterface meta, String fname, boolean export) {
        Spoon spoon = Spoon.getInstance();
        Object lmeta = export ? (JobMeta)((JobMeta)meta).realClone(false) : meta;
        return spoon.saveMeta((EngineMetaInterface)lmeta, fname);
    }

    public void syncMetaName(EngineMetaInterface meta, String name) {
        ((JobMeta)meta).setName(name);
    }

    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("kjb");
    }

    public boolean acceptsXml(String nodeName) {
        return nodeName.equals("job");
    }

    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Jobs", "XML"};
    }

    public String[] getSupportedExtensions() {
        return new String[]{"kjb", "xml"};
    }

    public String getRootNodeName() {
        return "job";
    }
}

