/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;

public class SWTGC
implements GCInterface {
    protected Color background;
    protected Color black;
    protected Color red;
    protected Color yellow;
    protected Color orange;
    protected Color green;
    protected Color blue;
    protected Color magenta;
    protected Color gray;
    protected Color lightGray;
    protected Color darkGray;
    private GC gc;
    private int iconsize;
    private Map<String, Image> images;
    private List<Color> colors;
    private List<Font> fonts;
    private Image image;
    private Point area;
    private Transform transform;

    public SWTGC(Device device, Point area, int iconsize) {
        this.image = new Image(device, area.x, area.y);
        this.gc = new GC((Drawable)this.image);
        this.images = GUIResource.getInstance().getImagesSteps();
        this.iconsize = iconsize;
        this.area = area;
        this.colors = new ArrayList<Color>();
        this.fonts = new ArrayList<Font>();
        this.background = GUIResource.getInstance().getColorGraph();
        this.black = GUIResource.getInstance().getColorBlack();
        this.red = GUIResource.getInstance().getColorRed();
        this.yellow = GUIResource.getInstance().getColorYellow();
        this.orange = GUIResource.getInstance().getColorOrange();
        this.green = GUIResource.getInstance().getColorGreen();
        this.blue = GUIResource.getInstance().getColorBlue();
        this.magenta = GUIResource.getInstance().getColorMagenta();
        this.gray = GUIResource.getInstance().getColorGray();
        this.lightGray = GUIResource.getInstance().getColorLightGray();
        this.darkGray = GUIResource.getInstance().getColorDarkGray();
    }

    public void dispose() {
        this.gc.dispose();
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
        for (Color color : this.colors) {
            color.dispose();
        }
        for (Font font : this.fonts) {
            font.dispose();
        }
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.gc.drawLine(x, y, x2, y2);
    }

    public void drawImage(GCInterface.EImage image, int x, int y) {
        Image img = SWTGC.getNativeImage(image);
        this.gc.drawImage(img, x, y);
    }

    public Point getImageBounds(GCInterface.EImage image) {
        Image img = SWTGC.getNativeImage(image);
        Rectangle r = img.getBounds();
        return new Point(r.width, r.height);
    }

    public static final Image getNativeImage(GCInterface.EImage image) {
        switch (image) {
            case LOCK: {
                return GUIResource.getInstance().getImageLocked();
            }
            case STEP_ERROR: {
                return GUIResource.getInstance().getImageStepError();
            }
            case EDIT: {
                return GUIResource.getInstance().getImageEdit();
            }
            case CONTEXT_MENU: {
                return GUIResource.getInstance().getImageContextMenu();
            }
            case TRUE: {
                return GUIResource.getInstance().getImageTrue();
            }
            case FALSE: {
                return GUIResource.getInstance().getImageFalse();
            }
            case ERROR: {
                return GUIResource.getInstance().getImageErrorHop();
            }
            case INFO: {
                return GUIResource.getInstance().getImageInfoHop();
            }
            case TARGET: {
                return GUIResource.getInstance().getImageHopTarget();
            }
            case INPUT: {
                return GUIResource.getInstance().getImageHopInput();
            }
            case OUTPUT: {
                return GUIResource.getInstance().getImageHopOutput();
            }
            case ARROW: {
                return GUIResource.getInstance().getImageArrow();
            }
            case COPY_ROWS: {
                return GUIResource.getInstance().getImageCopyHop();
            }
            case PARALLEL: {
                return GUIResource.getInstance().getImageParallelHop();
            }
            case UNCONDITIONAL: {
                return GUIResource.getInstance().getImageUnconditionalHop();
            }
            case BUSY: {
                return GUIResource.getInstance().getImageBusy();
            }
        }
        return null;
    }

    public void drawPoint(int x, int y) {
        this.gc.drawPoint(x, y);
    }

    public void drawPolygon(int[] polygon) {
        this.gc.drawPolygon(polygon);
    }

    public void drawPolyline(int[] polyline) {
        this.gc.drawPolyline(polyline);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRectangle(x, y, width, height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.drawRoundRectangle(x, y, width, height, circleWidth, circleHeight);
    }

    public void drawText(String text, int x, int y) {
        this.gc.drawText(text, x, y);
    }

    public void drawText(String text, int x, int y, boolean transparent) {
        this.gc.drawText(text, x, y, 7);
    }

    public void fillPolygon(int[] polygon) {
        this.gc.fillPolygon(polygon);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.gc.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.fillRoundRectangle(x, y, width, height, circleWidth, circleHeight);
    }

    public Point getDeviceBounds() {
        Rectangle p = this.gc.getDevice().getBounds();
        return new Point(p.width, p.height);
    }

    public void setAlpha(int alpha) {
        this.gc.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.gc.getAlpha();
    }

    public void setBackground(GCInterface.EColor color) {
        this.gc.setBackground(this.getColor(color));
    }

    private Color getColor(GCInterface.EColor color) {
        switch (color) {
            case BACKGROUND: {
                return this.background;
            }
            case BLACK: {
                return this.black;
            }
            case RED: {
                return this.red;
            }
            case YELLOW: {
                return this.yellow;
            }
            case ORANGE: {
                return this.orange;
            }
            case GREEN: {
                return this.green;
            }
            case BLUE: {
                return this.blue;
            }
            case MAGENTA: {
                return this.magenta;
            }
            case GRAY: {
                return this.gray;
            }
            case LIGHTGRAY: {
                return this.lightGray;
            }
            case DARKGRAY: {
                return this.darkGray;
            }
        }
        return null;
    }

    public void setFont(GCInterface.EFont font) {
        switch (font) {
            case GRAPH: {
                this.gc.setFont(GUIResource.getInstance().getFontGraph());
                break;
            }
            case NOTE: {
                this.gc.setFont(GUIResource.getInstance().getFontNote());
                break;
            }
            case SMALL: {
                this.gc.setFont(GUIResource.getInstance().getFontSmall());
            }
        }
    }

    public void setForeground(GCInterface.EColor color) {
        this.gc.setForeground(this.getColor(color));
    }

    public void setLineStyle(GCInterface.ELineStyle lineStyle) {
        switch (lineStyle) {
            case DASHDOT: {
                this.gc.setLineStyle(4);
                break;
            }
            case SOLID: {
                this.gc.setLineStyle(1);
                break;
            }
            case DOT: {
                this.gc.setLineStyle(3);
                break;
            }
            case PARALLEL: {
                this.gc.setLineAttributes(new LineAttributes((float)this.gc.getLineWidth(), 1, 1, 6, new float[]{5.0f, 3.0f}, 0.0f, 10.0f));
            }
        }
    }

    public void setLineWidth(int width) {
        this.gc.setLineWidth(width);
    }

    public void setTransform(float translationX, float translationY, int shadowsize, float magnification) {
        if (this.transform != null) {
            this.transform.dispose();
        }
        this.transform = new Transform(this.gc.getDevice());
        this.transform.translate(translationX + (float)shadowsize * magnification, translationY + (float)shadowsize * magnification);
        this.transform.scale(magnification, magnification);
        this.gc.setTransform(this.transform);
    }

    public Point textExtent(String text) {
        org.eclipse.swt.graphics.Point p = this.gc.textExtent(text);
        return new Point(p.x, p.y);
    }

    public void drawStepIcon(int x, int y, StepMeta stepMeta) {
        this.gc.fillRectangle(x, y, this.iconsize, this.iconsize);
        String steptype = stepMeta.getStepID();
        Image im = this.images.get(steptype);
        if (im != null) {
            Rectangle bounds = im.getBounds();
            this.gc.drawImage(im, 0, 0, bounds.width, bounds.height, x, y, this.iconsize, this.iconsize);
        }
    }

    public void drawJobEntryIcon(int x, int y, JobEntryCopy jobEntryCopy) {
        if (jobEntryCopy == null) {
            return;
        }
        Image image = null;
        if (jobEntryCopy.isSpecial()) {
            if (jobEntryCopy.isStart()) {
                image = GUIResource.getInstance().getImageStart();
            }
            if (jobEntryCopy.isDummy()) {
                image = GUIResource.getInstance().getImageDummy();
            }
        } else {
            String configId = jobEntryCopy.getEntry().getPluginId();
            if (configId != null) {
                image = GUIResource.getInstance().getImagesJobentries().get(configId);
            }
        }
        if (image == null) {
            return;
        }
        Rectangle bounds = image.getBounds();
        this.gc.drawImage(image, 0, 0, bounds.width, bounds.height, x, y, this.iconsize, this.iconsize);
    }

    public void setAntialias(boolean antiAlias) {
        if (antiAlias) {
            this.gc.setAntialias(1);
        } else {
            this.gc.setAntialias(0);
        }
    }

    public void setBackground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setBackground(color);
    }

    public void setForeground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setForeground(color);
    }

    private Color getColor(int r, int g, int b) {
        Color color = new Color((Device)PropsUI.getDisplay(), new RGB(r, g, b));
        int index = this.colors.indexOf(color);
        if (index < 0) {
            this.colors.add(color);
        } else {
            color.dispose();
            color = this.colors.get(index);
        }
        return color;
    }

    public void setFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic) {
        Font font;
        int index;
        int swt = 0;
        if (fontBold) {
            swt = 1;
        }
        if (fontItalic) {
            swt |= 2;
        }
        if ((index = this.fonts.indexOf(font = new Font((Device)PropsUI.getDisplay(), fontName, fontSize, swt))) < 0) {
            this.fonts.add(font);
        } else {
            font.dispose();
            font = this.fonts.get(index);
        }
        this.gc.setFont(font);
    }

    public Object getImage() {
        return this.image;
    }

    public void switchForegroundBackgroundColors() {
        Color fg = this.gc.getForeground();
        Color bg = this.gc.getBackground();
        this.gc.setForeground(bg);
        this.gc.setBackground(fg);
    }

    public Point getArea() {
        return this.area;
    }
}

