/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ResourceBundle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.ChangedWarningInterface;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;

public class SpoonBrowser
implements TabItemInterface,
XulEventHandler {
    protected static final LogWriter log = LogWriter.getInstance();
    private static final Class<?> PKG = SpoonBrowser.class;
    private static final String XUL_FILE_BROWSER_TOOLBAR = "ui/browser-toolbar.xul";
    protected Shell shell;
    protected Spoon spoon;
    private String stringUrl;
    protected Composite composite;
    protected XulToolbar toolbar;
    protected Browser browser;
    private XulToolbarbutton back = null;
    private XulToolbarbutton forward = null;
    private XulTextbox location;

    public SpoonBrowser(Composite parent, Spoon spoon, String stringUrl, boolean isURL) throws SWTError {
        this(parent, spoon, stringUrl, isURL, true, null);
    }

    public SpoonBrowser(Composite parent, Spoon spoon, String stringUrl, boolean isURL, LocationListener listener) throws SWTError {
        this(parent, spoon, stringUrl, isURL, true, listener);
    }

    public SpoonBrowser(Composite parent, Spoon spoon, String stringUrl, boolean isURL, boolean showControls, LocationListener listener) throws SWTError {
        this.composite = new Composite(parent, 0);
        this.shell = parent.getShell();
        this.spoon = spoon;
        this.stringUrl = stringUrl;
        this.composite.setLayout((Layout)new FormLayout());
        if (showControls) {
            this.addToolBar();
            Control swtToolBar = (Control)this.toolbar.getManagedObject();
            FormData fdToolBar = (FormData)swtToolBar.getLayoutData();
            fdToolBar.left = new FormAttachment(0, 0);
            fdToolBar.right = new FormAttachment(100, 0);
            fdToolBar.top = new FormAttachment(0, 0);
        }
        this.browser = this.createBrowser();
        FormData fdBrowser = new FormData();
        fdBrowser.left = new FormAttachment(0, 0);
        fdBrowser.right = new FormAttachment(100, 0);
        fdBrowser.top = showControls ? new FormAttachment((Control)this.toolbar.getManagedObject(), 2) : new FormAttachment(0, 2);
        fdBrowser.bottom = new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)fdBrowser);
        LocationListener locationListener = new LocationListener(){

            public void changed(LocationEvent event) {
                Browser browser = (Browser)event.widget;
                if (SpoonBrowser.this.back != null) {
                    SpoonBrowser.this.back.setDisabled(!browser.isBackEnabled());
                    SpoonBrowser.this.forward.setDisabled(!browser.isForwardEnabled());
                    SpoonBrowser.this.location.setValue(browser.getUrl());
                }
            }

            public void changing(LocationEvent event) {
            }
        };
        this.browser.addLocationListener(locationListener);
        if (listener != null) {
            this.browser.addLocationListener(listener);
        }
        if (isURL) {
            this.browser.setUrl(stringUrl);
        } else {
            this.browser.setText(stringUrl);
        }
    }

    protected Browser createBrowser() {
        return new Browser(this.composite, 0);
    }

    public void addLocationListener(LocationListener listener) {
        this.browser.addLocationListener(listener);
    }

    protected void addToolBar() {
        try {
            SwtXulLoader loader = new SwtXulLoader();
            loader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
            ResourceBundle bundle = GlobalMessages.getBundle((String)"org/pentaho/di/ui/spoon/messages/messages");
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_BROWSER_TOOLBAR, (Object)bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            this.back = (XulToolbarbutton)this.toolbar.getElementById("browse-back");
            this.back.setDisabled(true);
            this.forward = (XulToolbarbutton)this.toolbar.getElementById("browse-forward");
            this.forward.setLabel(BaseMessages.getString(PKG, (String)"SpoonBrowser.Dialog.Forward", (String[])new String[0]));
            this.forward.setDisabled(false);
            this.location = (XulTextbox)this.toolbar.getElementById("browser-address");
            Control toolbarControl = (Control)this.toolbar.getManagedObject();
            toolbarControl.setLayoutData((Object)new FormData());
            toolbarControl.setParent(this.composite);
        }
        catch (Exception e) {
            e.printStackTrace();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_BROWSER_TOOLBAR}), e);
        }
    }

    public void openFile() {
        this.spoon.openFile();
    }

    public void browseBack() {
        this.browser.back();
    }

    public void browseForward() {
        this.browser.forward();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Spoon getSpoon() {
        return this.spoon;
    }

    public void setSpoon(Spoon spoon) {
        this.spoon = spoon;
    }

    public boolean applyChanges() {
        return true;
    }

    public boolean canBeClosed() {
        return true;
    }

    public Object getManagedObject() {
        return this.stringUrl;
    }

    public boolean hasContentChanged() {
        return false;
    }

    public int showChangedWarning() {
        return 0;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public EngineMetaInterface getMeta() {
        return null;
    }

    public boolean canHandleSave() {
        return false;
    }

    public boolean setFocus() {
        return false;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "browser";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }

    public void setControlStates() {
    }

    public ChangedWarningInterface getChangedWarning() {
        return null;
    }
}

